/* blinkensim - a Blinkenlights simulator
 *
 * Copyright (c) 2001-2002  Sven Neumann <sven@gimp.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <blib/blib-gtk.h>

#include "gfx.h"


static gboolean gfx_window_key_pressed       (GtkWidget   *widget,
                                              GdkEventKey *event,
                                              gpointer     data);
static void     gfx_window_toggle_fullscreen (GtkWidget   *window);


gboolean
gfx_init (gint    *argc,
          gchar ***argv,
          GError **error)
{
  gtk_init (argc, argv);

  return TRUE;
}

void
gfx_close (void)
{
}

GObject *
gfx_view_new (BTheme     *theme,
              GMainLoop  *loop,
              GError    **error)
{
  GtkWidget *window;
  GtkWidget *view;

  view = b_view_gtk_new (theme, error);

  if (!view)
    return FALSE;

  g_signal_connect_swapped (G_OBJECT (view), "destroy",
                            G_CALLBACK (g_main_loop_quit), loop);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window),
                        b_object_get_name (B_OBJECT (theme)));

  gtk_widget_add_events (window, GDK_KEY_PRESS_MASK);
  g_signal_connect (G_OBJECT (window), "key_press_event",
                    G_CALLBACK (gfx_window_key_pressed),
                    NULL);

  gtk_container_add (GTK_CONTAINER (window), view);
  gtk_widget_show (view);

  gtk_widget_show (window);

  return G_OBJECT (view);
}

void
gfx_view_update (GObject      *view,
                 const guchar *data)
{
  b_view_gtk_update (B_VIEW_GTK (view), data);
}


static gboolean
gfx_window_key_pressed (GtkWidget   *widget,
                        GdkEventKey *event,
                        gpointer     data)
{
  switch (gdk_keyval_to_unicode (event->keyval))
    {
    case 'f':
    case 'F':
      gfx_window_toggle_fullscreen (widget);
      break;

#if 0
    case 'q':
    case 'Q':
      gtk_widget_destroy (widget);
      break;
#endif

    default:
      break;
    }

  return TRUE;
}

static void
gfx_window_toggle_fullscreen (GtkWidget *window)
{
#if GTK_CHECK_VERSION(2,2,0)
  if (GPOINTER_TO_INT (g_object_get_data (G_OBJECT (window), "fullscreen")))
    {
      gtk_window_unfullscreen (window);
      g_object_set_data (G_OBJECT (window),
                         "fullscreen", GINT_TO_POINTER (FALSE));
    }
  else
    {
      gtk_window_fullscreen (window);
      g_object_set_data (G_OBJECT (window),
                         "fullscreen", GINT_TO_POINTER (TRUE));
    }
#else
  g_printerr ("Sorry, fullscreen mode requires GTK+-2.2.\n"
              "This version of blinkensim was compiled against an earlier version.\n");
#endif
}
