/*
 * Copyright (C) 2002-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * galeon_ui.c - 17.07.2003 - v0.2 - galeon_ui.c => xbel_ui.c
 *               23.12.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plugin.h"
#include "xbel_ui.h"
#include "bk_edit_misc.h"
#include "bk_edit_date.h"


GtkWidget *edit_ui_new (plugin *plug)
{
	GtkWidget *table, *frame;

	xbel_edit_ui *ui = (xbel_edit_ui *) malloc (sizeof (xbel_edit_ui));
	if (ui == NULL)
	{
		fprintf (stderr, "%s[%d]: xbel_edit_ui\n", __FILE__, __LINE__);
		return NULL;
	}
	plug->edit_ui_data = (void *) ui;

	ui->box = gtk_hbox_new (FALSE, 1);

	/* Content */
	ui->content = gtk_vbox_new (FALSE, 1);
	gtk_container_border_width (GTK_CONTAINER (ui->content), 1);
	ui->content_scrolled = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ui->content_scrolled), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width (GTK_CONTAINER (ui->content_scrolled), 1);

	/* XBEL, Mozilla, NN4, Opera */
	/* Name, URI */
	bk_edit_misc_input_create (&ui->name, "Name:");
	bk_edit_misc_input_create (&ui->uri, "URI:");

	/* Comment Box */
	ui->comment_box = gtk_hbox_new (FALSE, 1);
	ui->comment_entry = gtk_text_new (NULL, NULL);
	gtk_text_set_editable (GTK_TEXT (ui->comment_entry), TRUE);
	ui->comment_label = gtk_label_new ("Comment:");
	gtk_label_set_justify (GTK_LABEL (ui->comment_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (ui->comment_label), 0.0, 0.0);
	ui->comment_scrollbar = gtk_vscrollbar_new (GTK_TEXT (ui->comment_entry)->vadj);

	/* */
	gtk_box_pack_start (GTK_BOX (ui->comment_box), ui->comment_entry, TRUE, TRUE, 1);
	gtk_box_pack_start (GTK_BOX (ui->comment_box), ui->comment_scrollbar, FALSE, FALSE, 1);

	table = gtk_table_new (2, 3, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->name.label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->name.entry, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.entry, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->comment_label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->comment_box, 1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* XBEL, Mozilla, NN4, Opera */
	/* add date, last visit */
	bk_edit_misc_input_create (&ui->add_date, "Add On:");
	bk_edit_misc_input_create (&ui->last_visit, "Last Visit:");

	/* last modification */
	bk_edit_misc_input_create (&ui->last_mod, "Mod. On:");

	table = gtk_table_new (2, 3, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->add_date.label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->add_date.entry, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_visit.label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_visit.entry, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_mod.label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_mod.entry, 1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new ("Date");
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* XBEL, Mozilla, NN4 */
	/* Alias */
	bk_edit_misc_input_create (&ui->id, "ID:");
	bk_edit_misc_input_create (&ui->ref, "Ref:");

	table = gtk_table_new (2, 2, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->id.label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->id.entry, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ref.label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ref.entry, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new ("Alias");
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);


	/* XBEL */
	bk_edit_misc_input_create (&ui->version, "Version:");

	/* Metadata Box */
	ui->metadata_box = gtk_hbox_new (FALSE, 1);
	ui->metadata_entry = gtk_text_new (NULL, NULL);
	gtk_text_set_editable (GTK_TEXT (ui->metadata_entry), TRUE);
	ui->metadata_label = gtk_label_new ("Metadata:");
	gtk_label_set_justify (GTK_LABEL (ui->metadata_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (ui->metadata_label), 0.0, 0.0);
	ui->metadata_scrollbar = gtk_vscrollbar_new (GTK_TEXT (ui->metadata_entry)->vadj);

	/* */
	gtk_box_pack_start (GTK_BOX (ui->metadata_box), ui->metadata_entry, TRUE, TRUE, 1);
	gtk_box_pack_start (GTK_BOX (ui->metadata_box), ui->metadata_scrollbar, FALSE, FALSE, 1);

	table = gtk_table_new (2, 2, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->version.label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->version.entry, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->metadata_label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->metadata_box, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* */
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ui->content_scrolled), ui->content);
	gtk_box_pack_start (GTK_BOX (ui->box), ui->content_scrolled, TRUE, TRUE, 5);

	/* */
	gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (ui->content_scrolled)->child), GTK_SHADOW_NONE);

	return ui->box;
}


void edit_ui_delete (plugin *plug)
{
}


void edit_ui_get (plugin *plug, bk_edit_tree_data *node_data)
{
	xbel_edit_ui *ui = (xbel_edit_ui *) plug->edit_ui_data;

	/* XBEL, Mozilla, NN4, Opera */
	free (node_data->elements[NAME]);
        node_data->elements[NAME] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->name.entry)));

	free (node_data->elements[URI]);
        node_data->elements[URI] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->uri.entry)));

	free (node_data->elements[COMMENT]);
	node_data->elements[COMMENT] = strdup (gtk_editable_get_chars (GTK_EDITABLE (ui->comment_entry), 0, -1));

	free (node_data->elements[ADD_DATE]);
	node_data->elements[ADD_DATE] = strdup (gtk_editable_get_chars (GTK_EDITABLE (ui->add_date.entry), 0, -1));

	free (node_data->elements[LAST_VISIT]);
	node_data->elements[LAST_VISIT] = strdup (gtk_editable_get_chars (GTK_EDITABLE (ui->last_visit.entry), 0, -1));

	/* XBEL, Mozilla, NN4 */
	free (node_data->elements[LAST_MODIFIED]);
	node_data->elements[LAST_MODIFIED] = strdup (gtk_editable_get_chars (GTK_EDITABLE (ui->last_mod.entry), 0, -1));

	/* XBEL, Mozilla, NN4 */
	free (node_data->elements[ID]);
	node_data->elements[ID] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->id.entry)));

	/* XBEL */
	free (node_data->elements[REF]);
	node_data->elements[REF] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->ref.entry)));

	free (node_data->elements[METADATA]);
	node_data->elements[METADATA] = strdup (gtk_editable_get_chars (GTK_EDITABLE (ui->metadata_entry), 0, -1));

	free (node_data->elements[VERSION]);
	node_data->elements[VERSION] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->version.entry)));
}


void edit_ui_set (plugin *plug, bk_edit_tree_data *node_data)
{
	xbel_edit_ui *ui = (xbel_edit_ui *) plug->edit_ui_data;
	static int previous_type = -1;

	if (previous_type != node_data->type)
	{
		style edit_style;

		previous_type = node_data->type;

		if (node_data->type == BOOKMARK)
		{
			edit_style = plug->bookmark_edit_dialog_style;
		}
		else if (node_data->type == FOLDER)
		{
			edit_style = plug->folder_edit_dialog_style;
		}
		else if (node_data->type == SEPARATOR)
		{
			edit_style = plug->separator_edit_dialog_style;
		}
		else if (node_data->type == TOP)
		{
			edit_style = plug->root_edit_dialog_style;
		}

		bk_edit_misc_toggle_widget (ui->name.entry, edit_style.name);
		bk_edit_misc_toggle_widget (ui->name.label, edit_style.name);

		bk_edit_misc_toggle_widget (ui->uri.entry, edit_style.uri);
		bk_edit_misc_toggle_widget (ui->uri.label, edit_style.uri);

		bk_edit_misc_toggle_widget (ui->add_date.entry, edit_style.add_date);
		bk_edit_misc_toggle_widget (ui->add_date.label, edit_style.add_date);

		bk_edit_misc_toggle_widget (ui->last_visit.entry, edit_style.last_visit);
		bk_edit_misc_toggle_widget (ui->last_visit.label, edit_style.last_visit);

		bk_edit_misc_toggle_widget (ui->last_mod.entry, edit_style.last_modified);
		bk_edit_misc_toggle_widget (ui->last_mod.label, edit_style.last_modified);

		bk_edit_misc_toggle_widget (ui->comment_box, edit_style.comment);
		bk_edit_misc_toggle_widget (ui->comment_label, edit_style.comment);

		bk_edit_misc_toggle_widget (ui->id.entry, edit_style.id);
		bk_edit_misc_toggle_widget (ui->id.label, edit_style.id);

		bk_edit_misc_toggle_widget (ui->ref.entry, edit_style.ref);
		bk_edit_misc_toggle_widget (ui->ref.label, edit_style.ref);

		bk_edit_misc_toggle_widget (ui->version.entry, edit_style.version);
		bk_edit_misc_toggle_widget (ui->version.label, edit_style.version);

		gtk_widget_set_usize (GTK_WIDGET (ui->content), -1, -1);
	}

	/* */
	gtk_widget_grab_focus (ui->name.entry);

	/* XBEL, Mozilla, NN4, Opera */
	gtk_entry_set_text (GTK_ENTRY (ui->name.entry), node_data->elements[NAME]);
	gtk_entry_set_text (GTK_ENTRY (ui->uri.entry), node_data->elements[URI]);

	gtk_editable_delete_text (GTK_EDITABLE (ui->comment_entry), 0, -1);
	gtk_text_insert (GTK_TEXT (ui->comment_entry), NULL, NULL, NULL, node_data->elements[COMMENT], strlen (node_data->elements[COMMENT]));

	gtk_entry_set_text (GTK_ENTRY (ui->add_date.entry), node_data->elements[ADD_DATE]);
	gtk_entry_set_text (GTK_ENTRY (ui->last_visit.entry), node_data->elements[LAST_VISIT]);

	/* XBEL, Mozilla, NN4 */
	gtk_entry_set_text (GTK_ENTRY (ui->last_mod.entry), node_data->elements[LAST_MODIFIED]);

	gtk_entry_set_text (GTK_ENTRY (ui->id.entry), node_data->elements[ID]);

	/* XBEL */
	gtk_entry_set_text (GTK_ENTRY (ui->ref.entry), node_data->elements[REF]);
	gtk_entry_set_text (GTK_ENTRY (ui->version.entry), node_data->elements[VERSION]);

	gtk_editable_delete_text (GTK_EDITABLE (ui->metadata_entry), 0, -1);
	gtk_text_insert (GTK_TEXT (ui->metadata_entry), NULL, NULL, NULL, node_data->elements[METADATA], strlen (node_data->elements[METADATA]));
}

