/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * opera7_ui.c - 25.04.2003 - v0.1 - opera_ui.c => opera7_ui.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "plugin.h"
#include "opera7_ui.h"
#include "bk_edit_misc.h"
#include "bk_edit_date.h"


GtkWidget *edit_ui_new (plugin *plug)
{
	GtkWidget *table, *frame;

	opera_edit_ui *ui = (opera_edit_ui *) malloc (sizeof (opera_edit_ui));
	if (ui == NULL)
	{
		fprintf (stderr, "%s[%d]: opera_edit_ui\n", __FILE__, __LINE__);
		return NULL;
	}
	plug->edit_ui_data = (void *) ui;

	ui->box = gtk_hbox_new (FALSE, 1);

	/* Content */
	ui->content = gtk_vbox_new (FALSE, 1);
	gtk_container_border_width (GTK_CONTAINER (ui->content), 1);
	ui->content_scrolled = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ui->content_scrolled), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width (GTK_CONTAINER (ui->content_scrolled), 1);

	/* Galeon, Mozilla, NN4, Opera */
	/* Name, URI */
	bk_edit_misc_input_create (&ui->name, "Name:");
	bk_edit_misc_input_create (&ui->uri, "URI:");

	/* Comment Box */
	ui->comment_box = gtk_hbox_new (FALSE, 1);
	ui->comment_entry = gtk_text_new (NULL, NULL);
	gtk_text_set_editable (GTK_TEXT (ui->comment_entry), TRUE);
	ui->comment_label = gtk_label_new ("Comment:");
	gtk_label_set_justify (GTK_LABEL (ui->comment_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (ui->comment_label), 0.0, 0.0);
	ui->comment_scrollbar = gtk_vscrollbar_new (GTK_TEXT (ui->comment_entry)->vadj);

	/* */
	gtk_box_pack_start (GTK_BOX (ui->comment_box), ui->comment_entry, TRUE, TRUE, 1);
	gtk_box_pack_start (GTK_BOX (ui->comment_box), ui->comment_scrollbar, FALSE, FALSE, 1);

	table = gtk_table_new (2, 3, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->name.label,    0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->name.entry,    1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.label,     0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.entry,     1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->comment_label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->comment_box,   1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* Galeon, Mozilla, NN4, Opera */
	/* add date, last visit */
	bk_edit_date_create (&ui->add_date, "Add On:");
	bk_edit_date_create (&ui->last_visit, "Last Visit:");

	table = gtk_table_new (2, 2, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->add_date.label,   0, 1, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->add_date.box,     1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_visit.label, 0, 1, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_visit.box,   1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);

	frame = gtk_frame_new ("Date");
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* Opera */
	bk_edit_misc_input_create (&ui->short_name, "Shortname:");
	bk_edit_misc_input_create (&ui->nickname, "Nickname:");
	bk_edit_misc_input_create (&ui->order, "Order:");
	bk_edit_misc_input_create (&ui->trash_folder, "Trash Folder:");
	bk_edit_misc_input_create (&ui->on_personalbar, "On Personalbar:");
	bk_edit_misc_input_create (&ui->personalbar_pos, "Personalbar Pos:");
	bk_edit_misc_input_create (&ui->active, "Active:");
	bk_edit_misc_input_create (&ui->in_panel, "In Panel:");
	bk_edit_misc_input_create (&ui->panel_pos, "Panel Pos:");
	bk_edit_misc_input_create (&ui->linkbar_folder, "Linkbar Folder:");
	bk_edit_misc_input_create (&ui->linkbar_stop, "Linkbar Stop:");

	table = gtk_table_new (2, 11, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->order.label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->order.entry, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->short_name.label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->short_name.entry, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->nickname.label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->nickname.entry, 1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->trash_folder.label, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->trash_folder.entry, 1, 2, 3, 4, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->on_personalbar.label, 0, 1, 4, 5, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->on_personalbar.entry, 1, 2, 4, 5, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->personalbar_pos.label, 0, 1, 5, 6, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->personalbar_pos.entry, 1, 2, 5, 6, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->active.label, 0, 1, 6, 7, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->active.entry, 1, 2, 6, 7, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->in_panel.label, 0, 1, 7, 8, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->in_panel.entry, 1, 2, 7, 8, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->panel_pos.label, 0, 1, 8, 9, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->panel_pos.entry, 1, 2, 8, 9, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->linkbar_folder.label, 0, 1, 9, 10, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->linkbar_folder.entry, 1, 2, 9, 10, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->linkbar_stop.label, 0, 1, 10, 11, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->linkbar_stop.entry, 1, 2, 10, 11, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* */
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ui->content_scrolled), ui->content);
	gtk_box_pack_start (GTK_BOX (ui->box), ui->content_scrolled, TRUE, TRUE, 5);

	/* */
	gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (ui->content_scrolled)->child), GTK_SHADOW_NONE);

	return ui->box;
}


void edit_ui_delete (plugin *plug)
{
}


void edit_ui_get (plugin *plug, bk_edit_tree_data *node_data)
{
	opera_edit_ui *ui = (opera_edit_ui *) plug->edit_ui_data;

	/* Galeon, Mozilla, NN4, Opera */
	free (node_data->elements[NAME]);
        node_data->elements[NAME] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->name.entry)));

	free (node_data->elements[URI]);
        node_data->elements[URI] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->uri.entry)));

	free (node_data->elements[COMMENT]);
	node_data->elements[COMMENT] = strdup (gtk_editable_get_chars (GTK_EDITABLE (ui->comment_entry), 0, -1));

	free (node_data->elements[ADD_DATE]);
	node_data->elements[ADD_DATE] = strdup (bk_edit_date_get_timestamp (&ui->add_date));

	free (node_data->elements[LAST_VISIT]);
	node_data->elements[LAST_VISIT] = strdup (bk_edit_date_get_timestamp (&ui->last_visit));

	/* Opera */
	free (node_data->elements[ORDER]);
	node_data->elements[ORDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->order.entry)));

	free (node_data->elements[SHORT_NAME]);
	node_data->elements[SHORT_NAME] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->short_name.entry)));

	free (node_data->elements[NICKNAME]);
	node_data->elements[NICKNAME] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->nickname.entry)));

	/* Opera 7 */
	free (node_data->elements[TRASH_FOLDER]);
	node_data->elements[TRASH_FOLDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->trash_folder.entry)));

	free (node_data->elements[ON_PERSONALBAR]);
	node_data->elements[ON_PERSONALBAR] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->on_personalbar.entry)));

	free (node_data->elements[PERSONALBAR_POS]);
	node_data->elements[PERSONALBAR_POS] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->personalbar_pos.entry)));

	free (node_data->elements[ACTIVE]);
	node_data->elements[ACTIVE] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->active.entry)));

	free (node_data->elements[IN_PANEL]);
	node_data->elements[IN_PANEL] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->in_panel.entry)));

	free (node_data->elements[PANEL_POS]);
	node_data->elements[PANEL_POS] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->panel_pos.entry)));

	free (node_data->elements[LINKBAR_FOLDER]);
	node_data->elements[LINKBAR_FOLDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->linkbar_folder.entry)));

	free (node_data->elements[LINKBAR_STOP]);
	node_data->elements[LINKBAR_STOP] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->linkbar_stop.entry)));
}


void edit_ui_set (plugin *plug, bk_edit_tree_data *node_data)
{
	opera_edit_ui *ui = (opera_edit_ui *) plug->edit_ui_data;
	static int previous_type = -1;

	if (previous_type != node_data->type)
	{
		style edit_style;

		previous_type = node_data->type;

		if (node_data->type == BOOKMARK)
		{
			edit_style = plug->bookmark_edit_dialog_style;
		}
		else if (node_data->type == FOLDER)
		{
			edit_style = plug->folder_edit_dialog_style;
		}
		else if (node_data->type == SEPARATOR)
		{
			edit_style = plug->separator_edit_dialog_style;
		}
		else if (node_data->type == TOP)
		{
			edit_style = plug->root_edit_dialog_style;
		}

		bk_edit_misc_toggle_widget (ui->name.entry, edit_style.name);
		bk_edit_misc_toggle_widget (ui->name.label, edit_style.name);

		bk_edit_misc_toggle_widget (ui->uri.entry, edit_style.uri);
		bk_edit_misc_toggle_widget (ui->uri.label, edit_style.uri);

		bk_edit_misc_toggle_widget (ui->add_date.box, edit_style.add_date);
		bk_edit_misc_toggle_widget (ui->add_date.label, edit_style.add_date);

		bk_edit_misc_toggle_widget (ui->last_visit.box, edit_style.last_visit);
		bk_edit_misc_toggle_widget (ui->last_visit.label, edit_style.last_visit);

		bk_edit_misc_toggle_widget (ui->comment_box, edit_style.comment);
		bk_edit_misc_toggle_widget (ui->comment_label, edit_style.comment);

		bk_edit_misc_toggle_widget (ui->order.entry, edit_style.order);
		bk_edit_misc_toggle_widget (ui->order.label, edit_style.order);

		bk_edit_misc_toggle_widget (ui->short_name.entry, edit_style.short_name);
		bk_edit_misc_toggle_widget (ui->short_name.label, edit_style.short_name);

		bk_edit_misc_toggle_widget (ui->nickname.entry, edit_style.nickname);
		bk_edit_misc_toggle_widget (ui->nickname.label, edit_style.nickname);

		bk_edit_misc_toggle_widget (ui->trash_folder.entry, edit_style.trash_folder);
		bk_edit_misc_toggle_widget (ui->trash_folder.label, edit_style.trash_folder);

		bk_edit_misc_toggle_widget (ui->on_personalbar.entry, edit_style.on_personalbar);
		bk_edit_misc_toggle_widget (ui->on_personalbar.label, edit_style.on_personalbar);

		bk_edit_misc_toggle_widget (ui->personalbar_pos.entry, edit_style.personalbar_pos);
		bk_edit_misc_toggle_widget (ui->personalbar_pos.label, edit_style.personalbar_pos);

		bk_edit_misc_toggle_widget (ui->active.entry, edit_style.active);
		bk_edit_misc_toggle_widget (ui->active.label, edit_style.active);

		bk_edit_misc_toggle_widget (ui->in_panel.entry, edit_style.in_panel);
		bk_edit_misc_toggle_widget (ui->in_panel.label, edit_style.in_panel);

		bk_edit_misc_toggle_widget (ui->panel_pos.entry, edit_style.panel_pos);
		bk_edit_misc_toggle_widget (ui->panel_pos.label, edit_style.panel_pos);

		bk_edit_misc_toggle_widget (ui->linkbar_folder.entry, edit_style.linkbar_folder);
		bk_edit_misc_toggle_widget (ui->linkbar_folder.label, edit_style.linkbar_folder);

		bk_edit_misc_toggle_widget (ui->linkbar_stop.entry, edit_style.linkbar_stop);
		bk_edit_misc_toggle_widget (ui->linkbar_stop.label, edit_style.linkbar_stop);

		gtk_widget_set_usize (GTK_WIDGET (ui->content), -1, -1);
	}

	gtk_widget_grab_focus (ui->name.entry);

	/* Galeon, Mozilla, NN4, Opera */
	gtk_entry_set_text (GTK_ENTRY (ui->name.entry), node_data->elements[NAME]);
	gtk_entry_set_text (GTK_ENTRY (ui->uri.entry), node_data->elements[URI]);

	gtk_editable_delete_text (GTK_EDITABLE (ui->comment_entry), 0, -1);
	gtk_text_insert (GTK_TEXT (ui->comment_entry), NULL, NULL, NULL, node_data->elements[COMMENT], strlen (node_data->elements[COMMENT]));

	bk_edit_date_fill (&ui->add_date,   node_data->elements[ADD_DATE]);
	bk_edit_date_fill (&ui->last_visit, node_data->elements[LAST_VISIT]);

	/* Opera */
	gtk_entry_set_text (GTK_ENTRY (ui->order.entry), node_data->elements[ORDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->short_name.entry), node_data->elements[SHORT_NAME]);
	gtk_entry_set_text (GTK_ENTRY (ui->nickname.entry), node_data->elements[NICKNAME]);

	/* Opera 7 */
	gtk_entry_set_text (GTK_ENTRY (ui->trash_folder.entry), node_data->elements[TRASH_FOLDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->on_personalbar.entry), node_data->elements[ON_PERSONALBAR]);
	gtk_entry_set_text (GTK_ENTRY (ui->personalbar_pos.entry), node_data->elements[PERSONALBAR_POS]);
	gtk_entry_set_text (GTK_ENTRY (ui->active.entry), node_data->elements[ACTIVE]);
	gtk_entry_set_text (GTK_ENTRY (ui->in_panel.entry), node_data->elements[IN_PANEL]);
	gtk_entry_set_text (GTK_ENTRY (ui->panel_pos.entry), node_data->elements[PANEL_POS]);
	gtk_entry_set_text (GTK_ENTRY (ui->linkbar_folder.entry), node_data->elements[LINKBAR_FOLDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->linkbar_stop.entry), node_data->elements[LINKBAR_STOP]);
}

