%{

/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * opera7_parse.lex - 25.04.2003 - v0.1 - opera_parse.lex => opera7_parse.lex
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <string.h>

#include "opera7_parse.h"
#include "opera7_parse.yacc.h"

#include "char_vector.h"

#undef YY_USES_REJECT

%}

%option noyywrap

%option yylineno


%x TEXT


%%

%{
/************************************************************************
 * header
 ************************************************************************/
%}

"Opera Hotlist version 2.0"           { return OPERA_HOTLIST; }
"Options: encoding = utf8, version=3" { /* void */ }

%{
/************************************************************************
 * folder/bookmark
 ************************************************************************/
%}

"#FOLDER"		{ return FOLDER; }
"#URL"			{ return BOOKMARK; }


"NAME="			{ BEGIN (TEXT); return NAME; }
"URL="			{ BEGIN (TEXT); return URL; }
"CREATED="		{ BEGIN (TEXT); return CREATED; }
"VISITED="		{ BEGIN (TEXT); return VISITED; }
"ORDER="		{ BEGIN (TEXT); return ORDER; }
"EXPANDED="		{ BEGIN (TEXT); return EXPANDED; }
"DESCRIPTION="		{ BEGIN (TEXT); return DESCRIPTION; }
"SHORT NAME="		{ BEGIN (TEXT); return SHORT_NAME; }
"NICKNAME="		{ BEGIN (TEXT); return NICKNAME; }

"TRASH FOLDER="		{ BEGIN (TEXT); return TRASH_FOLDER; }
"ON PERSONALBAR="	{ BEGIN (TEXT); return ON_PERSONALBAR; }
"PERSONALBAR_POS="	{ BEGIN (TEXT); return PERSONALBAR_POS; }
"ACTIVE="		{ BEGIN (TEXT); return ACTIVE; }
"IN PANEL="		{ BEGIN (TEXT); return IN_PANEL; }
"PANEL_POS="		{ BEGIN (TEXT); return PANEL_POS; }
"LINKBAR FOLDER="	{ BEGIN (TEXT); return LINKBAR_FOLDER; }
"LINKBAR STOP="		{ BEGIN (TEXT); return LINKBAR_STOP; }

<TEXT>.*$		{ BEGIN (INITIAL); yylval = (YYSTYPE) strdup (yytext); return LITERAL; }

"-"			{ return FOLDER_LEAVE; }


%{
/************************************************************************
 * misc
 ************************************************************************/
%}

.	{ /* void */ }
\n	{ /* void */ }

%%


void yyerror (char *error_message)
{
	BEGIN (INITIAL);

	fprintf (stderr, "%s[%d]: %s at line %d before `%s' (error).\n", __FILE__, __LINE__, error_message, yylineno, yytext);
	parse_yyerror (__FILE__, yylineno, error_message, yytext);

	yylineno = 1;
}

