#ifndef OPERA_PARSE_H
#define OPERA_PARSE_H

#define OPERA_PARSE_OK				0
#define OPERA_PARSE_KO				10
#define OPERA_PARSE_NO_SUCH_FILE		20
#define OPERA_PARSE_OUT_OF_MEMORY		30
#define OPERA_PARSE_FOLDER_STACK_OVERRUN	40
#define OPERA_PARSE_FOLDER_STACK_UNDERRUN	50

/************************************************************************
 * bookmark
 ************************************************************************/

typedef struct bookmark_attr_tag
{
	char *name;
	char *url;
	char *description;
	char *created;
	char *visited;
	char *order;
	char *short_name;
	char *nickname;

	char *on_personalbar;
	char *personalbar_pos;
	char *active;
	char *in_panel;
	char *panel_pos;
} bookmark_attr;

/************************************************************************
 * folder
 ************************************************************************/

typedef struct folder_attr_tag
{
	char *name;
	char *description;
	char *created;
	char *visited;
	char *order;
	char *short_name;
	char *nickname;

	char *trash_folder;
	char *on_personalbar;
	char *personalbar_pos;
	char *active;
	char *in_panel;
	char *panel_pos;
	char *linkbar_folder;
	char *linkbar_stop;
} folder_attr;

/************************************************************************
 * parse
 ************************************************************************/

typedef struct opera_parse_tag
{
	bookmark_attr  b_attr;
	folder_attr f_attr;

	char *filename;
} opera_parse;


/* callback functions */
int title_do_something (char *title);

int bookmark_new (void);
int bookmark_reset (void);
int bookmark (bookmark_attr b_attr);

int folder_new (void);
int folder_reset (void);
int folder_end (void);
int folder (folder_attr f_attr);


void parse_yyerror (char *file, int line, char *error_message, char *yytext);

#endif
