/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * opera7_parse.c - 25.04.2003 - v0.1 - opera_parse.c => opera7_parse.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "bk_edit_icon.h"
#include "bk_edit_tree.h"
#include "bk_edit_dialog_info.h"

#include "opera7_misc.h"
#include "opera7_parse.h"

opera_parse *opera;

/* callback functions */
int bookmark_new (void)
{
	memset (&opera->b_attr, 0, sizeof (opera->b_attr));

	return OPERA_PARSE_OK;
}


int bookmark_reset (void)
{
	if (opera->b_attr.name            != NULL) free (opera->b_attr.name);
	if (opera->b_attr.url             != NULL) free (opera->b_attr.url);
	if (opera->b_attr.description     != NULL) free (opera->b_attr.description);
	if (opera->b_attr.created         != NULL) free (opera->b_attr.created);
	if (opera->b_attr.visited         != NULL) free (opera->b_attr.visited);
	if (opera->b_attr.order           != NULL) free (opera->b_attr.order);
	if (opera->b_attr.short_name      != NULL) free (opera->b_attr.short_name);
	if (opera->b_attr.nickname        != NULL) free (opera->b_attr.nickname);
	if (opera->b_attr.on_personalbar  != NULL) free (opera->b_attr.on_personalbar);
	if (opera->b_attr.personalbar_pos != NULL) free (opera->b_attr.personalbar_pos);
	if (opera->b_attr.active          != NULL) free (opera->b_attr.active);
	if (opera->b_attr.in_panel        != NULL) free (opera->b_attr.in_panel);
	if (opera->b_attr.panel_pos       != NULL) free (opera->b_attr.panel_pos);

	return OPERA_PARSE_OK;
}


int bookmark (bookmark_attr b_attr)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME]            = b_attr.name;
	node_data.elements[URI]             = b_attr.url;
	node_data.elements[ADD_DATE]        = b_attr.created;
	node_data.elements[LAST_VISIT]      = b_attr.visited;
	node_data.elements[ORDER]           = b_attr.order;
	node_data.elements[SHORT_NAME]      = b_attr.short_name;
	node_data.elements[NICKNAME]        = b_attr.nickname;
	node_data.elements[ON_PERSONALBAR]  = b_attr.on_personalbar;
	node_data.elements[PERSONALBAR_POS] = b_attr.personalbar_pos;
	node_data.elements[ACTIVE]          = b_attr.active;
	node_data.elements[IN_PANEL]        = b_attr.in_panel;
	node_data.elements[PANEL_POS]       = b_attr.panel_pos;

	if (b_attr.description != NULL)
	{
		node_data.elements[COMMENT] = opera_text_decode (b_attr.description);
	}

	bk_edit_tree_add_bookmark_node (&node_data);

	if (node_data.elements[COMMENT] != NULL)
	{
		free (node_data.elements[COMMENT]);
	}

	return OPERA_PARSE_OK;
}


int folder_new (void)
{
	memset (&opera->f_attr, 0, sizeof (opera->f_attr));

	return OPERA_PARSE_OK;
}


int folder_reset (void)
{
	if (opera->f_attr.name            != NULL) free (opera->f_attr.name);
	if (opera->f_attr.description     != NULL) free (opera->f_attr.description);
	if (opera->f_attr.created         != NULL) free (opera->f_attr.created);
	if (opera->f_attr.visited         != NULL) free (opera->f_attr.visited);
	if (opera->f_attr.order           != NULL) free (opera->f_attr.order);
	if (opera->f_attr.short_name      != NULL) free (opera->f_attr.short_name);
	if (opera->f_attr.nickname        != NULL) free (opera->f_attr.nickname);
	if (opera->f_attr.trash_folder    != NULL) free (opera->f_attr.trash_folder);
	if (opera->f_attr.on_personalbar  != NULL) free (opera->f_attr.on_personalbar);
	if (opera->f_attr.personalbar_pos != NULL) free (opera->f_attr.personalbar_pos);
	if (opera->f_attr.active          != NULL) free (opera->f_attr.active);
	if (opera->f_attr.in_panel        != NULL) free (opera->f_attr.in_panel);
	if (opera->f_attr.panel_pos       != NULL) free (opera->f_attr.panel_pos);
	if (opera->f_attr.linkbar_folder  != NULL) free (opera->f_attr.linkbar_folder);
	if (opera->f_attr.linkbar_stop    != NULL) free (opera->f_attr.linkbar_stop);

	return OPERA_PARSE_OK;
}


int folder_end (void)
{
	bk_edit_tree_leave_folder ();

	return OPERA_PARSE_OK;
}


int folder (folder_attr f_attr)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME]            = f_attr.name;
	node_data.elements[COMMENT]         = f_attr.description;
	node_data.elements[ADD_DATE]        = f_attr.created;
	node_data.elements[LAST_VISIT]      = f_attr.visited;
	node_data.elements[ORDER]           = f_attr.order;
	node_data.elements[SHORT_NAME]      = f_attr.short_name;
	node_data.elements[NICKNAME]        = f_attr.nickname;
	node_data.elements[TRASH_FOLDER]    = f_attr.trash_folder;
	node_data.elements[ON_PERSONALBAR]  = f_attr.on_personalbar;
	node_data.elements[PERSONALBAR_POS] = f_attr.personalbar_pos;
	node_data.elements[ACTIVE]          = f_attr.active;
	node_data.elements[IN_PANEL]        = f_attr.in_panel;
	node_data.elements[PANEL_POS]       = f_attr.panel_pos;
	node_data.elements[LINKBAR_FOLDER]  = f_attr.linkbar_folder;
	node_data.elements[LINKBAR_STOP]    = f_attr.linkbar_stop;

	if (f_attr.description != NULL)
	{
		node_data.elements[COMMENT] = opera_text_decode (f_attr.description);
	}

	bk_edit_tree_add_folder_node (&node_data);

	if (node_data.elements[COMMENT] != NULL)
	{
		free (node_data.elements[COMMENT]);
	}

	return OPERA_PARSE_OK;
}


void parse_yyerror (char *file, int line, char *error_message, char *yytext)
{
	gchar *error = g_strdup_printf ("%s in file %s at line %d before `%s'.\n", error_message, opera->filename, line, yytext);
	bk_edit_dialog_info ("bk edit - error", error, icon_warning);
	g_print ("%s", error);
}

