/*
 * Copyright (C) 2002 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * opera_misc.c - 08.03.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


char *opera_text_decode (char *text)
{
	char *t, *tt, *ttt;

	if (text == NULL)
	{
		return NULL;
	}

	t = text = strdup (text);

	while ((t = strstr (t, "\x02\x02")) != NULL)
	{
		*t = '\n';

		/* strcpy (t+1, t+2); */
		ttt = tt = ++t;
		while (*tt != '\0')
		{
			*ttt++ = *++tt;
		}
	}

	return text;
}


char *opera_text_encode (char *text)
{
	int newlines = 0;
	char *new, *n, *t;


	t = text;
	while (*t != '\0')
	{
		if (*t++ == '\n')
		{
			newlines++;
		}
	}

	n = new = (char *) malloc (strlen (text) + newlines + 1);

	t = text;
	while (*t != '\0')
	{
		if (*t == '\n')
		{
			*n++ = '\x02';
			*n++ = '\x02';
			t++;
			continue;
		}
		*n++ = *t++;
	}
	*n = '\0';

	return new;
}

