/*
 * Copyright (C) 2002 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * nn4_ui.c - 23.12.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plugin.h"
#include "nn4_ui.h"
#include "bk_edit_misc.h"
#include "bk_edit_date.h"


GtkWidget *edit_ui_new (plugin *plug)
{
	GtkWidget *table, *frame, *align;

	GtkObject *adjustment;

	gint width;

	nn4_edit_ui *ui = (nn4_edit_ui *) malloc (sizeof (nn4_edit_ui));
	if (ui == NULL)
	{
		fprintf (stderr, "%s[%d]: nn4_edit_ui\n", __FILE__, __LINE__);
		return NULL;
	}
	plug->edit_ui_data = (void *) ui;

	ui->box = gtk_hbox_new (FALSE, 1);

	/* Content */
	ui->content = gtk_vbox_new (FALSE, 1);
	gtk_container_border_width (GTK_CONTAINER (ui->content), 1);
	ui->content_scrolled = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ui->content_scrolled), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width (GTK_CONTAINER (ui->content_scrolled), 1);

	/* Galeon, Mozilla, NN4, Opera */
	/* Name, URI */
	bk_edit_misc_input_create (&ui->name, "Name:");
	bk_edit_misc_input_create (&ui->uri, "URI:");

	/* Comment Box */
	ui->comment_box = gtk_hbox_new (FALSE, 1);
	ui->comment_entry = gtk_text_new (NULL, NULL);
	gtk_text_set_editable (GTK_TEXT (ui->comment_entry), TRUE);
	ui->comment_label = gtk_label_new ("Comment:");
	gtk_label_set_justify (GTK_LABEL (ui->comment_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (ui->comment_label), 0.0, 0.0);
	ui->comment_scrollbar = gtk_vscrollbar_new (GTK_TEXT (ui->comment_entry)->vadj);

	/* */
	gtk_box_pack_start (GTK_BOX (ui->comment_box), ui->comment_entry, TRUE, TRUE, 1);
	gtk_box_pack_start (GTK_BOX (ui->comment_box), ui->comment_scrollbar, FALSE, FALSE, 1);

	table = gtk_table_new (2, 3, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->name.label,    0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->name.entry,    1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.label,     0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.entry,     1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->comment_label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->comment_box,   1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* Galeon, Mozilla, NN4, Opera */
	/* add date, last visit */
	bk_edit_date_create (&ui->add_date, "Add On:");
	bk_edit_date_create (&ui->last_visit, "Last Visit:");

	/* last modification */
	bk_edit_date_create (&ui->last_mod, "Mod. On:");

	table = gtk_table_new (2, 3, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->add_date.label,   0, 1, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->add_date.box,     1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_visit.label, 0, 1, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_visit.box,   1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_mod.label,   0, 1, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_mod.box,     1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);

	frame = gtk_frame_new ("Date");
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* Mozilla, NN4 */
	/* Alias */
	ui->aliasid_label = gtk_label_new ("Alias ID:");
	adjustment = gtk_adjustment_new (-1, -1, 9999, 1, 1, 0);
	ui->aliasid_entry = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	width = gdk_text_width (ui->aliasid_entry->style->font, "M", 1);
	gtk_widget_set_usize (GTK_WIDGET (ui->aliasid_entry), width * 4, -1);

	ui->aliasof_label = gtk_label_new ("Alias Of:");
	adjustment = gtk_adjustment_new (-1, -1, 9999, 1, 1, 0);
	ui->aliasof_entry = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	width = gdk_text_width (ui->aliasof_entry->style->font, "M", 1);
	gtk_widget_set_usize (GTK_WIDGET (ui->aliasof_entry), width * 4, -1);

	table = gtk_table_new (4, 1, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->aliasid_label, 0, 1, 0, 1, 0, 0, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->aliasid_entry, 1, 2, 0, 1, 0, 0, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->aliasof_label, 2, 3, 0, 1, 0, 0, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->aliasof_entry, 3, 4, 0, 1, 0, 0, 5, 5);

	align = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_container_add (GTK_CONTAINER (align), table);

	frame = gtk_frame_new ("Alias");
	gtk_container_add (GTK_CONTAINER (frame), align);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* Galeon, Mozilla, NN4 */
	bk_edit_misc_input_create (&ui->id, "ID:");

	table = gtk_table_new (2, 1, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->id.label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->id.entry, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* */
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ui->content_scrolled), ui->content);
	gtk_box_pack_start (GTK_BOX (ui->box), ui->content_scrolled, TRUE, TRUE, 5);

	/* */
	gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (ui->content_scrolled)->child), GTK_SHADOW_NONE);

	return ui->box;
}


void edit_ui_delete (plugin *plug)
{
}


void edit_ui_get (plugin *plug, bk_edit_tree_data *node_data)
{
	nn4_edit_ui *ui = (nn4_edit_ui *) plug->edit_ui_data;

	/* Galeon, Mozilla, NN4, Opera */
	free (node_data->elements[NAME]);
        node_data->elements[NAME] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->name.entry)));

	free (node_data->elements[URI]);
        node_data->elements[URI] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->uri.entry)));

	free (node_data->elements[COMMENT]);
	node_data->elements[COMMENT] = strdup (gtk_editable_get_chars (GTK_EDITABLE (ui->comment_entry), 0, -1));

	free (node_data->elements[ADD_DATE]);
	node_data->elements[ADD_DATE] = strdup (bk_edit_date_get_timestamp (&ui->add_date));

	free (node_data->elements[LAST_VISIT]);
	node_data->elements[LAST_VISIT] = strdup (bk_edit_date_get_timestamp (&ui->last_visit));

	/* Galeon, Mozilla, NN4 */
	free (node_data->elements[LAST_MODIFIED]);
	node_data->elements[LAST_MODIFIED] = strdup (bk_edit_date_get_timestamp (&ui->last_mod));

	/* Mozilla, NN4 */
	free (node_data->elements[ALIASID]);
	node_data->elements[ALIASID] = strdup (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (ui->aliasid_entry)) == -1 ? "" : gtk_entry_get_text (GTK_ENTRY (ui->aliasid_entry)));

	free (node_data->elements[ALIASOF]);
	node_data->elements[ALIASOF] = strdup (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (ui->aliasof_entry)) == -1 ? "" : gtk_entry_get_text (GTK_ENTRY (ui->aliasof_entry)));

	/* Galeon, Mozilla, NN4 */
	free (node_data->elements[ID]);
	node_data->elements[ID] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->id.entry)));
}


void edit_ui_set (plugin *plug, bk_edit_tree_data *node_data)
{
	nn4_edit_ui *ui = (nn4_edit_ui *) plug->edit_ui_data;
	static int previous_type = -1;

	if (previous_type != node_data->type)
	{
		style edit_style;

		previous_type = node_data->type;

		if (node_data->type == BOOKMARK)
		{
			edit_style = plug->bookmark_edit_dialog_style;
		}
		else if (node_data->type == FOLDER)
		{
			edit_style = plug->folder_edit_dialog_style;
		}
		else if (node_data->type == SEPARATOR)
		{
			edit_style = plug->separator_edit_dialog_style;
		}
		else if (node_data->type == TOP)
		{
			edit_style = plug->root_edit_dialog_style;
		}

		bk_edit_misc_toggle_widget (ui->name.entry, edit_style.name);
		bk_edit_misc_toggle_widget (ui->name.label, edit_style.name);

		bk_edit_misc_toggle_widget (ui->uri.entry, edit_style.uri);
		bk_edit_misc_toggle_widget (ui->uri.label, edit_style.uri);

		bk_edit_misc_toggle_widget (ui->add_date.box, edit_style.add_date);
		bk_edit_misc_toggle_widget (ui->add_date.label, edit_style.add_date);

		bk_edit_misc_toggle_widget (ui->last_visit.box, edit_style.last_visit);
		bk_edit_misc_toggle_widget (ui->last_visit.label, edit_style.last_visit);

		bk_edit_misc_toggle_widget (ui->last_mod.box, edit_style.last_modified);
		bk_edit_misc_toggle_widget (ui->last_mod.label, edit_style.last_modified);

		bk_edit_misc_toggle_widget (ui->comment_box, edit_style.comment);
		bk_edit_misc_toggle_widget (ui->comment_label, edit_style.comment);

		bk_edit_misc_toggle_widget (ui->aliasid_label, edit_style.aliasid);
		bk_edit_misc_toggle_widget (ui->aliasid_entry, edit_style.aliasid);

		bk_edit_misc_toggle_widget (ui->aliasof_label, edit_style.aliasid);
		bk_edit_misc_toggle_widget (ui->aliasof_entry, edit_style.aliasid);

		bk_edit_misc_toggle_widget (ui->id.entry, edit_style.id);
		bk_edit_misc_toggle_widget (ui->id.label, edit_style.id);
	}

	gtk_widget_grab_focus (ui->name.entry);

	/* Galeon, Mozilla, NN4, Opera */
	gtk_entry_set_text (GTK_ENTRY (ui->name.entry), node_data->elements[NAME]);
	gtk_entry_set_text (GTK_ENTRY (ui->uri.entry), node_data->elements[URI]);

	gtk_editable_delete_text (GTK_EDITABLE (ui->comment_entry), 0, -1);
	gtk_text_insert (GTK_TEXT (ui->comment_entry), NULL, NULL, NULL, node_data->elements[COMMENT], strlen (node_data->elements[COMMENT]));

	bk_edit_date_fill (&ui->add_date,   node_data->elements[ADD_DATE]);
	bk_edit_date_fill (&ui->last_visit, node_data->elements[LAST_VISIT]);

	/* Galeon, Mozilla, NN4 */
	bk_edit_date_fill (&ui->last_mod,   node_data->elements[LAST_MODIFIED]);

	/* Mozilla, NN4 */
	node_data->elements[ALIASID][0] == '\0' ? gtk_spin_button_set_value (GTK_SPIN_BUTTON (ui->aliasid_entry), -1) : gtk_spin_button_set_value (GTK_SPIN_BUTTON (ui->aliasid_entry), atoi (node_data->elements[ALIASID]));
	node_data->elements[ALIASOF][0] == '\0' ? gtk_spin_button_set_value (GTK_SPIN_BUTTON (ui->aliasof_entry), -1) : gtk_spin_button_set_value (GTK_SPIN_BUTTON (ui->aliasof_entry), atoi (node_data->elements[ALIASOF]));

	/* Galeon, Mozilla, NN4 */
	gtk_entry_set_text (GTK_ENTRY (ui->id.entry), node_data->elements[ID]);
}

