%{

/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * moz_parse.lex - 19.05.2003 - v0.7 - Mozilla v1.4 support
                   16.04.2003 - v0.6 - bugfix - problem with new versions of flex
 *                   (reported by Gabor Z. Papp <gzp@papp.hu>)
 *                 06.12.2002 - v0.6 - make it compatible with Mozilla v1.0, v1.1 and v1.2
 *                 26.02.2002 - v0.5 - bk_parse.lex => moz_parse.lex
 *                 17.02.2002 - v0.4 - bugfix - bugfix - forgotten parser keywords
 *                   (reported by Steffen Pohle <stpohle@gmx.net>)
 *                 09.09.2001 - v0.3 - bugfix (<DD_TEXT>, stop_pattern[], <HR>)
 *                 09.08.2001 - v0.2 - mozilla support
 *                 08.01.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <string.h>

#include "moz_parse.h"
#include "moz_parse.yacc.h"

#include "char_vector.h"

#undef YY_USES_REJECT

int yylex (void);

%}

%option noyywrap

%option yylineno

%x TITLE_TEXT
%x H1_TEXT
%x DD_TEXT
%x H3 H3_TEXT H3_ATTR
%x A A_TEXT A_ATTR

DOCTYPE		"<!DOCTYPE NETSCAPE-Bookmark-file-1>"

%%


%{

static char *non_greedy_parsing (pattern stop_pattern[], char yytext[])
{
	char_vector *text_cv  = char_vector_new (text_cv, 100);
	char        *text_end = NULL;
	char        *text;
	int         in, i, which, chr_cnt = 0;

	char_vector_add (text_cv, yytext[0]);

	while ((text_end == NULL) && ((in = input ()) != EOF))
	{
		char_vector_add (text_cv, in);
		chr_cnt++;

		for (which = 0; stop_pattern[which].text != NULL; which++)
		{
			if (chr_cnt > stop_pattern[which].length)
			{
				stop_pattern[which].text_ptr++;
			}
		}

		for (which = 0; stop_pattern[which].text != NULL; which++)
		{
			text_end = strstr ((text_cv->vector) + stop_pattern[which].text_ptr,
						stop_pattern[which].text);
			if (text_end != NULL)
			{
				break;
			}
		}
	}

	if (text_end != NULL)
	{
		*text_end = '\0';

		for (i = strlen (stop_pattern[which].text) - 1; i >= 0; i--)
		{
			unput (stop_pattern[which].text[i]);
		}
	}
	else
	{
		char_vector_del (text_cv);
		return NULL;
	}

	text = strdup (text_cv->vector);
	char_vector_del (text_cv);

	return text;
}

%}


%{
/************************************************************************
 * doctype
 ************************************************************************/
%}

{DOCTYPE}	{ return DOCTYPE; }



%{
/************************************************************************
 * title
 ************************************************************************/
%}

"<TITLE>"	{ BEGIN (TITLE_TEXT); return TITLE_BEGIN; }
<TITLE_TEXT>.	{ pattern stop_pattern[] = { { "</TITLE>", 0, 8 },
					     { NULL,       0, 0 } };
		  yylval = (YYSTYPE) non_greedy_parsing (stop_pattern, yytext);
		  if (yylval == (YYSTYPE) NULL)
		  {
  		  	return 0;
		  }
		  BEGIN (INITIAL); return LITERAL; }
"</TITLE>"	{ return TITLE_END; }



%{
/************************************************************************
 * h1 heading
 ************************************************************************/
%}

"<H1>"		{ BEGIN (H1_TEXT); return H1_BEGIN; }
<H1_TEXT>.	{ pattern stop_pattern[] = { { "</H1>", 0, 5 },
					     { NULL,    0, 0 } };
                  yylval = (YYSTYPE) non_greedy_parsing (stop_pattern, yytext);
		  if (yylval == (YYSTYPE) NULL)
		  {
		  	return 0;
		  }
		  BEGIN (INITIAL); return LITERAL; }
"</H1>"		{ return H1_END; }



%{
/************************************************************************
 * definition list
 ************************************************************************/
%}

"<DL>"		{ return DL_BEGIN; }
"</DL>"		{ return DL_END; }

"<DT>"		{ return DT_BEGIN; }
"</DT>"		{ return DT_END; }



%{
/************************************************************************
 * definition description
 ************************************************************************/
%}

"<DD>"		{ BEGIN (DD_TEXT); return DD_BEGIN; }
<DD_TEXT>.	{ pattern stop_pattern[] = { { "<D",   0, 2 },
					     { "</",   0, 2 },
					     { "<HR>", 0, 4 },
					     { NULL, 0, 0 } };
                  yylval = (YYSTYPE) non_greedy_parsing (stop_pattern, yytext);
		  if (yylval == (YYSTYPE) NULL)
		  {
		  	return 0;
		  }
		  BEGIN (INITIAL); return LITERAL; }
"</DD>"		{ return DD_END; }



%{
/************************************************************************
 * h3 heading
 ************************************************************************/
%}

"<H3"			{ BEGIN (H3); return H3_BEGIN; }
<H3>FOLDED		{ return FOLDED_; }
<H3>ADD_DATE		{ return ADD_DATE_; }
<H3>LAST_MODIFIED	{ return LAST_MODIFIED_; }
<H3>ID			{ return ID_; }
<H3>PERSONAL_TOOLBAR_FOLDER	{ return PERSONAL_TOOLBAR_FOLDER_; }
<H3>NEW_BOOKMARK_FOLDER { return NEW_BOOKMARK_FOLDER_; }
<H3>NEW_SEARCH_FOLDER   { return NEW_SEARCH_FOLDER_; }
<H3>FOLDER_GROUP        { return FOLDER_GROUP_; }
<H3>\=			{ return EQUALS; }
<H3>\"			{ BEGIN (H3_ATTR); return DOUBLE_QUOTE; }
<H3_ATTR>[^"]		{ pattern stop_pattern[] = { { "\"", 0, 1 },
						     { NULL, 0, 0 } };
			  yylval = (YYSTYPE) non_greedy_parsing (stop_pattern, yytext);
			  if (yylval == (YYSTYPE) NULL)
			  {
			  	return 0;
			  }
			  return LITERAL; }
<H3_ATTR>\"		{ BEGIN (H3); return DOUBLE_QUOTE; }
<H3>">"			{ BEGIN (H3_TEXT); return CLOSE; }
<H3_TEXT>.		{ pattern stop_pattern[] = { { "</H3>", 0, 5 },
					     { NULL,    0, 0 } };
			  yylval = (YYSTYPE) non_greedy_parsing (stop_pattern, yytext);
			  if (yylval == (YYSTYPE) NULL)
			  {
			  	return 0;
			  }
                	  BEGIN (H3); return LITERAL; }
<H3>"</H3>"		{ BEGIN (INITIAL); return H3_END; }
<H3>.			{ /* void */ }



%{
/************************************************************************
 * anchor
 ************************************************************************/
%}

"<A"			{ BEGIN (A); return A_BEGIN; }
<A>HREF			{ return HREF_; }
<A>ADD_DATE		{ return ADD_DATE_; }
<A>LAST_VISIT		{ return LAST_VISIT_; }
<A>LAST_MODIFIED	{ return LAST_MODIFIED_; }
<A>ALIASID		{ return ALIASID_; }
<A>ALIASOF		{ return ALIASOF_; }
<A>LAST_CHARSET		{ return LAST_CHARSET_; }
<A>SHORTCUTURL		{ return SHORTCUTURL_; }
<A>SCHEDULE		{ return SCHEDULE_; }
<A>LAST_PING		{ return LAST_PING_; }
<A>PING_ETAG		{ return PING_ETAG_; }
<A>PING_LAST_MODIFIED	{ return PING_LAST_MODIFIED_; }
<A>PING_CONTENT_LEN	{ return PING_CONTENT_LEN_; }
<A>PING_STATUS		{ return PING_STATUS_; }
<A>ICON                 { return ICON_; }
<A>ID			{ return ID_; }
<A>\=			{ return EQUALS; }
<A>\"			{ BEGIN (A_ATTR); return DOUBLE_QUOTE; }
<A_ATTR>[^"]		{ pattern stop_pattern[] = { { "\"", 0, 1 },
						     { NULL, 0, 0 } };
			  yylval = (YYSTYPE) non_greedy_parsing (stop_pattern, yytext);
			  if (yylval == (YYSTYPE) NULL)
			  {
			  	return 0;
			  }
			  return LITERAL; }
<A_ATTR>\"		{ BEGIN (A); return DOUBLE_QUOTE; }
<A>">"			{ BEGIN (A_TEXT); return CLOSE; }
<A_TEXT>.		{ pattern stop_pattern[] = { { "</A>", 0, 4 },
						     { NULL,   0, 0 } };
                          yylval = (YYSTYPE) non_greedy_parsing (stop_pattern, yytext);
			  if (yylval == (YYSTYPE) NULL)
			  {
			  	return 0;
			  }
                          BEGIN (A); return LITERAL; }
<A>"</A>"		{ BEGIN (INITIAL); return A_END; }
<A>.			{ /* void */ }



%{
/************************************************************************
 * misc
 ************************************************************************/
%}

"<HR>"		{ return HR; }
"\n"		{ /* void */ }
"<p>"		{ /* void */ }
"<BR>\n"	{ /* void */ }
.		{ /* void */ }

%%


void yyerror (char *error_message)
{
	BEGIN (INITIAL);

	fprintf (stderr, "%s[%d]: %s at line %d before `%s' (error).\n", __FILE__, __LINE__, error_message, yylineno, yytext);
	parse_yyerror (__FILE__, yylineno, error_message, yytext);

	yylineno = 1;
}

