#ifndef MOZ_PARSE_H
#define MOZ_PARSE_H

#define MOZ_PARSE_OK				0
#define MOZ_PARSE_KO				10
#define MOZ_PARSE_NO_SUCH_FILE			20
#define MOZ_PARSE_OUT_OF_MEMORY			30
#define MOZ_PARSE_FOLDER_STACK_OVERRUN		40
#define MOZ_PARSE_FOLDER_STACK_UNDERRUN		50

/************************************************************************
 * anchor
 ************************************************************************/

typedef struct anchor_attr_tag
{
	/* netscape 4 */
	char *name;
	char *href;
	char *comment;
	char *add_date;
	char *last_visit;
	char *last_modified;
	char *aliasid;
	char *aliasof;
	/* netscape 6 / mozilla */
	char *last_charset;
	char *shortcuturl;
	char *schedule;
	char *last_ping;
	char *ping_etag;
	char *ping_last_modified;
	char *ping_content_len;
	char *ping_status;
	char *icon;
	/* mozilla 1.4 */
	char *id;
} anchor_attr;

/************************************************************************
 * heading
 ************************************************************************/

typedef struct heading_attr_tag
{
	char *name;
	char *comment;
	char *add_date;
	char *last_modified;

	char *id;
	char *personal_folder;
	char *new_bookmark_folder;
	char *new_search_folder;
	char *folder_group;
} heading_attr;

/************************************************************************
 * parse
 ************************************************************************/

typedef struct moz_parse_tag
{
	anchor_attr  a_attr;
	heading_attr h_attr;

	char *title;
	char *heading;
	char *filename;
} moz_parse;


typedef struct pattern_tag
{
	char *text;
	int   text_ptr;
	int   length;
} pattern;

/* callback functions */
int title_do_something (char *title);

int anchor_new (void);
int anchor_reset (void);
int anchor_do_something (anchor_attr a_attr);

int heading_new (void);
int heading_reset (void);
int heading_end (void);
int heading_do_something (heading_attr h_attr);

int separator_do_something (void);

void parse_yyerror (char *file, int line, char *error_message, char *yytext);

#endif
