/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * moz_parse.c - 19.05.2003 - v0.6 - Mozilla v1.4 support
 *               05.04.2003 - v0.5 - bugfix - utf-8 problem with mozilla plugin
 *                 (reported by Andreas Busch <Andreas.Busch@politics.ox.ac.uk>)
 *               06.12.2002 - v0.4 - make it compatible with Mozilla v1.0, v1.1 and v1.2
 *               26.02.2002 - v0.3 - bk_parse.c => moz_parse.c
 *               09.08.2001 - v0.2 - mozilla support
 *               08.01.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "bk_edit_misc.h"
#include "bk_edit_icon.h"
#include "bk_edit_tree.h"
#include "bk_edit_dialog_info.h"

#include "moz_parse.h"

moz_parse *moz;

/* callback functions */
int title_do_something (char *title)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	moz->heading = strdup (title);

	node_data.elements[NAME]    = moz->title;
	node_data.elements[URI]     = moz->heading;
	node_data.elements[COMMENT] = moz->filename;

	bk_edit_tree_add_root_node (&node_data);

	return MOZ_PARSE_OK;
}


int anchor_new (void)
{
	memset (&moz->a_attr, 0, sizeof (moz->a_attr));

	return MOZ_PARSE_OK;
}


int anchor_reset (void)
{
	if (moz->a_attr.name               != NULL) free (moz->a_attr.name);
	if (moz->a_attr.href               != NULL) free (moz->a_attr.href);
	if (moz->a_attr.comment            != NULL) free (moz->a_attr.comment);
	if (moz->a_attr.add_date           != NULL) free (moz->a_attr.add_date);
	if (moz->a_attr.last_visit         != NULL) free (moz->a_attr.last_visit);
	if (moz->a_attr.last_modified      != NULL) free (moz->a_attr.last_modified);
	if (moz->a_attr.aliasid            != NULL) free (moz->a_attr.aliasid);
	if (moz->a_attr.aliasof            != NULL) free (moz->a_attr.aliasof);
	if (moz->a_attr.last_charset       != NULL) free (moz->a_attr.last_charset);
	if (moz->a_attr.shortcuturl        != NULL) free (moz->a_attr.shortcuturl);
	if (moz->a_attr.schedule           != NULL) free (moz->a_attr.schedule);
	if (moz->a_attr.last_ping          != NULL) free (moz->a_attr.last_ping);
	if (moz->a_attr.ping_etag          != NULL) free (moz->a_attr.ping_etag);
	if (moz->a_attr.ping_last_modified != NULL) free (moz->a_attr.ping_last_modified);
	if (moz->a_attr.ping_content_len   != NULL) free (moz->a_attr.ping_content_len);
	if (moz->a_attr.ping_status        != NULL) free (moz->a_attr.ping_status);
	if (moz->a_attr.icon               != NULL) free (moz->a_attr.icon);
	if (moz->a_attr.id                 != NULL) free (moz->a_attr.id);

	return MOZ_PARSE_OK;
}


int anchor_do_something (anchor_attr a_attr)
{
	char *name = bk_edit_misc_html_entities_decode (a_attr.name);
	char *comment = bk_edit_misc_html_entities_decode (a_attr.comment);
	char *shortcuturl = bk_edit_misc_html_entities_decode (a_attr.shortcuturl);

	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME]               = bk_edit_misc_utf8_to_latin1 (name);
	node_data.elements[URI]                = a_attr.href;
	node_data.elements[COMMENT]            = bk_edit_misc_utf8_to_latin1 (comment);
	node_data.elements[ADD_DATE]           = a_attr.add_date;
	node_data.elements[LAST_VISIT]         = a_attr.last_visit;
	node_data.elements[LAST_MODIFIED]      = a_attr.last_modified;
	node_data.elements[ALIASID]            = a_attr.aliasid;
	node_data.elements[ALIASOF]            = a_attr.aliasof;
	node_data.elements[LAST_CHARSET]       = a_attr.last_charset;
	node_data.elements[SHORTCUTURL]        = bk_edit_misc_utf8_to_latin1 (shortcuturl);
	node_data.elements[SCHEDULE]           = a_attr.schedule;
	node_data.elements[LAST_PING]          = a_attr.last_ping;
	node_data.elements[PING_ETAG]          = a_attr.ping_etag;
	node_data.elements[PING_LAST_MODIFIED] = a_attr.ping_last_modified;
	node_data.elements[PING_CONTENT_LEN]   = a_attr.ping_content_len;
	node_data.elements[PING_STATUS]        = a_attr.ping_status;
	node_data.elements[PIXMAP]             = a_attr.icon;
	node_data.elements[ID]                 = a_attr.id;


	if (node_data.elements[COMMENT] != NULL)
	{
		node_data.elements[COMMENT] = g_strchomp (node_data.elements[COMMENT]);
	}

	bk_edit_tree_add_bookmark_node (&node_data);

	/* Every bk_edit_misc_utf8_to_latin1 converted string must be freed. */
	free (node_data.elements[NAME]);
	free (node_data.elements[COMMENT]);
	free (node_data.elements[SHORTCUTURL]);

	/* Every bk_edit_misc_html_entities_decode converted string must be freed. */
	free (name);
	free (comment);
	free (shortcuturl);

	return MOZ_PARSE_OK;
}


int heading_new (void)
{
	memset (&moz->h_attr, 0, sizeof (moz->h_attr));

	return MOZ_PARSE_OK;
}


int heading_reset (void)
{
	if (moz->h_attr.name                != NULL) free (moz->h_attr.name);
	if (moz->h_attr.comment             != NULL) free (moz->h_attr.comment);
	if (moz->h_attr.add_date            != NULL) free (moz->h_attr.add_date);
	if (moz->h_attr.last_modified       != NULL) free (moz->h_attr.last_modified);
	if (moz->h_attr.id                  != NULL) free (moz->h_attr.id);
	if (moz->h_attr.personal_folder     != NULL) free (moz->h_attr.personal_folder);
	if (moz->h_attr.new_bookmark_folder != NULL) free (moz->h_attr.new_bookmark_folder);
	if (moz->h_attr.new_search_folder   != NULL) free (moz->h_attr.new_search_folder);
	if (moz->h_attr.folder_group        != NULL) free (moz->h_attr.folder_group);

	return MOZ_PARSE_OK;
}


int heading_end (void)
{
	bk_edit_tree_leave_folder ();

	return MOZ_PARSE_OK;
}


int heading_do_something (heading_attr h_attr)
{
	char *name = bk_edit_misc_html_entities_decode (h_attr.name);
	char *comment = bk_edit_misc_html_entities_decode (h_attr.comment);

	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME]                    = bk_edit_misc_utf8_to_latin1 (name);
	node_data.elements[COMMENT]                 = bk_edit_misc_utf8_to_latin1 (comment);
	node_data.elements[ADD_DATE]                = h_attr.add_date;
	node_data.elements[LAST_MODIFIED]           = h_attr.last_modified;
	node_data.elements[ID]                      = h_attr.id;
	node_data.elements[PERSONAL_TOOLBAR_FOLDER] = h_attr.personal_folder;
	node_data.elements[NEW_BOOKMARK_FOLDER]     = h_attr.new_bookmark_folder;
	node_data.elements[NEW_SEARCH_FOLDER]       = h_attr.new_search_folder;
	node_data.elements[FOLDER_GROUP]            = h_attr.folder_group;

	if (node_data.elements[COMMENT] != NULL)
	{
		node_data.elements[COMMENT] = g_strchomp (node_data.elements[COMMENT]);
	}

	bk_edit_tree_add_folder_node (&node_data);

	/* Every bk_edit_misc_utf8_to_latin1 converted string must be freed. */
	free (node_data.elements[NAME]);
	free (node_data.elements[COMMENT]);

	/* Every bk_edit_misc_html_entities_decode converted string must be freed. */
	free (name);
	free (comment);

	return MOZ_PARSE_OK;
}


int separator_do_something (void)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME] = "-----------------";

	bk_edit_tree_add_separator (&node_data);

	return MOZ_PARSE_OK;
}


void parse_yyerror (char *file, int line, char *error_message, char *yytext)
{
	gchar *error = g_strdup_printf ("%s in file %s at line %d before `%s'.\n", error_message, moz->filename, line, yytext);
	bk_edit_dialog_info ("bk edit - error", error, icon_warning);
	g_print ("%s", error);
}

