/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * links2_ui.c - 18.05.2003 - v0.1 - nn4_ui.c => links2_ui.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plugin.h"
#include "links2_ui.h"
#include "bk_edit_misc.h"
#include "bk_edit_date.h"


GtkWidget *edit_ui_new (plugin *plug)
{
	GtkWidget *table, *frame;

	links2_edit_ui *ui = (links2_edit_ui *) malloc (sizeof (links2_edit_ui));
	if (ui == NULL)
	{
		fprintf (stderr, "%s[%d]: links2_edit_ui\n", __FILE__, __LINE__);
		return NULL;
	}
	plug->edit_ui_data = (void *) ui;

	ui->box = gtk_hbox_new (FALSE, 1);

	/* Content */
	ui->content = gtk_vbox_new (FALSE, 1);
	gtk_container_border_width (GTK_CONTAINER (ui->content), 1);
	ui->content_scrolled = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ui->content_scrolled), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width (GTK_CONTAINER (ui->content_scrolled), 1);

	/* Galeon, Mozilla, NN4, Opera, Links2 */
	/* Name, URI */
	bk_edit_misc_input_create (&ui->name, "Name:");
	bk_edit_misc_input_create (&ui->uri, "URI:");

	table = gtk_table_new (2, 2, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->name.label,    0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->name.entry,    1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.label,     0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.entry,     1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* */
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ui->content_scrolled), ui->content);
	gtk_box_pack_start (GTK_BOX (ui->box), ui->content_scrolled, TRUE, TRUE, 5);

	/* */
	gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (ui->content_scrolled)->child), GTK_SHADOW_NONE);

	return ui->box;
}


void edit_ui_delete (plugin *plug)
{
}


void edit_ui_get (plugin *plug, bk_edit_tree_data *node_data)
{
	links2_edit_ui *ui = (links2_edit_ui *) plug->edit_ui_data;

	/* Galeon, Mozilla, NN4, Opera, Links2 */
	free (node_data->elements[NAME]);
        node_data->elements[NAME] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->name.entry)));

	free (node_data->elements[URI]);
        node_data->elements[URI] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->uri.entry)));
}


void edit_ui_set (plugin *plug, bk_edit_tree_data *node_data)
{
	links2_edit_ui *ui = (links2_edit_ui *) plug->edit_ui_data;
	static int previous_type = -1;

	if (previous_type != node_data->type)
	{
		style edit_style;

		previous_type = node_data->type;

		if (node_data->type == BOOKMARK)
		{
			edit_style = plug->bookmark_edit_dialog_style;
		}
		else if (node_data->type == FOLDER)
		{
			edit_style = plug->folder_edit_dialog_style;
		}
		else if (node_data->type == SEPARATOR)
		{
			edit_style = plug->separator_edit_dialog_style;
		}
		else if (node_data->type == TOP)
		{
			edit_style = plug->root_edit_dialog_style;
		}

		bk_edit_misc_toggle_widget (ui->name.entry, edit_style.name);
		bk_edit_misc_toggle_widget (ui->name.label, edit_style.name);

		bk_edit_misc_toggle_widget (ui->uri.entry, edit_style.uri);
		bk_edit_misc_toggle_widget (ui->uri.label, edit_style.uri);
	}

	gtk_widget_grab_focus (ui->name.entry);

	/* Galeon, Mozilla, NN4, Opera, Links2 */
	gtk_entry_set_text (GTK_ENTRY (ui->name.entry), node_data->elements[NAME]);
	gtk_entry_set_text (GTK_ENTRY (ui->uri.entry), node_data->elements[URI]);
}

