%{

/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * links2_parse.yacc - 18.05.2003 - v0.1 - nn4_parse.yacc => links2_parse.yacc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdlib.h>
#include <string.h>

#include "links2_parse.h"

#define YYSTYPE char *

extern links2_parse *links2;

%}

%token HTML_BEGIN HTML_END
%token HEAD_BEGIN HEAD_END
%token TITLE_BEGIN TITLE_END
%token H1_BEGIN H1_END

%token DT_BEGIN DT_END
%token DL_BEGIN DL_END
%token H3_BEGIN H3_END
%token A_BEGIN A_END

%token CLOSE EQUALS DOUBLE_QUOTE LITERAL TEXT NUMBER CHARACTER

/* anchor attributes */
%token HREF_
%token URI_

%start start

%%

/************************************************************************
 * header
 ************************************************************************/

start: HTML_BEGIN HEAD_BEGIN title HEAD_END header definition_list HTML_END
     ;

title: TITLE_BEGIN literal { if ((links2->title = strdup ($2)) == NULL) { return LINKS2_PARSE_OUT_OF_MEMORY; } } TITLE_END
     ;

header: H1_BEGIN literal { int ret; if ((ret = title_do_something ($2)) != LINKS2_PARSE_OK) { return ret; } } H1_END
      ;



/************************************************************************
 * definition list
 ************************************************************************/

definition_list: definition_list DL_BEGIN dl_content { int ret; if ((ret = heading_end ()) != LINKS2_PARSE_OK) { return ret; } } DL_END
               | /* void */
               ;

dl_content: dl_content definition_term
	  | dl_content definition_list
          | /* void */
          ;

definition_term: DT_BEGIN dt_content
               ;

dt_content: heading { int ret; if ((ret = heading_do_something (links2->h_attr)) != LINKS2_PARSE_OK) { return ret; } if ((ret = heading_reset ()) != LINKS2_PARSE_OK) { return ret; } }
          | anchor { int ret; if ((ret = anchor_do_something (links2->a_attr)) != LINKS2_PARSE_OK) { return ret; } if ((ret = anchor_reset ()) != LINKS2_PARSE_OK) { return ret; } }
          | /* void */
	  ;



/************************************************************************
 * anchor
 ************************************************************************/

anchor: A_BEGIN { int ret; if ((ret = anchor_new ()) != LINKS2_PARSE_OK) { return ret; } } anchor_attr CLOSE literal { links2->a_attr.name = $5; } A_END
      ;

anchor_attr: HREF_ EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { links2->a_attr.href = $4; }
	   ;



/************************************************************************
 * heading
 ************************************************************************/

heading: H3_BEGIN { int ret; if ((ret = heading_new ()) != LINKS2_PARSE_OK) { return ret; } } literal { links2->h_attr.name = $3; } H3_END
       ;



/************************************************************************
 * misc
 ************************************************************************/

literal: LITERAL    { $$ = $1;   }
       | /* void */ { $$ = NULL; }
       ;

%%

