/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * links2_parse.c - 18.05.2003 - v0.1 - nn4_parse.c => links2_parse.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "bk_edit_misc.h"
#include "bk_edit_icon.h"
#include "bk_edit_tree.h"
#include "bk_edit_dialog_info.h"

#include "links2_parse.h"

links2_parse *links2;

/* callback functions */
int title_do_something (char *title)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	links2->heading = strdup (title);

	node_data.elements[NAME]    = bk_edit_misc_html_entities_decode (links2->title);
	node_data.elements[URI]     = bk_edit_misc_html_entities_decode (links2->heading);
	node_data.elements[COMMENT] = links2->filename;

	bk_edit_tree_add_root_node (&node_data);

	free (node_data.elements[NAME]);
	free (node_data.elements[URI]);

	return LINKS2_PARSE_OK;
}


int anchor_new (void)
{
	memset (&links2->a_attr, 0, sizeof (links2->a_attr));

	return LINKS2_PARSE_OK;
}


int anchor_reset (void)
{
	if (links2->a_attr.name != NULL) free (links2->a_attr.name);
	if (links2->a_attr.href != NULL) free (links2->a_attr.href);

	return LINKS2_PARSE_OK;
}


int anchor_do_something (anchor_attr a_attr)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME] = bk_edit_misc_html_entities_decode (a_attr.name);
	node_data.elements[URI] = a_attr.href;

	bk_edit_tree_add_bookmark_node (&node_data);

	free (node_data.elements[NAME]);

	return LINKS2_PARSE_OK;
}


int heading_new (void)
{
	memset (&links2->h_attr, 0, sizeof (links2->h_attr));

	return LINKS2_PARSE_OK;
}


int heading_reset (void)
{
	if (links2->h_attr.name != NULL) free (links2->h_attr.name);

	return LINKS2_PARSE_OK;
}


int heading_end (void)
{
	bk_edit_tree_leave_folder ();

	return LINKS2_PARSE_OK;
}


int heading_do_something (heading_attr h_attr)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME] = bk_edit_misc_html_entities_decode (h_attr.name);

	bk_edit_tree_add_folder_node (&node_data);

	free (node_data.elements[NAME]);

	return LINKS2_PARSE_OK;
}


void parse_yyerror (char *file, int line, char *error_message, char *yytext)
{
	gchar *error = g_strdup_printf ("%s in file %s at line %d before `%s'.\n", error_message, links2->filename, line, yytext);
	bk_edit_dialog_info ("bk edit - error", error, icon_warning);
	g_print ("%s", error);
}

