/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * links2.c - 18.05.2003 - v0.1 - nn4.c => links2.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plugin.h"

#include "bk_edit_tree.h"
#include "bk_edit_icon.h"
#include "bk_edit_data.h"
#include "bk_edit_misc.h"
#include "bk_edit_dialog_info.h"

#include "links2_parse.h"

extern links2_parse *links2;

extern FILE *yyin;
extern int yyparse (void);
extern int yyrestart (FILE *);

static FILE *file;
static int level = 1;
static int links2_parse_error = LINKS2_PARSE_OK;


int init (plugin *plug)
{
	plug->name        = "Links 2.1 (ISO-8859-*)";
	plug->short_name  = "Links2";
	plug->description = "Links 2.1 (http://atrey.karlin.mff.cuni.cz/~clock/twibright/links/)";
	plug->author      = "<clfuit00@fht-esslingen.de>";

	plug->type = PLUGIN_LOAD | PLUGIN_SAVE | PLUGIN_EDIT;

	plug->cleanup = cleanup;

	plug->load            = load;
	plug->save_begin      = save_begin;
	plug->save_end        = save_end;
	plug->save_separator  = save_separator;
	plug->save_bookmark   = save_bookmark;
	plug->save_folder_in  = save_folder_in;
	plug->save_folder_out = save_folder_out;

	plug->edit_ui = edit_ui_new (plug);
	plug->edit_ui_new = edit_ui_new;
	plug->edit_ui_delete = edit_ui_delete;
	plug->edit_ui_set = edit_ui_set;
	plug->edit_ui_get = edit_ui_get;

	plug->bookmark_edit_dialog_style.name = SHOW;
	plug->bookmark_edit_dialog_style.uri = SHOW;

	plug->folder_edit_dialog_style.name = SHOW;

	plug->root_edit_dialog_style.name = SHOW;

	return PLUGIN_OK;
}


int cleanup (plugin *plug)
{
	return PLUGIN_OK;
}


int load (char *filename)
{
	int ret;

	links2 = (links2_parse *) malloc (sizeof (links2_parse));
	if (links2 == NULL)
	{
		fprintf (stderr, "%s[%d]: out of memory (fatal error).", __FILE__, __LINE__);
		return PLUGIN_OUT_OF_MEMORY;
	}

	links2->filename = strdup (filename);
	if (links2->filename == NULL)
	{
		fprintf (stderr, "%s[%d]: out of memory (fatal error).", __FILE__, __LINE__);
		return PLUGIN_OUT_OF_MEMORY;
	}

	yyin = fopen (links2->filename, "r");
	if (yyin == NULL)
	{
		fprintf (stderr, "%s[%d]: no such file: %s (error).\n", __FILE__, __LINE__, links2->filename);
		return PLUGIN_NO_SUCH_FILE;
	}

	if (links2_parse_error != LINKS2_PARSE_OK)
	{
		yyrestart (yyin);
	}

	if ((ret = yyparse ()) != LINKS2_PARSE_OK)
	{
		links2_parse_error = LINKS2_PARSE_KO;
		return PLUGIN_PARSE_ERROR;
	}

	free (links2->title);
	free (links2->heading);
	free (links2->filename);
	free (links2);

	links2_parse_error = LINKS2_PARSE_OK;
	return PLUGIN_OK;
}


int save_begin (char *filename, bk_edit_tree_data *node_data)
{
	file = fopen (filename, "w");
	if (file == NULL)
	{
		bk_edit_dialog_info ("bk edit - error", "Open failed.", icon_warning);
		return PLUGIN_OPEN_FAILED;
	}

        fprintf (file, "<HTML>\n"
			"<HEAD>\n"
			"<TITLE>%s</TITLE>\n"
			"</HEAD>\n"
			"<H1>%s</H1>\n"
			"<DL>\n", node_data->elements[NAME], node_data->elements[NAME]);

	return PLUGIN_OK;
}


void save_end (void)
{
	fprintf (file, "</DL>\n"
			"</HTML>\n");
	fclose (file);
}


void save_separator (bk_edit_tree_data *node_data)
{
}


void save_bookmark (bk_edit_tree_data *node_data)
{
	char *name = bk_edit_misc_html_entities_encode (node_data->elements[NAME], NULL);

	fprintf (file, "%*s<DT><A HREF=\"%s\">%s</A>\n",
			level * 4, "",
			node_data->elements[URI],
			name);

	free (name);
}


void save_folder_in (bk_edit_tree_data *node_data)
{
	char *name = bk_edit_misc_html_entities_encode (node_data->elements[NAME], NULL);

	fprintf (file, "%*s<DT><H3>%s</H3>\n",
			level * 4, "",
			name);

	fprintf (file, "%*s<DL>\n", level * 4, "");

	++level;

	free (name);
}


void save_folder_out (void)
{
	--level;

	fprintf (file, "%*s</DL>\n", level * 4, "");
}

