/*
 * Copyright (C) 2002-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * all_edit.c - 25.04.2003 - v0.2 - Opera 7
 *              23.12.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plugin.h"
#include "all_edit.h"
#include "bk_edit_date.h"
#include "bk_edit_misc.h"

int init (plugin *plug)
{
	plug->name = "All";
	plug->short_name = "All";
	plug->description = "";
	plug->author = "<clfuit00@fht-esslingen.de>";

	plug->type = PLUGIN_EDIT;

	plug->cleanup = cleanup;

	plug->edit_ui = edit_ui_new (plug);
	plug->edit_ui_new = edit_ui_new;
	plug->edit_ui_delete = edit_ui_delete;
	plug->edit_ui_set = edit_ui_set;
	plug->edit_ui_get = edit_ui_get;

	return PLUGIN_OK;
}


int cleanup (plugin *plug)
{
	return PLUGIN_OK;
}


GtkWidget *edit_ui_new (plugin *plug)
{
	GtkWidget *table, *frame, *align, *box;

	GtkObject *adjustment;

	gint width;

	all_edit_ui *ui = (all_edit_ui *) malloc (sizeof (all_edit_ui));
	if (ui == NULL)
	{
		fprintf (stderr, "%s[%d]: all_edit_ui\n", __FILE__, __LINE__);
		return NULL;
	}
	plug->edit_ui_data = (void *) ui;

	ui->box = gtk_hbox_new (FALSE, 1);

	/* Content */
	ui->content = gtk_vbox_new (FALSE, 1);
	gtk_container_border_width (GTK_CONTAINER (ui->content), 1);
	ui->content_scrolled = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ui->content_scrolled), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width (GTK_CONTAINER (ui->content_scrolled), 1);

	/* Galeon, Mozilla, NN4, Opera */
	/* Name, URI */
	bk_edit_misc_input_create (&ui->name, "Name:");
	bk_edit_misc_input_create (&ui->uri, "URI:");

	/* Comment Box */
	ui->comment_box = gtk_hbox_new (FALSE, 1);
	ui->comment_entry = gtk_text_new (NULL, NULL);
	gtk_text_set_editable (GTK_TEXT (ui->comment_entry), TRUE);
	ui->comment_label = gtk_label_new ("Comment:");
	gtk_label_set_justify (GTK_LABEL (ui->comment_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (ui->comment_label), 0.0, 0.0);
	ui->comment_scrollbar = gtk_vscrollbar_new (GTK_TEXT (ui->comment_entry)->vadj);

	/* */
	gtk_box_pack_start (GTK_BOX (ui->comment_box), ui->comment_entry, TRUE, TRUE, 1);
	gtk_box_pack_start (GTK_BOX (ui->comment_box), ui->comment_scrollbar, FALSE, FALSE, 1);

	table = gtk_table_new (2, 3, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->name.label,    0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->name.entry,    1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.label,     0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->uri.entry,     1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->comment_label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->comment_box,   1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* Galeon, Mozilla, NN4, Opera */
	/* add date, last visit */
	bk_edit_date_create (&ui->add_date, "Add On:");
	bk_edit_date_create (&ui->last_visit, "Last Visit:");

	/* last modification */
	bk_edit_date_create (&ui->last_mod, "Mod. On:");

	table = gtk_table_new (2, 3, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->add_date.label,   0, 1, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->add_date.box,     1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_visit.label, 0, 1, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_visit.box,   1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_mod.label,   0, 1, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_mod.box,     1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);

	frame = gtk_frame_new ("Date");
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* Mozilla, NN4 */
	/* Alias */
	ui->aliasid_label = gtk_label_new ("Alias ID:");
	adjustment = gtk_adjustment_new (-1, -1, 9999, 1, 1, 0);
	ui->aliasid_entry = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	width = gdk_text_width (ui->aliasid_entry->style->font, "M", 1);
	gtk_widget_set_usize (GTK_WIDGET (ui->aliasid_entry), width * 4, -1);

	ui->aliasof_label = gtk_label_new ("Alias Of:");
	adjustment = gtk_adjustment_new (-1, -1, 9999, 1, 1, 0);
	ui->aliasof_entry = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	width = gdk_text_width (ui->aliasof_entry->style->font, "M", 1);
	gtk_widget_set_usize (GTK_WIDGET (ui->aliasof_entry), width * 4, -1);

	table = gtk_table_new (4, 1, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->aliasid_label, 0, 1, 0, 1, 0, 0, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->aliasid_entry, 1, 2, 0, 1, 0, 0, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->aliasof_label, 2, 3, 0, 1, 0, 0, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->aliasof_entry, 3, 4, 0, 1, 0, 0, 5, 5);

	align = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_container_add (GTK_CONTAINER (align), table);

	frame = gtk_frame_new ("Alias");
	gtk_container_add (GTK_CONTAINER (frame), align);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* Galeon, Mozilla, NN4 */
	bk_edit_misc_input_create (&ui->id, "ID:");

	/* Mozilla */
	bk_edit_misc_input_create (&ui->personal_folder, "Personal Folder:");
	bk_edit_misc_input_create (&ui->last_charset, "Last Charset:");
	bk_edit_misc_input_create (&ui->shortcuturl, "Keywords:");
	bk_edit_misc_input_create (&ui->schedule, "Schedule:");
	bk_edit_misc_input_create (&ui->new_bookmark_folder, "New Bookmark Folder:");
	bk_edit_misc_input_create (&ui->new_search_folder, "New Search Folder:");
	bk_edit_misc_input_create (&ui->folder_group, "Folder Group:");

	/* Opera */
	bk_edit_misc_input_create (&ui->order, "Order:");
	bk_edit_misc_input_create (&ui->short_name, "Shortname:");
	bk_edit_misc_input_create (&ui->nickname, "Nickname:");

	/* Opera 7 */
	bk_edit_misc_input_create (&ui->trash_folder, "Trash Folder:");
	bk_edit_misc_input_create (&ui->on_personalbar, "On Personalbar:");
	bk_edit_misc_input_create (&ui->personalbar_pos, "Personalbar Pos:");
	bk_edit_misc_input_create (&ui->active, "Active:");
	bk_edit_misc_input_create (&ui->in_panel, "In Panel:");
	bk_edit_misc_input_create (&ui->panel_pos, "Panel Pos:");
	bk_edit_misc_input_create (&ui->linkbar_folder, "Linkbar Folder:");
	bk_edit_misc_input_create (&ui->linkbar_stop, "Linkbar Stop:");

	/* Galeon */
	bk_edit_misc_input_create (&ui->ref, "Ref:");
	bk_edit_misc_input_create (&ui->metadata_owner, "Metadata Owner:");
	bk_edit_misc_input_create (&ui->default_folder, "Default Folder:");
	bk_edit_misc_input_create (&ui->create_toolbar, "Create Toolbar:");
	bk_edit_misc_input_create (&ui->toolbar_style, "Toolbar Style:");
	bk_edit_misc_input_create (&ui->smarturl, "Smart URL:");
	bk_edit_misc_input_create (&ui->create_context, "Create Context:");

	/* Galeon, Mozilla */
	bk_edit_misc_input_create (&ui->pixmap, "Pixmap:");

	table = gtk_table_new (2, 27, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->id.label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->id.entry, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ref.label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ref.entry, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->shortcuturl.label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->shortcuturl.entry, 1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->order.label, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->order.entry, 1, 2, 3, 4, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->short_name.label, 0, 1, 4, 5, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->short_name.entry, 1, 2, 4, 5, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->nickname.label, 0, 1, 5, 6, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->nickname.entry, 1, 2, 5, 6, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->trash_folder.label, 0, 1, 6, 7, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->trash_folder.entry, 1, 2, 6, 7, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->on_personalbar.label, 0, 1, 7, 8, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->on_personalbar.entry, 1, 2, 7, 8, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->personalbar_pos.label, 0, 1, 8, 9, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->personalbar_pos.entry, 1, 2, 8, 9, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->active.label, 0, 1, 9, 10, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->active.entry, 1, 2, 9, 10, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->in_panel.label, 0, 1, 10, 11, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->in_panel.entry, 1, 2, 10, 11, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->panel_pos.label, 0, 1, 11, 12, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->panel_pos.entry, 1, 2, 11, 12, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->linkbar_folder.label, 0, 1, 12, 13, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->linkbar_folder.entry, 1, 2, 12, 13, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->linkbar_stop.label, 0, 1, 13, 14, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->linkbar_stop.entry, 1, 2, 13, 14, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->schedule.label, 0, 1, 14, 15, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->schedule.entry, 1, 2, 14, 15, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_charset.label, 0, 1, 15, 16, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->last_charset.entry, 1, 2, 15, 16, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->personal_folder.label, 0, 1, 16, 17, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->personal_folder.entry, 1, 2, 16, 17, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->new_bookmark_folder.label, 0, 1, 17, 18, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->new_bookmark_folder.entry, 1, 2, 17, 18, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->new_search_folder.label, 0, 1, 18, 19, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->new_search_folder.entry, 1, 2, 18, 19, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->default_folder.label, 0, 1, 19, 20, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->default_folder.entry, 1, 2, 19, 20, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->create_toolbar.label, 0, 1, 20, 21, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->create_toolbar.entry, 1, 2, 20, 21, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->toolbar_style.label, 0, 1, 21, 22, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->toolbar_style.entry, 1, 2, 21, 22, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->pixmap.label, 0, 1, 22, 23, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->pixmap.entry, 1, 2, 22, 23, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->smarturl.label, 0, 1, 23, 24, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->smarturl.entry, 1, 2, 23, 24, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->create_context.label, 0, 1, 24, 25, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->create_context.entry, 1, 2, 24, 25, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->metadata_owner.label, 0, 1, 25, 26, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->metadata_owner.entry, 1, 2, 25, 26, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->folder_group.label, 0, 1, 26, 27, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->folder_group.entry, 1, 2, 26, 27, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	frame = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* Mozilla */
	bk_edit_date_create (&ui->last_ping, "Last Ping:");
	bk_edit_date_create (&ui->ping_last_mod, "Ping Last Modification:");
	bk_edit_misc_input_create (&ui->ping_etag, "Ping ETag:");
	bk_edit_misc_input_create (&ui->ping_content_len, "Ping Content Length:");
	bk_edit_misc_input_create (&ui->ping_status, "Ping Status:");

	table = gtk_table_new (2, 3, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->ping_etag.label,        0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ping_etag.entry,        1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ping_content_len.label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ping_content_len.entry, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ping_status.label,      0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ping_status.entry,      1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);

	box = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), table, FALSE, FALSE, 5);

	table = gtk_table_new (2, 4, FALSE);
	gtk_table_attach (GTK_TABLE (table), ui->last_ping.label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
	align = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_container_add (GTK_CONTAINER (align), ui->last_ping.box);
	gtk_table_attach (GTK_TABLE (table), align, 0, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_table_attach (GTK_TABLE (table), ui->ping_last_mod.label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	align = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_container_add (GTK_CONTAINER (align), ui->ping_last_mod.box);
	gtk_table_attach (GTK_TABLE (table), align, 0, 2, 3, 4, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	gtk_box_pack_start (GTK_BOX (box), table, FALSE, FALSE, 5);

	frame = gtk_frame_new ("Ping");
	gtk_container_add (GTK_CONTAINER (frame), box);
	gtk_box_pack_start (GTK_BOX (ui->content), frame, FALSE, FALSE, 5);

	/* */
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ui->content_scrolled), ui->content);
	gtk_box_pack_start (GTK_BOX (ui->box), ui->content_scrolled, TRUE, TRUE, 5);

	/* */
	gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (ui->content_scrolled)->child), GTK_SHADOW_NONE);

	return ui->box;
}


void edit_ui_delete (plugin *plug)
{
}


void edit_ui_get (plugin *plug, bk_edit_tree_data *node_data)
{
	all_edit_ui *ui = (all_edit_ui *) plug->edit_ui_data;

	/* Galeon, Mozilla, NN4, Opera */
	free (node_data->elements[NAME]);
        node_data->elements[NAME] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->name.entry)));

	free (node_data->elements[URI]);
        node_data->elements[URI] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->uri.entry)));

	free (node_data->elements[COMMENT]);
	node_data->elements[COMMENT] = strdup (gtk_editable_get_chars (GTK_EDITABLE (ui->comment_entry), 0, -1));

	free (node_data->elements[ADD_DATE]);
	node_data->elements[ADD_DATE] = strdup (bk_edit_date_get_timestamp (&ui->add_date));

	free (node_data->elements[LAST_VISIT]);
	node_data->elements[LAST_VISIT] = strdup (bk_edit_date_get_timestamp (&ui->last_visit));

	/* Galeon, Mozilla, NN4 */
	free (node_data->elements[LAST_MODIFIED]);
	node_data->elements[LAST_MODIFIED] = strdup (bk_edit_date_get_timestamp (&ui->last_mod));

	/* Mozilla, NN4 */
	free (node_data->elements[ALIASID]);
	node_data->elements[ALIASID] = strdup (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (ui->aliasid_entry)) == -1 ? "" : gtk_entry_get_text (GTK_ENTRY (ui->aliasid_entry)));

	free (node_data->elements[ALIASOF]);
	node_data->elements[ALIASOF] = strdup (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (ui->aliasof_entry)) == -1 ? "" : gtk_entry_get_text (GTK_ENTRY (ui->aliasof_entry)));

	/* Galeon, Mozilla, NN4 */
	free (node_data->elements[ID]);
	node_data->elements[ID] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->id.entry)));

	/* Mozilla */
	free (node_data->elements[PERSONAL_TOOLBAR_FOLDER]);
	node_data->elements[PERSONAL_TOOLBAR_FOLDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->personal_folder.entry)));

	free (node_data->elements[LAST_CHARSET]);
	node_data->elements[LAST_CHARSET] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->last_charset.entry)));

	free (node_data->elements[SHORTCUTURL]);
	node_data->elements[SHORTCUTURL] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->shortcuturl.entry)));

	free (node_data->elements[SCHEDULE]);
	node_data->elements[SCHEDULE] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->schedule.entry)));

	free (node_data->elements[LAST_PING]);
	node_data->elements[LAST_PING] = strdup (bk_edit_date_get_timestamp (&ui->last_ping));

	free (node_data->elements[PING_ETAG]);
	node_data->elements[PING_ETAG] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->ping_etag.entry)));

	free (node_data->elements[PING_LAST_MODIFIED]);
	node_data->elements[PING_LAST_MODIFIED] = strdup (bk_edit_date_get_timestamp (&ui->ping_last_mod));

	free (node_data->elements[PING_CONTENT_LEN]);
	node_data->elements[PING_CONTENT_LEN] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->ping_content_len.entry)));

	free (node_data->elements[PING_STATUS]);
	node_data->elements[PING_STATUS] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->ping_status.entry)));

	free (node_data->elements[NEW_BOOKMARK_FOLDER]);
	node_data->elements[NEW_BOOKMARK_FOLDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->new_bookmark_folder.entry)));

	free (node_data->elements[NEW_SEARCH_FOLDER]);
	node_data->elements[NEW_SEARCH_FOLDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->new_search_folder.entry)));

	free (node_data->elements[FOLDER_GROUP]);
	node_data->elements[FOLDER_GROUP] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->folder_group.entry)));

	/* Opera */
	free (node_data->elements[ORDER]);
	node_data->elements[ORDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->order.entry)));

	free (node_data->elements[SHORT_NAME]);
	node_data->elements[SHORT_NAME] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->short_name.entry)));

	free (node_data->elements[NICKNAME]);
	node_data->elements[NICKNAME] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->nickname.entry)));

	/* Opera 7 */
	free (node_data->elements[TRASH_FOLDER]);
	node_data->elements[TRASH_FOLDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->trash_folder.entry)));

	free (node_data->elements[ON_PERSONALBAR]);
	node_data->elements[ON_PERSONALBAR] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->on_personalbar.entry)));

	free (node_data->elements[PERSONALBAR_POS]);
	node_data->elements[PERSONALBAR_POS] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->personalbar_pos.entry)));

	free (node_data->elements[ACTIVE]);
	node_data->elements[ACTIVE] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->active.entry)));

	free (node_data->elements[IN_PANEL]);
	node_data->elements[IN_PANEL] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->in_panel.entry)));

	free (node_data->elements[PANEL_POS]);
	node_data->elements[PANEL_POS] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->panel_pos.entry)));

	free (node_data->elements[LINKBAR_FOLDER]);
	node_data->elements[LINKBAR_FOLDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->linkbar_folder.entry)));

	free (node_data->elements[LINKBAR_STOP]);
	node_data->elements[LINKBAR_STOP] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->linkbar_stop.entry)));

	/* Galeon */
	free (node_data->elements[REF]);
	node_data->elements[REF] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->ref.entry)));

	free (node_data->elements[METADATA_OWNER]);
	node_data->elements[METADATA_OWNER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->metadata_owner.entry)));

	free (node_data->elements[DEFAULT_FOLDER]);
	node_data->elements[DEFAULT_FOLDER] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->default_folder.entry)));

	free (node_data->elements[CREATE_TOOLBAR]);
	node_data->elements[CREATE_TOOLBAR] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->create_toolbar.entry)));

	free (node_data->elements[TOOLBAR_STYLE]);
	node_data->elements[TOOLBAR_STYLE] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->toolbar_style.entry)));

	free (node_data->elements[SMARTURL]);
	node_data->elements[SMARTURL] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->smarturl.entry)));

	free (node_data->elements[CREATE_CONTEXT]);
	node_data->elements[CREATE_CONTEXT] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->create_context.entry)));

	/* Galeon, Mozilla */
	free (node_data->elements[PIXMAP]);
	node_data->elements[PIXMAP] = strdup (gtk_entry_get_text (GTK_ENTRY (ui->pixmap.entry)));
}


void edit_ui_set (plugin *plug, bk_edit_tree_data *node_data)
{
	all_edit_ui *ui = (all_edit_ui *) plug->edit_ui_data;

	gtk_widget_grab_focus (ui->name.entry);

	/* Galeon, Mozilla, NN4, Opera */
	gtk_entry_set_text (GTK_ENTRY (ui->name.entry), node_data->elements[NAME]);
	gtk_entry_set_text (GTK_ENTRY (ui->uri.entry), node_data->elements[URI]);

	gtk_editable_delete_text (GTK_EDITABLE (ui->comment_entry), 0, -1);
	gtk_text_insert (GTK_TEXT (ui->comment_entry), NULL, NULL, NULL, node_data->elements[COMMENT], strlen (node_data->elements[COMMENT]));

	bk_edit_date_fill (&ui->add_date,   node_data->elements[ADD_DATE]);
	bk_edit_date_fill (&ui->last_visit, node_data->elements[LAST_VISIT]);

	/* Galeon, Mozilla, NN4 */
	bk_edit_date_fill (&ui->last_mod,   node_data->elements[LAST_MODIFIED]);

	/* Mozilla, NN4 */
	node_data->elements[ALIASID][0] == '\0' ? gtk_spin_button_set_value (GTK_SPIN_BUTTON (ui->aliasid_entry), -1) : gtk_spin_button_set_value (GTK_SPIN_BUTTON (ui->aliasid_entry), atoi (node_data->elements[ALIASID]));
	node_data->elements[ALIASOF][0] == '\0' ? gtk_spin_button_set_value (GTK_SPIN_BUTTON (ui->aliasof_entry), -1) : gtk_spin_button_set_value (GTK_SPIN_BUTTON (ui->aliasof_entry), atoi (node_data->elements[ALIASOF]));

	/* Galeon, Mozilla, NN4 */
	gtk_entry_set_text (GTK_ENTRY (ui->id.entry), node_data->elements[ID]);

	/* Mozilla */
	gtk_entry_set_text (GTK_ENTRY (ui->personal_folder.entry), node_data->elements[PERSONAL_TOOLBAR_FOLDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->last_charset.entry), node_data->elements[LAST_CHARSET]);
	gtk_entry_set_text (GTK_ENTRY (ui->shortcuturl.entry), node_data->elements[SHORTCUTURL]);
	gtk_entry_set_text (GTK_ENTRY (ui->schedule.entry), node_data->elements[SCHEDULE]);

	bk_edit_date_fill (&ui->last_ping, node_data->elements[LAST_PING]);
	bk_edit_date_fill (&ui->ping_last_mod, node_data->elements[PING_LAST_MODIFIED]);

	gtk_entry_set_text (GTK_ENTRY (ui->ping_etag.entry), node_data->elements[PING_ETAG]);
	gtk_entry_set_text (GTK_ENTRY (ui->ping_content_len.entry), node_data->elements[PING_CONTENT_LEN]);
	gtk_entry_set_text (GTK_ENTRY (ui->ping_status.entry), node_data->elements[PING_STATUS]);

	gtk_entry_set_text (GTK_ENTRY (ui->new_bookmark_folder.entry), node_data->elements[NEW_BOOKMARK_FOLDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->new_search_folder.entry), node_data->elements[NEW_SEARCH_FOLDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->folder_group.entry), node_data->elements[FOLDER_GROUP]);

	/* Opera */
	gtk_entry_set_text (GTK_ENTRY (ui->order.entry), node_data->elements[ORDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->short_name.entry), node_data->elements[SHORT_NAME]);
	gtk_entry_set_text (GTK_ENTRY (ui->nickname.entry), node_data->elements[NICKNAME]);

	/* Opera 7 */
	gtk_entry_set_text (GTK_ENTRY (ui->trash_folder.entry), node_data->elements[TRASH_FOLDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->on_personalbar.entry), node_data->elements[ON_PERSONALBAR]);
	gtk_entry_set_text (GTK_ENTRY (ui->personalbar_pos.entry), node_data->elements[PERSONALBAR_POS]);
	gtk_entry_set_text (GTK_ENTRY (ui->active.entry), node_data->elements[ACTIVE]);
	gtk_entry_set_text (GTK_ENTRY (ui->in_panel.entry), node_data->elements[IN_PANEL]);
	gtk_entry_set_text (GTK_ENTRY (ui->panel_pos.entry), node_data->elements[PANEL_POS]);
	gtk_entry_set_text (GTK_ENTRY (ui->linkbar_folder.entry), node_data->elements[LINKBAR_FOLDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->linkbar_stop.entry), node_data->elements[LINKBAR_STOP]);

	/* Galeon */
	gtk_entry_set_text (GTK_ENTRY (ui->ref.entry), node_data->elements[REF]);
	gtk_entry_set_text (GTK_ENTRY (ui->metadata_owner.entry), node_data->elements[METADATA_OWNER]);
	gtk_entry_set_text (GTK_ENTRY (ui->default_folder.entry), node_data->elements[DEFAULT_FOLDER]);
	gtk_entry_set_text (GTK_ENTRY (ui->create_toolbar.entry), node_data->elements[CREATE_TOOLBAR]);
	gtk_entry_set_text (GTK_ENTRY (ui->toolbar_style.entry), node_data->elements[TOOLBAR_STYLE]);
	gtk_entry_set_text (GTK_ENTRY (ui->smarturl.entry), node_data->elements[SMARTURL]);
	gtk_entry_set_text (GTK_ENTRY (ui->create_context.entry), node_data->elements[CREATE_CONTEXT]);

	/* Galeon, Mozilla */
	gtk_entry_set_text (GTK_ENTRY (ui->pixmap.entry), node_data->elements[PIXMAP]);
}

