#ifndef PLUGIN_H
#define PLUGIN_H

#include <gtk/gtk.h>

#include "bk_edit_data.h"

enum
{
	PLUGIN_OK,
	PLUGIN_KO,
	PLUGIN_OUT_OF_MEMORY,
	PLUGIN_PARSE_ERROR,
	PLUGIN_NO_SUCH_FILE,
	PLUGIN_OPEN_FAILED
};


typedef struct style_tag
{
	unsigned int name                    : 1;
	unsigned int uri                     : 1;
	unsigned int comment                 : 1;
	unsigned int add_date                : 1;
	unsigned int last_visit              : 1;
	unsigned int last_modified           : 1;
	unsigned int aliasid                 : 1;
	unsigned int aliasof                 : 1;
	unsigned int id                      : 1;
	unsigned int personal_toolbar_folder : 1;
	unsigned int last_charset            : 1;
	unsigned int shortcuturl             : 1;
	unsigned int schedule                : 1;
	unsigned int last_ping               : 1;
	unsigned int ping_etag               : 1;
	unsigned int ping_last_modified      : 1;
	unsigned int ping_content_len        : 1;
	unsigned int ping_status             : 1;
	unsigned int new_bookmark_folder     : 1;
	unsigned int new_search_folder       : 1;
	unsigned int folder_group            : 1;

	/* opera */
	unsigned int order                   : 1;
	unsigned int short_name              : 1;
	unsigned int nickname                : 1;

	/* opera 7 */
	unsigned int trash_folder            : 1;
	unsigned int on_personalbar          : 1;
	unsigned int personalbar_pos         : 1;
	unsigned int active                  : 1;
	unsigned int in_panel                : 1;
	unsigned int panel_pos               : 1;
	unsigned int linkbar_folder          : 1;
	unsigned int linkbar_stop            : 1;

	/* galeon 1.2.5 */
	unsigned int default_folder          : 1;
	unsigned int create_toolbar          : 1;
	unsigned int toolbar_style           : 1;
	unsigned int pixmap                  : 1;
	unsigned int smarturl                : 1;
	unsigned int create_context          : 1;

	/* xbel, galeon 1.2.5 */
	unsigned int ref                     : 1;
	unsigned int metadata                : 1;
	unsigned int metadata_owner          : 1;
	unsigned int version                 : 1;
} style;


typedef struct plugins_tag
{
	GList *list;
} plugins;


enum plugin_type
{
	PLUGIN_LOAD = 1,
	PLUGIN_SAVE = 2,
	PLUGIN_EDIT = 4,
	PLUGIN_CONTEXT_MENU = 8,
	PLUGIN_MENU_ENTRY = 16
};


typedef struct plugin_tag
{
	char *filename;
	void *plugin;

	style folder_edit_dialog_style;
	style bookmark_edit_dialog_style;
	style separator_edit_dialog_style;
	style root_edit_dialog_style;

	char *name;
	char *short_name;
	char *description;
	char *author;

	enum plugin_type type;

	int (*init) (struct plugin_tag *plug);
	int (*cleanup) (struct plugin_tag *plug);

	int (*load) (char *filename);
	int (*save_begin) (char *filename, bk_edit_tree_data *node_data);
	void (*save_end) (void);
	void (*save_separator) (bk_edit_tree_data *node_data);
	void (*save_bookmark) (bk_edit_tree_data *node_data);
	void (*save_folder_in) (bk_edit_tree_data *node_data);
	void (*save_folder_out) (void);

	GtkWidget *edit_ui;
	void *edit_ui_data;

	GtkWidget *(*edit_ui_new) (struct plugin_tag *plug);
	void (*edit_ui_delete) (struct plugin_tag *plug);

	void (*edit_ui_set) (struct plugin_tag *plug, bk_edit_tree_data *node_data);
	void (*edit_ui_get) (struct plugin_tag *plug, bk_edit_tree_data *node_data);
} plugin;


plugins *plugin_new (plugins *plugs, char *path);
plugin *plugin_get_by_name (plugins *plugs, char *name);
plugin *plugin_get_by_short_name (plugins *plugs, char *name);
void plugin_delete (plugins *plugs);
plugin *plugin_load (plugin *plug, char *filename);


int init (plugin *plug);
int cleanup (plugin *plug);


int load (char *filename);
int save_begin (char *filename, bk_edit_tree_data *node_data);
void save_end (void);
void save_separator (bk_edit_tree_data *node_data);
void save_bookmark (bk_edit_tree_data *node_data);
void save_folder_in (bk_edit_tree_data *node_data);
void save_folder_out (void);


GtkWidget *edit_ui_new (plugin *plug);
void edit_ui_delete (plugin *plug);
void edit_ui_set (plugin *plug, bk_edit_tree_data *node_data);
void edit_ui_get (plugin *plug, bk_edit_tree_data *node_data);

#endif
