/*
 * Copyright (C) 2002 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * plugin.c - 17.02.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glob.h>
#include <dlfcn.h>

#include <gtk/gtk.h>

#include "plugin.h"


plugins *plugin_new (plugins *plugs, char *path)
{
	glob_t so;
	int ret, i;

	plugs = (plugins *) malloc (sizeof (plugins));
	if (plugs == NULL)
	{
		return NULL;
	}
	plugs->list = NULL;

	if ((ret = glob (path, GLOB_NOSORT, NULL, &so)) != 0)
	{
		if (ret == GLOB_NOMATCH)
		{
			fprintf (stderr, "plugin_new: no plugins found: %s\n", path);
		}
		perror ("plugin_new: glob ()");
		free (plugs);

		return NULL;
	}

	for (i = 0; so.gl_pathv[i] != NULL; i++)
	{
		plugin *plug = plugin_load (plug, so.gl_pathv[i]);
		if (plug == NULL)
		{
			continue;
		}

		plugs->list = g_list_append (plugs->list, plug);
	}
	globfree (&so);

	return plugs;
}


plugin *plugin_load (plugin *plug, char *filename)
{
	plug = (plugin *) malloc (sizeof (plugin));

	if (plug == NULL)
	{
		return NULL;
	}
	memset (plug, 0, sizeof (plugin));

	plug->filename = strdup (filename);
	if (plug->filename == NULL)
	{
		free (plug);
		return NULL;
	}

	plug->plugin = dlopen (plug->filename, RTLD_NOW);
	if (plug->plugin == NULL)
	{
		fprintf (stderr, "plugin_load: dlopen (): %s\n", dlerror ());
		free (plug->filename);
		free (plug);
		return NULL;
	}

	plug->init = dlsym (plug->plugin, "init");
	if (plug->init == NULL)
	{
		fprintf (stderr, "plugin_load: dlsym (): %s: %s\n", plug->filename, dlerror ());
		free (plug->filename);
		free (plug);
		return NULL;
	}

	if (plug->init (plug) != PLUGIN_OK)
	{
		fprintf (stderr, "plugin_load: plug->init () != PLUGIN_OK\n");
		free (plug->filename);
		free (plug);
		return NULL;
	}

	return plug;
}


void plugin_delete (plugins *plugs)
{
	GList *iter;

	for (iter = plugs->list; iter != NULL; iter = g_list_next (iter))
	{
		if (((plugin *) iter->data)->cleanup (((plugin *) iter->data)) != PLUGIN_OK)
		{
		}

		dlclose (((plugin *) iter->data)->plugin);

		free (((plugin *) iter->data)->filename);
		free (((plugin *) iter->data));
	}
	g_list_free (plugs->list);

	free (plugs);
}


plugin *plugin_get_by_name (plugins *plugs, char *name)
{
	GList *iter;

	for (iter = plugs->list; iter != NULL; iter = g_list_next (iter))
	{
		if (!strcmp (((plugin *) iter->data)->name, name))
		{
			return ((plugin *) iter->data);
		}
	}

	return NULL;
}


plugin *plugin_get_by_short_name (plugins *plugs, char *name)
{
	GList *iter;

	for (iter = plugs->list; iter != NULL; iter = g_list_next (iter))
	{
		if (!strcmp (((plugin *) iter->data)->short_name, name))
		{
			return ((plugin *) iter->data);
		}
	}

	return NULL;
}

