#ifndef DIALOG_OPTIONS_H
#define DIALOG_OPTIONS_H

#include <gtk/gtk.h>

#define WIN_STATE_STICKY                (1<<0)
#define WIN_HINTS_SKIP_WINLIST          (1<<1) /* not in win list */
#define WIN_HINTS_SKIP_TASKBAR          (1<<2) /* not on taskbar */

#define XA_WIN_SUPPORTING_WM_CHECK "_WIN_SUPPORTING_WM_CHECK"
#define XA_WIN_LAYER               "_WIN_LAYER"
#define XA_WIN_HINTS               "_WIN_HINTS"
#define XA_WIN_STATE               "_WIN_STATE"

typedef enum
{
	WIN_LAYER_DESKTOP = 0,
	WIN_LAYER_BELOW = 2,
	WIN_LAYER_NORMAL = 4,
	WIN_LAYER_ONTOP = 6,
	WIN_LAYER_DOCK = 8,
	WIN_LAYER_ABOVE_DOCK = 10
} WinLayer;

void dialog_options_sticky_set (GtkWidget *window, gboolean sticky);
void dialog_options_always_on_top_set (GtkWidget *window, gboolean always);

#endif
