#ifndef COMMAND_LINE_H
#define COMMAND_LINE_H

#define HELP "\n" \
		"Usage: bk_edit [option ... ]\n" \
		"\n" \
		"Options:\n" \
		"  --help                  Print this message.\n" \
		"  --load <file>           Load the specified <file>.\n" \
		"  --load-plugin <plugin>  Use the specified <plugin> for loading.\n" \
		"                          See '--load-plugin list' for all available plugins.\n" \
		"  --save <file>\n" \
		"  --save-plugin <plugin>  Use the specified <plugin> for saving.\n" \
		"                          See '--save-plugin list' for all available plugins.\n" \
		"  --version\n" \
		"\n" \
		"Examples:\n" \
		"  bk_edit --load-plugin list\n" \
		"  bk_edit --load ~/.mozilla/bookmarks.html --load-plugin Mozilla\n" \
		"  bk_edit --save-plugin list\n" \
		"  bk_edit --load ~/.mozilla/bookmarks.html --load-plugin Mozilla \\\n" \
		"          --save ~/.galeon/bookmarks.xbel --save-plugin Galeon\n" \
		"\n"

enum
{
	OPTION_LOAD = 0,
	OPTION_LOAD_PLUGIN = 1,
	OPTION_SAVE = 2,
	OPTION_SAVE_PLUGIN = 3,
	OPTION_HELP = 4,
	OPTION_VERSION = 5
};

typedef struct command_line_options_tag
{
	char *load;
	char *load_plugin;

	char *save;
	char *save_plugin;
} command_line_options;

command_line_options *command_line_new (int argc, char *argv[]);
void command_line_delete (command_line_options *o);

#endif
