/*
 * char_vector.h - v0.2 - 20.9.1999 (Artistic License)
 * Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 */

#ifndef CHAR_VECTOR_H
#define CHAR_VECTOR_H

#define CHAR_VECTOR_OK 		1
#define CHAR_VECTOR_OUT_OF_MEMORY	2
#define CHAR_VECTOR_WRONG_ARGUMENT	3

#define CHAR_VECTOR_TERMINATOR		1

typedef struct char_vector_struct {
	char *vector;

	int vector_pos;
	int vector_size;
	int vector_size_free;
	int vector_size_steps;
} char_vector;

char_vector *char_vector_new (char_vector *vector, int vector_size_steps);

void char_vector_del (char_vector *vector);

int char_vector_add (char_vector *vector, char character);

int char_vector_add_string (char_vector *vector, const char *string);

#endif
