/*
 * char_vector.c - v0.2 - 20.9.1999 (Artistic License)
 * Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 */

#include <stdlib.h>

#include "char_vector.h"

char_vector *char_vector_new (char_vector *vector, int vector_size_steps)
{
	vector = (char_vector *) malloc (sizeof (char_vector));
	if (vector == NULL)
	{
		return NULL;
	}

	vector->vector = (char *) malloc (vector_size_steps +
					  CHAR_VECTOR_TERMINATOR);
	if (vector->vector == NULL)
	{
		free (vector);

		return NULL;
	}

	vector->vector_pos = 0;
	vector->vector_size = vector_size_steps;
	vector->vector_size_free = vector_size_steps;
	vector->vector_size_steps = vector_size_steps;

	vector->vector[vector->vector_pos] = '\0';

	return vector;
}

void char_vector_del (char_vector *vector)
{
	free (vector->vector);
	free (vector);
}

int char_vector_add (char_vector *vector, char character)
{
	if (!vector->vector_size_free)
	{
		char *foo = (char *) realloc (vector->vector,
			    	   	      vector->vector_size +
					      vector->vector_size_steps +
					      CHAR_VECTOR_TERMINATOR);
		if (vector->vector == NULL)
		{
			return CHAR_VECTOR_OUT_OF_MEMORY;
		}
		vector->vector = foo;

		vector->vector_size += vector->vector_size_steps;
		vector->vector_size_free = vector->vector_size_steps;
	}

	vector->vector[vector->vector_pos] = character;

	vector->vector_size_free--;
	vector->vector_pos++;

	vector->vector[vector->vector_pos] = '\0';

	return CHAR_VECTOR_OK;
}

int char_vector_add_string (char_vector *vector, const char *string)
{
	int ret;

	if (string == NULL)
	{
		return CHAR_VECTOR_WRONG_ARGUMENT;
	}

	while (*string != '\0')
	{
		if ((ret = char_vector_add (vector, *string)) != CHAR_VECTOR_OK)
		{
			return ret;
		}
		string++;

	}

	return CHAR_VECTOR_OK;
}
