#ifndef BK_EDIT_TREE_H
#define BK_EDIT_TREE_H

#include <stdio.h>

#include <gtk/gtk.h>

#include "bk_edit_data.h"
#include "bk_edit_date.h"

#include "plugin.h"
#include "g_stack.h"

enum
{
	BK_EDIT_TREE_OK,
	BK_EDIT_TREE_KO
};

typedef struct bk_edit_tree_tag
{
	GtkCTreeNode *selected_node;

	int id;
	int order;

	GtkWidget    *tree;
	GtkCTreeNode *tree_node;
	g_stack      *tree_stack;
	g_stack      *order_stack;
} bk_edit_tree;

void bk_edit_tree_expand (void);
void bk_edit_tree_collapse (void);

int bk_edit_tree_add_root_node (bk_edit_tree_data *node_data);
int bk_edit_tree_add_bookmark_node (bk_edit_tree_data *node_data);
int bk_edit_tree_add_folder_node (bk_edit_tree_data *node_data);
int bk_edit_tree_add_separator (bk_edit_tree_data *node_data);
int bk_edit_tree_leave_folder (void);

void bk_edit_tree_save (plugin *plug, char *filename);
void bk_edit_tree_save_traverse (plugin *plug, GtkCTreeNode *node);
void bk_edit_tree_destroy (gpointer data);
void bk_edit_tree_date_update (GtkCTree *tree, GtkCTreeNode *node, bk_edit_tree_data *node_data);
void bk_edit_tree_button_press_event (GtkWidget *ctree, GdkEventButton *event, gpointer data);

void bk_edit_tree_select_row (GtkCTree *ctree, GtkCTreeNode *node, gint row, gpointer null);
void bk_edit_tree_unselect_row (GtkCTree *ctree, GtkCTreeNode *node, gint column, gpointer null);
void bk_edit_tree_move (GtkCTree *ctree, GtkCTreeNode *node, GtkCTreeNode *parent, GtkCTreeNode *sibling, gpointer data);
void bk_edit_tree_move_after (GtkCTree *ctree, GtkCTreeNode *node, GtkCTreeNode *parent, GtkCTreeNode *sibling, gpointer data);

gboolean bk_edit_tree_to_gnode (GtkCTree *ctree, guint depth, GNode *gnode, GtkCTreeNode *cnode, gpointer data);
gboolean bk_edit_gnode_to_tree (GtkCTree *ctree, guint depth, GNode *gnode, GtkCTreeNode *cnode, gpointer data);

void bk_edit_tree_destroy_gnode_tree (GNode *gnode_tree);
gboolean bk_edit_destroy_gnode (GNode *node, gpointer data);

void bk_edit_tree_key_pressed (GtkCTree *ctree, GdkEventKey *event, gpointer *data);
gboolean bk_edit_tree_drag_motion (GtkWidget *widget, GdkDragContext *dc, gint x, gint y, guint t, gpointer data);

#endif
