#ifndef BK_EDIT_MISC_H
#define BK_EDIT_MISC_H

#include <gtk/gtk.h>

enum
{
	HIDE,
	SHOW
};

typedef struct bk_edit_input_tag
{
	GtkWidget *label;
	GtkWidget *entry;
} bk_edit_input;

int bk_edit_misc_set_menu_option (GtkOptionMenu *menu_option, char *set_to_this);
char *bk_edit_misc_get_menu_option (GtkOptionMenu *menu_option);

int bk_edit_misc_get_selection (GtkCList *list);
void bk_edit_misc_toggle_widget (GtkWidget *widget, int flag);
void bk_edit_misc_input_create (bk_edit_input *input, gchar *title);
char *bk_edit_misc_get_user_home_dir (void);

char *bk_edit_misc_strcasestr (const char *s1, const char *s2);
char *bk_edit_misc_strescape (char *string, char escape);

void bk_edit_misc_remove_char_from_str (char *string, char c);

int bk_edit_misc_mixed_utf8_to_latin1 (unsigned char *out, int *out_len, unsigned char *in, int *in_len);
int bk_edit_misc_utf8_to_latin1_in_place (char **text);
char *bk_edit_misc_utf8_to_latin1 (char *in);
char *bk_edit_misc_latin1_to_utf8 (char *in);

char *bk_edit_misc_xml_entities_encode (char *in);
char *bk_edit_misc_xml_entities_decode (char *in);

char *bk_edit_misc_html_entities_encode_without_utf8 (char *in, char *charset);
char *bk_edit_misc_html_entities_encode (char *in, char *charset);
char *bk_edit_misc_html_entities_decode (char *in);

int bk_edit_misc_create_backup_file (char *name);

#endif
