/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_edit.c - 23.05.2003 - v0.10 - modify indicator rewrite
 *                  17.04.2003 - v0.9 - sort order
 *                  01.03.2003 - v0.8 - some ui improvements
 *                  12.02.2003 - v0.7 - modify indicator added
 *                  23.12.2002 - v0.6 - plugin api clean-up
 *                  06.12.2002 - v0.5 - make it compatible with mozilla v1.0, v1.1 and v1.2
 *                  05.09.2002 - v0.4 - galeon 1.2.5 plugin
 *                  08.03.2002 - v0.3 - new
 *                  26.02.2002 - v0.2 - plugin functionality
 *                  20.10.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <time.h>
#include <stdlib.h>
#include <string.h>

#include "bk_edit.h"
#include "bk_edit_date.h"
#include "bk_edit_edit.h"
#include "bk_edit_tree.h"
#include "bk_edit_undo.h"
#include "bk_edit_icon.h"
#include "bk_edit_file.h"
#include "bk_edit_sort.h"
#include "bk_edit_modify_indicator.h"

#include "bk_edit_dialog_box.h"
#include "bk_edit_dialog_main.h"
#include "bk_edit_dialog_undo.h"
#include "bk_edit_dialog_edit.h"
#include "bk_edit_dialog_info.h"

extern plugins *plugs;

extern bk_edit_tree tree;
extern bk_edit_undo *undo;
extern bk_edit_modify_indicator *modify_indicator;

extern bk_edit_dialog_main dialog_main;
extern bk_edit_dialog_edit dialog_edit;


static int set_order (GtkCTreeNode *sibling)
{
	if (tree.selected_node == NULL)
	{
		return bk_edit_sort_get_highest_order (GTK_CTREE_NODE (GTK_CLIST (tree.tree)->row_list), NULL);
	}
	else if (bk_edit_sort_menu_state_is_unsorted () != OK)
	{
		/*
		 * If the tree is sorted in some way, the new node will
		 * always get the highest order of the current folder.
		 */
		GtkCTreeNode *parent = GTK_CTREE_ROW (sibling)->parent;
		if (parent != NULL)
		{
			return bk_edit_sort_get_highest_order (parent, NULL);
		}
		else
		{
			return bk_edit_sort_get_highest_order (GTK_CTREE_NODE (GTK_CLIST (tree.tree)->row_list), NULL);
		}
	}

	return -1;
}


void bk_edit_new_bookmark (void)
{
	GtkCTreeNode *sibling = tree.selected_node;
	GtkCTreeNode *node;

	bk_edit_tree_data *node_data = (bk_edit_tree_data *) malloc (sizeof (bk_edit_tree_data));

	gchar timestr[20];
	gint i;

	if (sibling == NULL)
	{
		sibling = gtk_ctree_node_nth (GTK_CTREE (tree.tree), 0);

		if (sibling == NULL)
		{
			return;
		}
	}

	node_data->type = BOOKMARK;
	node_data->id = tree.id++;
	node_data->order = set_order (sibling);

	for (i = 0; i < ELEMENTS; i++)
	{
		node_data->elements[i] = strdup ("");
	}

	free (node_data->elements[NAME]);
	node_data->elements[NAME] = strdup ("New Bookmark");

	free (node_data->elements[ADD_DATE]);
	snprintf (timestr, sizeof (timestr), "%ld", time (NULL));
	node_data->elements[ADD_DATE] = strdup (timestr);

	gtk_clist_freeze (GTK_CLIST (tree.tree));

	if (GTK_CTREE_ROW (sibling)->parent == NULL)
	{
		node = gtk_ctree_insert_node (GTK_CTREE (tree.tree), sibling, NULL, node_data->elements, 4, bookmark_item_pix, bookmark_item_mask, bookmark_item_pix, bookmark_item_mask, TRUE, FALSE);
	}
	else
	{
		node = gtk_ctree_insert_node (GTK_CTREE (tree.tree), GTK_CTREE_ROW (sibling)->parent, GTK_CTREE_ROW (sibling)->sibling, node_data->elements, 4, bookmark_item_pix, bookmark_item_mask, bookmark_item_pix, bookmark_item_mask, TRUE, FALSE);
	}

	gtk_ctree_node_set_row_data_full (GTK_CTREE (tree.tree), node, node_data, bk_edit_tree_destroy);
	bk_edit_tree_date_update (GTK_CTREE (tree.tree), node, node_data);

	/* undo */
	bk_edit_undo_add_new_item (node, node_data);

	bk_edit_sort_reorder_folder (GTK_CTREE_ROW (node)->parent, NULL);
	bk_edit_sort_sort (bk_edit_sort_menu_get_menu_state (), gtk_ctree_sort_node, GTK_CTREE_ROW (node)->parent);

	if (gtk_ctree_node_is_visible (GTK_CTREE (tree.tree), node) != GTK_VISIBILITY_FULL)
	{
		gtk_ctree_node_moveto (GTK_CTREE (tree.tree), node, 0, 0, 0);
	}
	gtk_ctree_select (GTK_CTREE (tree.tree), node);

	gtk_clist_thaw (GTK_CLIST (tree.tree));
}


void bk_edit_new_folder (void)
{
	GtkCTreeNode *sibling = tree.selected_node;
	GtkCTreeNode *node;

	bk_edit_tree_data *node_data = (bk_edit_tree_data *) malloc (sizeof (bk_edit_tree_data));

	gchar timestr[20];
	gint i;

	if (sibling == NULL)
	{
		sibling = gtk_ctree_node_nth (GTK_CTREE (tree.tree), 0);
		if (sibling == NULL)
		{
			return;
		}
	}

	node_data->type = FOLDER;
	node_data->id = tree.id++;
	node_data->order = set_order (sibling);

	for (i = 0; i < ELEMENTS; i++)
	{
		node_data->elements[i] = strdup ("");
	}

	free (node_data->elements[NAME]);
	node_data->elements[NAME] = strdup ("New Folder");

	free (node_data->elements[ADD_DATE]);
	snprintf (timestr, sizeof (timestr), "%ld", time (NULL));
	node_data->elements[ADD_DATE] = strdup (timestr);

	gtk_clist_freeze (GTK_CLIST (tree.tree));

	if (GTK_CTREE_ROW (sibling)->parent == NULL)
	{
		node = gtk_ctree_insert_node (GTK_CTREE (tree.tree), sibling, NULL, node_data->elements, 4, bookmark_folder_closed_pix, bookmark_folder_closed_mask, bookmark_folder_open_pix, bookmark_folder_open_mask, FALSE, FALSE);
	}
	else
	{
		node = gtk_ctree_insert_node (GTK_CTREE (tree.tree), GTK_CTREE_ROW (sibling)->parent, GTK_CTREE_ROW (sibling)->sibling, node_data->elements, 4, bookmark_folder_closed_pix, bookmark_folder_closed_mask, bookmark_folder_open_pix, bookmark_folder_open_mask, FALSE, FALSE);
	}

	gtk_ctree_node_set_row_data_full (GTK_CTREE (tree.tree), node, node_data, bk_edit_tree_destroy);
	bk_edit_tree_date_update (GTK_CTREE (tree.tree), node, node_data);

	/* undo */
	bk_edit_undo_add_new_item (node, node_data);

	bk_edit_sort_reorder_folder (GTK_CTREE_ROW (node)->parent, NULL);
	bk_edit_sort_sort (bk_edit_sort_menu_get_menu_state (), gtk_ctree_sort_node, GTK_CTREE_ROW (node)->parent);

	if (gtk_ctree_node_is_visible (GTK_CTREE (tree.tree), node) != GTK_VISIBILITY_FULL)
	{
		gtk_ctree_node_moveto (GTK_CTREE (tree.tree), node, 0, 0, 0);
	}
	gtk_ctree_select (GTK_CTREE (tree.tree), node);

	gtk_clist_thaw (GTK_CLIST (tree.tree));
}


void bk_edit_new_separator (void)
{
	GtkCTreeNode *sibling = tree.selected_node;
	GtkCTreeNode *node;

	bk_edit_tree_data *node_data = (bk_edit_tree_data *) malloc (sizeof (bk_edit_tree_data));

	gint i;

	if (sibling == NULL)
	{
		sibling = gtk_ctree_node_nth (GTK_CTREE (tree.tree), 0);

		if (sibling == NULL)
		{
			return;
		}
	}

	node_data->type = SEPARATOR;
	node_data->id = tree.id++;
	node_data->order = set_order (sibling);

	for (i = 0; i < ELEMENTS; i++)
	{
		node_data->elements[i] = strdup ("");
	}

	free (node_data->elements[NAME]);
	node_data->elements[NAME] = strdup ("-----------------");

	gtk_clist_freeze (GTK_CLIST (tree.tree));

	if (GTK_CTREE_ROW (sibling)->parent == NULL)
	{
		node = gtk_ctree_insert_node (GTK_CTREE (tree.tree), sibling, NULL, node_data->elements, 4, NULL, NULL, NULL, NULL, TRUE, FALSE);
	}
	else
	{
		node = gtk_ctree_insert_node (GTK_CTREE (tree.tree), GTK_CTREE_ROW (sibling)->parent, GTK_CTREE_ROW (sibling)->sibling, node_data->elements, 4, NULL, NULL, NULL, NULL, TRUE, FALSE);
	}

	gtk_ctree_node_set_row_data_full (GTK_CTREE (tree.tree), node, node_data, bk_edit_tree_destroy);

	/* undo */
	bk_edit_undo_add_new_item (node, node_data);

	bk_edit_sort_reorder_folder (GTK_CTREE_ROW (node)->parent, NULL);
	bk_edit_sort_sort (bk_edit_sort_menu_get_menu_state (), gtk_ctree_sort_node, GTK_CTREE_ROW (node)->parent);

	if (gtk_ctree_node_is_visible (GTK_CTREE (tree.tree), node) != GTK_VISIBILITY_FULL)
	{
		gtk_ctree_node_moveto (GTK_CTREE (tree.tree), node, 0, 0, 0);
	}
	gtk_ctree_select (GTK_CTREE (tree.tree), node);

	gtk_clist_thaw (GTK_CLIST (tree.tree));
}


void bk_edit_delete (void)
{
	if (tree.selected_node != NULL)
	{
		GtkCTreeNode *node = tree.selected_node;
		GtkCTreeNode *parent = GTK_CTREE_ROW (node)->parent;

		/* undo */
		if (bk_edit_undo_add_delete_item (node) != BK_EDIT_UNDO_OK)
		{
			bk_edit_dialog_info ("bk edit - fatal error", "can't save undo status (bk_edit_undo_add_delete_item).", icon_warning);
			return;
		}

		gtk_ctree_remove_node (GTK_CTREE (tree.tree), node);

		bk_edit_sort_reorder_folder (parent, NULL);

		tree.selected_node = NULL;
	}
}


void bk_edit_edit (void)
{
	if (tree.selected_node != NULL)
	{
		GtkCTreeNode *node = tree.selected_node;

		if (node != NULL)
		{
			bk_edit_tree_data *node_data = (bk_edit_tree_data *) gtk_ctree_node_get_row_data (GTK_CTREE (tree.tree), node);
			bk_edit_dialog_edit_show ("bk edit - edit", node, node_data);
		}
	}
}


void bk_edit_edit_ok (GtkCTreeNode *node)
{
	GtkCTreeNode *parent;
	GtkWidget *current_page = gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog_edit.notebook), gtk_notebook_get_current_page (GTK_NOTEBOOK (dialog_edit.notebook)));
	GList *iter;

	plugin *plug;

	bk_edit_tree_data *node_data = (bk_edit_tree_data *) gtk_ctree_node_get_row_data (GTK_CTREE (tree.tree), node);

	/* undo */
	if (bk_edit_undo_add_edit_item (node, node_data) != BK_EDIT_UNDO_OK)
	{
		bk_edit_dialog_info ("bk edit - fatal error", "can't save undo status (bk_edit_undo_add_delete_item).", icon_warning);
		return;
	}

	for (iter = plugs->list; iter != NULL; iter = g_list_next (iter))
	{
		plug = (plugin *) iter->data;

		if (current_page == plug->edit_ui)
		{
			plug->edit_ui_get (plug, node_data);
		}
	}

	gtk_ctree_node_set_text (GTK_CTREE (tree.tree), node, NAME, node_data->elements[NAME]);
	gtk_ctree_node_set_text (GTK_CTREE (tree.tree), node, URI, node_data->elements[URI]);
	gtk_ctree_node_set_text (GTK_CTREE (tree.tree), node, COMMENT, node_data->elements[COMMENT]);
	gtk_ctree_node_set_text (GTK_CTREE (tree.tree), node, ADD_DATE, node_data->elements[ADD_DATE]);
	gtk_ctree_node_set_text (GTK_CTREE (tree.tree), node, LAST_VISIT, node_data->elements[LAST_VISIT]);
	gtk_ctree_node_set_text (GTK_CTREE (tree.tree), node, LAST_MODIFIED, node_data->elements[LAST_MODIFIED]);
	gtk_ctree_node_set_text (GTK_CTREE (tree.tree), node, ALIASID, node_data->elements[ALIASID]);
	gtk_ctree_node_set_text (GTK_CTREE (tree.tree), node, ALIASOF, node_data->elements[ALIASOF]);

	if (node_data->type == BOOKMARK)
	{
		gtk_ctree_node_set_pixtext (GTK_CTREE (tree.tree), node, NAME, node_data->elements[NAME], 4, bookmark_item_pix, bookmark_item_mask);
	}
	else if (node_data->type == FOLDER)
	{
		gtk_ctree_node_set_pixtext (GTK_CTREE (tree.tree), node, NAME, node_data->elements[NAME], 4, GTK_CTREE_ROW (node)->expanded == 0 ? bookmark_folder_closed_pix : bookmark_folder_open_pix, GTK_CTREE_ROW (node)->expanded == 0 ? bookmark_folder_closed_mask : bookmark_folder_open_mask);
	}
	else if (node_data->type == TOP)
	{
		gtk_ctree_node_set_pixtext (GTK_CTREE (tree.tree), node, NAME, node_data->elements[NAME], 4, GTK_CTREE_ROW (node)->expanded == 0 ? bookmark_folder_closed_pix : bookmark_folder_open_pix, GTK_CTREE_ROW (node)->expanded == 0 ? bookmark_folder_closed_mask : bookmark_folder_open_mask);
	}
	else if (node_data->type == SEPARATOR)
	{
	}

	bk_edit_tree_date_update (GTK_CTREE (tree.tree), node, node_data);

	parent = GTK_CTREE_ROW (node)->parent;
	if (parent != NULL)
	{
		bk_edit_sort_sort (bk_edit_sort_menu_get_menu_state (), gtk_ctree_sort_node, parent);
	}
	else
	{
		bk_edit_sort_sort (bk_edit_sort_menu_get_menu_state (), gtk_ctree_sort_node, GTK_CTREE_NODE (GTK_CLIST (tree.tree)->row_list));
	}
}


void bk_edit_new (void)
{
	if (bk_edit_modify_indicator_is_modified (modify_indicator, CURRENT_UNDO_STACK_ENTRY) == IS_NOT_MODIFIED)
	{
		bk_edit_new_ok (NULL, NULL);
	}
	else
	{
		bk_edit_dialog_box ("bk edit - warning", "This will discard all unsaved data.", icon_warning, bk_edit_new_ok, NULL, NULL);
	}
}


void bk_edit_new_ok (GtkWidget *dialog, void *null)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));
	node_data.elements[NAME] = "New";

	/* */
	tree.selected_node = NULL;

	if (dialog_edit.dialog != NULL)
	{
		gtk_widget_hide (GTK_WIDGET (dialog_edit.dialog));
        }

	gtk_clist_clear (GTK_CLIST (tree.tree));

	tree.tree_stack = g_stack_new (tree.tree_stack);
	tree.order_stack = g_stack_new (tree.order_stack);
	bk_edit_tree_add_root_node (&node_data);
	g_stack_delete (tree.order_stack);
	g_stack_delete (tree.tree_stack);

	bk_edit_file_unset_currently_opened_file ();

	/* undo */
	bk_edit_undo_delete (undo);
	undo = bk_edit_undo_new (undo);
	bk_edit_dialog_undo_update ();
}

