/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_dialog_undo.c - 23.05.2003 - v0.3 - modify indicator rewrite
 *                         12.02.2003 - v0.2 - modify indicator added
 *                         05.09.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdlib.h>

#include "bk_edit_file.h"
#include "bk_edit_undo.h"
#include "bk_edit_dialog_main.h"
#include "bk_edit_dialog_undo.h"
#include "bk_edit_modify_indicator.h"

extern bk_edit_undo *undo;
extern bk_edit_dialog_main dialog_main;
extern bk_edit_dialog_undo dialog_undo;
extern bk_edit_modify_indicator *modify_indicator;


void bk_edit_dialog_undo_show (void)
{
	if (dialog_undo.dialog == NULL)
	{
		gchar *list_titles[] = { " # ", " Undo Action " };

		/* dialog window */
		dialog_undo.dialog = gtk_window_new (GTK_WINDOW_DIALOG);
		gtk_window_set_title (GTK_WINDOW (dialog_undo.dialog), "bk edit - undo stack");
		gtk_window_position (GTK_WINDOW (dialog_undo.dialog), GTK_WIN_POS_MOUSE);
		gtk_window_set_policy (GTK_WINDOW (dialog_undo.dialog), FALSE, FALSE, TRUE);
		gtk_widget_set_usize (GTK_WIDGET (dialog_undo.dialog), 400, 200);
		gtk_container_set_border_width (GTK_CONTAINER (dialog_undo.dialog), 4);
		gtk_signal_connect_object (GTK_OBJECT (dialog_undo.dialog), "delete_event",
			GTK_SIGNAL_FUNC (gtk_widget_hide_all), GTK_OBJECT (dialog_undo.dialog));
		gtk_widget_realize (dialog_undo.dialog);

		/* box */
		dialog_undo.box = gtk_vbox_new (FALSE, 1);

		/* list */
		dialog_undo.list = gtk_clist_new_with_titles (2, list_titles);
		gtk_clist_set_shadow_type (GTK_CLIST (dialog_undo.list), GTK_SHADOW_IN);
		gtk_clist_set_selection_mode (GTK_CLIST (dialog_undo.list), GTK_SELECTION_SINGLE);
		gtk_clist_column_titles_active (GTK_CLIST (dialog_undo.list));
		gtk_clist_set_column_auto_resize (GTK_CLIST (dialog_undo.list), 0, TRUE);

		/* scrollcontainer */
		dialog_undo.scroll = gtk_scrolled_window_new (NULL, NULL);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (dialog_undo.scroll),
							GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

		/* pack */
		gtk_container_add (GTK_CONTAINER (dialog_undo.scroll), dialog_undo.list);
		gtk_box_pack_start (GTK_BOX (dialog_undo.box), dialog_undo.scroll, TRUE, TRUE, 0);
		gtk_container_add (GTK_CONTAINER (dialog_undo.dialog), dialog_undo.box);
	}

	/* */
	gtk_widget_show_all (dialog_undo.dialog);

	/* raise */
	gdk_window_show (dialog_undo.dialog->window);

	/* */
	bk_edit_dialog_undo_update ();
}


void bk_edit_dialog_undo_update (void)
{
	gint i;

	/* modify indicator */
	bk_edit_modify_indicator_update (modify_indicator, CURRENT_UNDO_STACK_ENTRY);

	if (dialog_undo.dialog == NULL)
	{
		return;
	}

	if (!GTK_WIDGET_VISIBLE (dialog_undo.dialog))
	{
		return;
	}

	gtk_clist_freeze (GTK_CLIST (dialog_undo.list));
	gtk_clist_clear (GTK_CLIST (dialog_undo.list));

	for (i = 0; i < undo->undo_stack->stack_pointer; i++)
	{
		gchar *row[2];

		row[0] = g_strdup_printf ("%-d", i);
		row[1] = (((bk_edit_undo_item *) (undo->undo_stack->stack[i]))->undo_type == UNDO_EDIT)  ? "UNDO_EDIT"   :
			(((bk_edit_undo_item *) (undo->undo_stack->stack[i]))->undo_type == UNDO_NEW)    ? "UNDO_NEW"    :
			(((bk_edit_undo_item *) (undo->undo_stack->stack[i]))->undo_type == UNDO_DELETE) ? "UNDO_DELETE" :
			(((bk_edit_undo_item *) (undo->undo_stack->stack[i]))->undo_type == UNDO_MOVE)   ? "UNDO_MOVE"   :
			(((bk_edit_undo_item *) (undo->undo_stack->stack[i]))->undo_type == UNDO_CUT)    ? "UNDO_CUT"    :
			(((bk_edit_undo_item *) (undo->undo_stack->stack[i]))->undo_type == UNDO_PASTE)  ? "UNDO_PASTE"  : "Unknown";
		gtk_clist_append (GTK_CLIST (dialog_undo.list), row);
		free (row[0]);
	}

	gtk_clist_thaw (GTK_CLIST (dialog_undo.list));
	gtk_clist_moveto (GTK_CLIST (dialog_undo.list), i - 1, 0, 1, 1);
	gtk_clist_select_row (GTK_CLIST (dialog_undo.list), i - 1, 0);
}

