/*
 * Copyright (C) 2002 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_dialog_plugin.c - 26.02.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "plugin.h"

#include "bk_edit_dialog_plugin.h"

extern plugins *plugs;

extern bk_edit_dialog_plugin dialog_plugin;

void bk_edit_dialog_plugin_show (void)
{
	GList *iter;

	if (dialog_plugin.dialog == NULL)
	{
		gchar *list_titles[] = { " Name ", " Author ", " Description " };

		/* dialog */
		dialog_plugin.dialog = gtk_window_new (GTK_WINDOW_DIALOG);
		gtk_window_set_title (GTK_WINDOW (dialog_plugin.dialog), "bk edit - plugins");
		gtk_window_position (GTK_WINDOW (dialog_plugin.dialog), GTK_WIN_POS_MOUSE);
		gtk_window_set_policy (GTK_WINDOW (dialog_plugin.dialog), FALSE, FALSE, TRUE);
		gtk_widget_set_usize (GTK_WIDGET (dialog_plugin.dialog), 400, 200);
		gtk_container_set_border_width (GTK_CONTAINER (dialog_plugin.dialog), 4);
		gtk_signal_connect_object (GTK_OBJECT (dialog_plugin.dialog), "delete_event",
			GTK_SIGNAL_FUNC (gtk_widget_hide_all), GTK_OBJECT (dialog_plugin.dialog));
		gtk_widget_realize (dialog_plugin.dialog);

		/* box */
		dialog_plugin.box = gtk_vbox_new (FALSE, 1);

		/* list */
		dialog_plugin.list = gtk_clist_new_with_titles (3, list_titles);
		gtk_clist_set_shadow_type (GTK_CLIST (dialog_plugin.list), GTK_SHADOW_IN);
		gtk_clist_set_selection_mode (GTK_CLIST (dialog_plugin.list), GTK_SELECTION_SINGLE);
		gtk_clist_column_titles_active (GTK_CLIST (dialog_plugin.list));
		gtk_clist_set_column_auto_resize (GTK_CLIST (dialog_plugin.list), 0, TRUE);
		gtk_clist_set_column_auto_resize (GTK_CLIST (dialog_plugin.list), 1, TRUE);
		gtk_clist_set_column_auto_resize (GTK_CLIST (dialog_plugin.list), 2, TRUE);

		/* scrollcontainer */
		dialog_plugin.scroll = gtk_scrolled_window_new (NULL, NULL);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (dialog_plugin.scroll),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

		/* pack */
		gtk_container_add (GTK_CONTAINER (dialog_plugin.scroll), dialog_plugin.list);
		gtk_box_pack_start (GTK_BOX (dialog_plugin.box), dialog_plugin.scroll, TRUE, TRUE, 0);
		gtk_container_add (GTK_CONTAINER (dialog_plugin.dialog), dialog_plugin.box);

		/* fill in */
		for (iter = plugs->list; iter != NULL; iter = g_list_next (iter))
		{
			gchar *row[3];

			row[0] = (((plugin *) iter->data)->name);
			row[1] = (((plugin *) iter->data)->author);
			row[2] = (((plugin *) iter->data)->description);

			gtk_clist_append (GTK_CLIST (dialog_plugin.list), row);
		}
	}

	/* */
	gtk_widget_show_all (dialog_plugin.dialog);

	/* raise */
	gdk_window_show (dialog_plugin.dialog->window);
}

