/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_dialog_main.c - 17.04.2003 - v0.6 - sort order
 *                         01.03.2003 - v0.5 - "Recently Opened Documents"
 *                         15.02.2003 - v0.4 - url handler
 *                         11.02.2003 - v0.3 - pos1, end
 *                         18.12.2002 - v0.2 - external drag and drop support
 *                         20.10.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "bk_edit.h"
#include "bk_edit_dnd.h"
#include "bk_edit_edit.h"
#include "bk_edit_menu.h"
#include "bk_edit_icon.h"
#include "bk_edit_tree.h"
#include "bk_edit_url_handler.h"
#include "bk_edit_dialog_main.h"

extern bk_edit_tree tree;
extern bk_edit_dialog_main dialog_main;


void bk_edit_dialog_main_show (void)
{
	GtkWidget *vbox, *scroll;

	int popup_size;
	GtkItemFactoryEntry *popup_items;

	int menubar_size;
	GtkItemFactoryEntry *menubar_items;

	gchar *bk_edit_tree_titles[] = { " Name ",
					" Location ",
					" Comment ",
					" Add Date ",
					" Last Visit ",
					" Last Modified ",
					" Alias ID ",
					" Alias Of " };

	/* main window */
	dialog_main.dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (dialog_main.dialog), "bk edit");
	gtk_window_set_policy (GTK_WINDOW (dialog_main.dialog), TRUE, TRUE, TRUE);
	gtk_widget_set_usize (GTK_WIDGET (dialog_main.dialog), 600, 400);
	gtk_window_position (GTK_WINDOW (dialog_main.dialog), GTK_WIN_POS_NONE);
	gtk_signal_connect (GTK_OBJECT (dialog_main.dialog), "delete_event",
				GTK_SIGNAL_FUNC (bk_edit_quit), NULL);
	gtk_widget_realize (dialog_main.dialog);

	/* main vbox */
	vbox = gtk_vbox_new (FALSE, 1);
	gtk_container_border_width (GTK_CONTAINER (vbox), 1);

	/* main menubar */
	dialog_main.menubar_accelerators = gtk_accel_group_new ();
	dialog_main.menubar_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", dialog_main.menubar_accelerators);

	menubar_size = bk_edit_menubar_build (&menubar_items);
	gtk_item_factory_create_items (dialog_main.menubar_factory, menubar_size, menubar_items, NULL);
	bk_edit_menubar_free (menubar_items, menubar_size);

	gtk_window_add_accel_group (GTK_WINDOW (dialog_main.dialog), dialog_main.menubar_accelerators);
	dialog_main.menubar = gtk_item_factory_get_widget (dialog_main.menubar_factory, "<main>");

	/* menubar handle box */
	dialog_main.menubar_handle_box = gtk_handle_box_new ();

	/* scrollbar container */
	scroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scroll), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

	/* ctree */
	tree.tree = gtk_ctree_new_with_titles (BK_EDIT_CTREE_COLS, 0, bk_edit_tree_titles);
	gtk_clist_set_shadow_type (GTK_CLIST (tree.tree), GTK_SHADOW_IN);
	gtk_clist_set_selection_mode (GTK_CLIST (tree.tree), GTK_SELECTION_SINGLE);
	gtk_clist_set_row_height (GTK_CLIST (tree.tree), 19);
	gtk_clist_set_column_width (GTK_CLIST (tree.tree), NAME, 350);
	gtk_clist_set_column_auto_resize (GTK_CLIST (tree.tree), ADD_DATE, TRUE);
	gtk_clist_set_column_auto_resize (GTK_CLIST (tree.tree), LAST_VISIT, TRUE);
	gtk_clist_set_column_auto_resize (GTK_CLIST (tree.tree), LAST_MODIFIED, TRUE);
	gtk_clist_column_titles_active (GTK_CLIST (tree.tree));
	gtk_signal_connect (GTK_OBJECT (tree.tree), "tree-select-row",
			GTK_SIGNAL_FUNC (bk_edit_tree_select_row), NULL);
	gtk_signal_connect (GTK_OBJECT (tree.tree), "tree-unselect-row",
			GTK_SIGNAL_FUNC (bk_edit_tree_unselect_row), NULL);
	gtk_signal_connect (GTK_OBJECT (tree.tree), "tree_move",
				GTK_SIGNAL_FUNC (bk_edit_tree_move), NULL);
	gtk_signal_connect_after (GTK_OBJECT (tree.tree), "tree_move",
				GTK_SIGNAL_FUNC (bk_edit_tree_move_after), NULL);
	gtk_signal_connect (GTK_OBJECT (tree.tree), "key_press_event",
				GTK_SIGNAL_FUNC (bk_edit_tree_key_pressed), NULL);

	gtk_clist_set_reorderable (GTK_CLIST (tree.tree), TRUE);

	/* add dnd support */
	bk_edit_dnd_add_drop_support (GTK_WIDGET (tree.tree));

	/* edit popup */
	dialog_main.popup = gtk_item_factory_new (GTK_TYPE_MENU, "<popup>", NULL);
	popup_size = bk_edit_menu_popup_build (&popup_items);
	gtk_item_factory_create_items (dialog_main.popup, popup_size, popup_items, NULL);
	bk_edit_menu_popup_free (popup_items, popup_size);

	/* url handler */
	gtk_signal_connect (GTK_OBJECT (tree.tree), "button_press_event",
				GTK_SIGNAL_FUNC (bk_edit_url_handler_button_press_event), NULL);

	/* */
	gtk_signal_connect_after (GTK_OBJECT (tree.tree), "button_press_event",
				GTK_SIGNAL_FUNC (bk_edit_tree_button_press_event),
				GTK_OBJECT (dialog_main.popup));

	/* icons */
	bookmark_folder_closed_pix = gdk_pixmap_create_from_xpm_d (dialog_main.dialog->window, &bookmark_folder_closed_mask, NULL, (gchar **) bookmark_folder_closed);
	bookmark_folder_open_pix   = gdk_pixmap_create_from_xpm_d (dialog_main.dialog->window, &bookmark_folder_open_mask, NULL, (gchar **) bookmark_folder_open);
	bookmark_item_pix          = gdk_pixmap_create_from_xpm_d (dialog_main.dialog->window, &bookmark_item_mask, NULL, (gchar **) bookmark_item);

	/* */
	gtk_container_add (GTK_CONTAINER (dialog_main.menubar_handle_box), dialog_main.menubar);
	gtk_box_pack_start (GTK_BOX (vbox), dialog_main.menubar_handle_box, FALSE, TRUE, 0);
	gtk_container_add (GTK_CONTAINER (scroll), tree.tree);
	gtk_box_pack_start (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
	gtk_container_add (GTK_CONTAINER (dialog_main.dialog), vbox);

	/* */
	gtk_widget_show_all (GTK_WIDGET (dialog_main.dialog));

	/* */
	bk_edit_new_ok (NULL, NULL);
}

