/*
 * Copyright (C) 2002-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_dialog_dnd.c - 07.03.2003 - v0.2 - bk_edit_dialog_dnd_update
 *                        18.12.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdlib.h>

#include "config.h"
#include "dialog_options.h"

#include "bk_edit_dnd.h"
#include "bk_edit_dialog_dnd.h"

extern config *conf;

extern bk_edit_dialog_dnd dialog_dnd;


void bk_edit_dialog_dnd_show (void)
{
	if (dialog_dnd.dialog == NULL)
	{
		/* dialog window */
		dialog_dnd.dialog = gtk_window_new (GTK_WINDOW_DIALOG);
		gtk_window_set_title (GTK_WINDOW (dialog_dnd.dialog), "bk edit - url dropzone");
		gtk_window_set_policy (GTK_WINDOW (dialog_dnd.dialog), TRUE, TRUE, TRUE);
		if (config_dialog_options_url_dropzone_position_state_get (conf))
		{
			gtk_window_position (GTK_WINDOW (dialog_dnd.dialog), GTK_WIN_POS_NONE);
		}
		else
		{
			gtk_window_position (GTK_WINDOW (dialog_dnd.dialog), GTK_WIN_POS_MOUSE);
		}

		gtk_widget_set_usize (GTK_WIDGET (dialog_dnd.dialog), 230, -1);
		gtk_container_set_border_width (GTK_CONTAINER (dialog_dnd.dialog), 4);
		gtk_signal_connect_object (GTK_OBJECT (dialog_dnd.dialog), "delete_event",
			GTK_SIGNAL_FUNC (gtk_widget_hide_all), GTK_OBJECT (dialog_dnd.dialog));
		gtk_widget_realize (dialog_dnd.dialog);

		/* box */
		dialog_dnd.box = gtk_vbox_new (FALSE, 1);

		/* */
		dialog_dnd.dropzone = gtk_entry_new ();
		gtk_entry_set_editable (GTK_ENTRY (dialog_dnd.dropzone), FALSE);

		/* */
		bk_edit_dnd_add_drop_support (dialog_dnd.dropzone);

		/* pack */
		gtk_box_pack_start (GTK_BOX (dialog_dnd.box), dialog_dnd.dropzone, TRUE, TRUE, 0);
		gtk_container_add (GTK_CONTAINER (dialog_dnd.dialog), dialog_dnd.box);
	}

	/* */
	gtk_widget_show_all (dialog_dnd.dialog);

	/* */
	bk_edit_dialog_dnd_update ();

	/* raise */
	gdk_window_show (dialog_dnd.dialog->window);
}


void bk_edit_dialog_dnd_update (void)
{
	if (dialog_dnd.dialog)
	{
		if (config_dialog_options_url_dropzone_size_state_get (conf))
		{
			int width, height;

			config_dialog_options_url_dropzone_size_get (conf, &width, &height);
			gdk_window_resize (dialog_dnd.dialog->window, width, height);
		}

		if (config_dialog_options_url_dropzone_position_state_get (conf))
		{
			int x, y;

			config_dialog_options_url_dropzone_position_get (conf, &x, &y);
			gtk_window_reposition (GTK_WINDOW (dialog_dnd.dialog), x, y);
			gtk_window_position (GTK_WINDOW (dialog_dnd.dialog), GTK_WIN_POS_NONE);
		}
		else
		{
			gtk_window_position (GTK_WINDOW (dialog_dnd.dialog), GTK_WIN_POS_MOUSE);
		}

		dialog_options_sticky_set (dialog_dnd.dialog, config_dialog_options_url_dropzone_sticky_get (conf));
		dialog_options_always_on_top_set (dialog_dnd.dialog, config_dialog_options_url_dropzone_always_on_top_get (conf));
	}
}

