/*
 * Copyright (C) 2002 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_dialog_box.c - 08.03.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <gtk/gtk.h>


void bk_edit_dialog_box (gchar *title, gchar *text, gchar *icon[], void (*ok_func)(GtkWidget *, void *), void (*cancel_func)(GtkWidget *, void *), void *data)
{
	GtkWidget *dialog, *dialog_vbox, *separator;
	GtkWidget *info_label, *info_box;
	GtkWidget *ok, *cancel;
	GtkWidget *box;

	GtkWidget *icon_wid;
	GdkPixmap *icon_pix;
	GdkBitmap *icon_mask;

	/* dialog */
	dialog = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_window_set_title (GTK_WINDOW (dialog), title);
	gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
	gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, FALSE, TRUE);
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 4);
	gtk_signal_connect_object (GTK_OBJECT (dialog), "delete_event",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));
	gtk_widget_realize (dialog);

	/* dialog vbox */
	dialog_vbox = gtk_vbox_new (FALSE, 1);

	/* info box */
	info_box = gtk_hbox_new (FALSE, 1);

	/* info label */
	info_label = gtk_label_new (text);
	gtk_label_set_justify (GTK_LABEL (info_label), GTK_JUSTIFY_LEFT);

	/* separator */
	separator = gtk_hseparator_new ();

	/* ok */
	ok = gtk_button_new_with_label ("Ok");
	GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
	if (ok_func != NULL)
	{
		gtk_signal_connect (GTK_OBJECT (ok), "clicked", GTK_SIGNAL_FUNC (ok_func), (gpointer) data);
	}
	gtk_signal_connect_object (GTK_OBJECT (ok), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));

	/* cancel */
	cancel = gtk_button_new_with_label ("Cancel");
	GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
	if (cancel_func != NULL)
	{
		gtk_signal_connect (GTK_OBJECT (cancel), "clicked", GTK_SIGNAL_FUNC (cancel_func), (gpointer *) data);
	}
	gtk_signal_connect_object (GTK_OBJECT (cancel), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));

	/* box */
	box = gtk_hbutton_box_new ();

	/* icon */
	icon_pix = gdk_pixmap_create_from_xpm_d (dialog->window, &icon_mask, NULL, (gchar **) icon);
	icon_wid = gtk_pixmap_new (icon_pix, icon_mask);

	/* */
	gtk_box_pack_start (GTK_BOX (info_box), icon_wid, FALSE, FALSE, 1);
	gtk_box_pack_start (GTK_BOX (info_box), info_label, TRUE, FALSE, 10);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), info_box, FALSE, FALSE, 1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), separator, FALSE, FALSE, 1);
	gtk_box_pack_start (GTK_BOX (box), ok, FALSE, FALSE, 1);
	gtk_box_pack_start (GTK_BOX (box), cancel, FALSE, FALSE, 1);

	gtk_box_pack_start (GTK_BOX (dialog_vbox), box, FALSE, FALSE, 1);

	gtk_container_add (GTK_CONTAINER (dialog), dialog_vbox);

	/* */
	gtk_widget_grab_default (cancel);

	/* */
	gtk_widget_show_all (dialog);

	/* */
	gtk_widget_set_usize (GTK_WIDGET (dialog), -1, -1);
}

