/*
 * Copyright (C) 2002 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_date.c - 23.12.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <time.h>
#include <stdio.h>
#include <stdlib.h>

#include "bk_edit_date.h"


void bk_edit_date_create (bk_edit_date *date_dialog, gchar *title)
{
	GtkWidget *label;
	GtkObject *adjustment;

	gint width;

	/* tooltips */
	GtkTooltips *tooltip = gtk_tooltips_new ();

	date_dialog->box = gtk_hbox_new (FALSE, 1);
	date_dialog->label = gtk_label_new (title);
	gtk_misc_set_alignment(GTK_MISC (date_dialog->label), 0.0, 0.5);

	/* date */
	adjustment = gtk_adjustment_new (1, 1, 31, 1, 1, 0);
	date_dialog->day = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	gtk_box_pack_start (GTK_BOX (date_dialog->box), date_dialog->day, FALSE, FALSE, 1);
	width = gdk_text_width (date_dialog->day->style->font, "0", 1);
	gtk_widget_set_usize (GTK_WIDGET (date_dialog->day), width * 5, -1);

	label = gtk_label_new ("/");
	gtk_box_pack_start (GTK_BOX (date_dialog->box), label, FALSE, FALSE, 1);

	adjustment = gtk_adjustment_new (1, 1, 12, 1, 1, 0);
	date_dialog->month = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	gtk_box_pack_start (GTK_BOX (date_dialog->box), date_dialog->month, FALSE, FALSE, 1);
	width = gdk_text_width (date_dialog->month->style->font, "0", 1);
	gtk_widget_set_usize (GTK_WIDGET (date_dialog->month), width * 5, -1);

	label = gtk_label_new ("/");
	gtk_box_pack_start (GTK_BOX (date_dialog->box), label, FALSE, FALSE, 1);

	adjustment = gtk_adjustment_new (1970, 1970, 2030, 1, 1, 0);
	date_dialog->year = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	width = gdk_text_width (date_dialog->year->style->font, "M", 1);
	gtk_widget_set_usize (GTK_WIDGET (date_dialog->year), width * 5, -1);
	gtk_box_pack_start (GTK_BOX (date_dialog->box), date_dialog->year, FALSE, FALSE, 1);

	label = gtk_label_new (" - ");
	gtk_box_pack_start (GTK_BOX (date_dialog->box), label, FALSE, FALSE, 1);

	/* time */
	adjustment = gtk_adjustment_new (1, 1, 24, 1, 1, 0);
	date_dialog->hour = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	gtk_box_pack_start (GTK_BOX (date_dialog->box), date_dialog->hour, FALSE, FALSE, 1);
	width = gdk_text_width (date_dialog->hour->style->font, "0", 1);
	gtk_widget_set_usize (GTK_WIDGET (date_dialog->hour), width * 5, -1);

	label = gtk_label_new (":");
	gtk_box_pack_start (GTK_BOX (date_dialog->box), label, FALSE, FALSE, 1);

	adjustment = gtk_adjustment_new (1, 0, 59, 1, 1, 0);
	date_dialog->minute = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	gtk_box_pack_start (GTK_BOX (date_dialog->box), date_dialog->minute, FALSE, FALSE, 1);
	width = gdk_text_width (date_dialog->minute->style->font, "0", 1);
	gtk_widget_set_usize (GTK_WIDGET (date_dialog->minute), width * 5, -1);

	label = gtk_label_new (":");
	gtk_box_pack_start (GTK_BOX (date_dialog->box), label, FALSE, FALSE, 1);

	adjustment = gtk_adjustment_new (1, 0, 59, 1, 1, 0);
	date_dialog->second = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 0.5, 0);
	gtk_box_pack_start (GTK_BOX (date_dialog->box), date_dialog->second, FALSE, FALSE, 1);
	width = gdk_text_width (date_dialog->second->style->font, "0", 1);
	gtk_widget_set_usize (GTK_WIDGET (date_dialog->second), width * 5, -1);

	gtk_tooltips_set_tip (tooltip, date_dialog->day,    "day",     NULL);
	gtk_tooltips_set_tip (tooltip, date_dialog->month,  "month",   NULL);
	gtk_tooltips_set_tip (tooltip, date_dialog->year,   "year",    NULL);
	gtk_tooltips_set_tip (tooltip, date_dialog->hour,   "hours",   NULL);
	gtk_tooltips_set_tip (tooltip, date_dialog->minute, "minutes", NULL);
	gtk_tooltips_set_tip (tooltip, date_dialog->second, "seconds", NULL);
}


void bk_edit_date_fill (bk_edit_date *date_dialog, gchar *stamp)
{
	struct tm *date;
	time_t timestamp = atoi (stamp);

	date = localtime (&timestamp);

	gtk_spin_button_set_value (GTK_SPIN_BUTTON (date_dialog->day),   date->tm_mday);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (date_dialog->month), date->tm_mon + 1);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (date_dialog->year),  date->tm_year + 1900);

	gtk_spin_button_set_value (GTK_SPIN_BUTTON (date_dialog->hour),   date->tm_hour == 0 ? 24 : date->tm_hour);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (date_dialog->minute), date->tm_min);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (date_dialog->second), date->tm_sec);
}


char *bk_edit_date_get_timestamp (bk_edit_date *date_dialog)
{
	static char timestr[20];
	time_t timestamp;
	struct tm date;

	date.tm_mday = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (date_dialog->day));
	date.tm_mon  = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (date_dialog->month)) - 1;
	date.tm_year = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (date_dialog->year)) - 1900;

	date.tm_hour = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (date_dialog->hour)) == 24 ? 0 : gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (date_dialog->hour));
	date.tm_min  = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (date_dialog->minute));
	date.tm_sec  = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (date_dialog->second));

	if ((timestamp = mktime (&date)) < 0)
	{
		timestamp = 0;
	}

	snprintf (timestr, sizeof (timestr), "%ld", timestamp);

	return timestr;
}

