/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_ccp.c - 17.04.2003 - v0.2 - sort order
 *                 26.10.2001 - v0.1 - copy, cut & paste
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdlib.h>

#include <gtk/gtk.h>

#include "bk_edit.h"
#include "bk_edit_ccp.h"
#include "bk_edit_tree.h"
#include "bk_edit_icon.h"
#include "bk_edit_undo.h"
#include "bk_edit_sort.h"

#include "bk_edit_dialog_info.h"
#include "bk_edit_dialog_clipboard.h"

extern bk_edit_ccp ccp;
extern bk_edit_tree tree;

void bk_edit_ccp_cut (void)
{
	if (tree.selected_node != NULL)
	{
		GtkCTreeNode *node = tree.selected_node;
		GtkCTreeNode *parent = GTK_CTREE_ROW (node)->parent;

		if (ccp.ccp_node != NULL)
		{
			bk_edit_tree_destroy_gnode_tree (ccp.ccp_node);
			ccp.ccp_node = NULL;
		}

		/* undo */
		if (bk_edit_undo_add_cut_item (node) != BK_EDIT_UNDO_OK)
		{
			bk_edit_dialog_info ("bk edit - fatal error", "can't save undo status (bk_edit_undo_add_cut_item).", icon_warning);
			return;
		}

		ccp.ccp_node = gtk_ctree_export_to_gnode (GTK_CTREE (tree.tree), NULL, NULL, node, bk_edit_tree_to_gnode, NULL);

		gtk_ctree_remove_node (GTK_CTREE (tree.tree), node);

		tree.selected_node = NULL;

		/* clipboard */
		bk_edit_dialog_clipboard_update ();

		bk_edit_sort_reorder_folder (parent, NULL);
	}
}


void bk_edit_ccp_copy (void)
{
	if (tree.selected_node != NULL)
	{
		GtkCTreeNode *node = tree.selected_node;

		if (ccp.ccp_node != NULL)
		{
			bk_edit_tree_destroy_gnode_tree (ccp.ccp_node);
			ccp.ccp_node = NULL;
		}
		ccp.ccp_node = gtk_ctree_export_to_gnode (GTK_CTREE (tree.tree), NULL, NULL, node, bk_edit_tree_to_gnode, NULL);

		/* clipboard */
		bk_edit_dialog_clipboard_update ();
	}
}


void bk_edit_ccp_paste (void)
{
	if (tree.selected_node != NULL)
	{
		GtkCTreeNode *node;
		GtkCTreeNode *node_sibling = tree.selected_node;
		GtkCTreeNode *node_parent = GTK_CTREE_ROW (node_sibling)->parent;

		if (ccp.ccp_node == NULL) /* nothing to paste */
		{
			return;
		}

		if (node_parent == NULL)
		{
			node_parent = node_sibling;
			node_sibling = NULL;
		}

		g_node_traverse (ccp.ccp_node, G_IN_ORDER, G_TRAVERSE_ALL, -1, bk_edit_ccp_id_rewrite, NULL);
		node = gtk_ctree_insert_gnode (GTK_CTREE (tree.tree), node_parent, node_sibling, ccp.ccp_node, bk_edit_gnode_to_tree, NULL);

		/* undo */
		if (bk_edit_undo_add_paste_item (node, (bk_edit_tree_data *) GTK_CTREE_ROW (node)->row.data) != BK_EDIT_UNDO_OK)
		{
			bk_edit_dialog_info ("bk edit - fatal error", "can't save undo status (bk_edit_undo_add_paste_item).", icon_warning);
			return;
		}

		/*
		 * If the tree is unsorted, then we would just
		 * reorder all nodes in the current folder.
		 */
		if (bk_edit_sort_menu_state_is_unsorted () == OK)
		{
			GtkCTreeNode *parent = GTK_CTREE_ROW (node)->parent;
			if (parent == NULL)
			{
				fprintf (stderr, "%s[%d]: This should not happen!\n", __FILE__, __LINE__);
			}
			else
			{
				bk_edit_sort_reorder_folder (parent, NULL);
			}
		}
		else
		{
			/*
			 * If the tree is sorted in some way, we just set the
			 * order of the pasted node to the highest order in
			 * the current folder.
			 */
			GtkCTreeNode *parent = GTK_CTREE_ROW (node)->parent;
			if (parent == NULL)
			{
				fprintf (stderr, "%s[%d]: This should not happen!\n", __FILE__, __LINE__);
			}
			else
			{
				bk_edit_tree_data *node_data = (bk_edit_tree_data *) gtk_ctree_node_get_row_data (GTK_CTREE (tree.tree), node);
				node_data->order = bk_edit_sort_get_highest_order (parent, node);
			}
		}
	}
}


gboolean bk_edit_ccp_id_rewrite (GNode *node, gpointer data)
{
	((bk_edit_tree_data *) node->data)->id = tree.id++;

	return FALSE;
}

