/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit.c - 10.07.2003 - v0.14 - converting capability
 *             23.05.2003 - v0.13 - modify indicator rewrite
 *             11.04.2003 - v0.12 - sort order
 *             03.03.2003 - v0.11 - command line interface added
 *             15.02.2003 - v0.10 - preferences dialog and config file added
 *             12.02.2003 - v0.9 - find functionality
 *             11.02.2003 - v0.8 - modified menu shortcuts are now saved
 *             18.12.2002 - v0.7 - external drag and drop support
 *             26.02.2002 - v0.6 - plugin functionality
 *             26.10.2001 - v0.5 - copy, cut & paste functionality
 *             05.09.2001 - v0.4 - undo functionality
 *             16.08.2001 - v0.3 - first public release
 *             08.08.2001 - v0.2 - mozilla support
 *             24.07.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdlib.h>

#include "plugin.h"
#include "config.h"
#include "convert.h"
#include "command_line.h"

#include "bk_edit.h"
#include "bk_edit_ccp.h"
#include "bk_edit_tree.h"
#include "bk_edit_undo.h"
#include "bk_edit_icon.h"
#include "bk_edit_menu.h"
#include "bk_edit_file.h"
#include "bk_edit_sort.h"
#include "bk_edit_gtkrc.h"
#include "bk_edit_modify_indicator.h"

#include "bk_edit_dialog_box.h"
#include "bk_edit_dialog_dnd.h"
#include "bk_edit_dialog_main.h"
#include "bk_edit_dialog_undo.h"
#include "bk_edit_dialog_edit.h"
#include "bk_edit_dialog_info.h"
#include "bk_edit_dialog_find.h"
#include "bk_edit_dialog_config.h"
#include "bk_edit_dialog_plugin.h"
#include "bk_edit_dialog_clipboard.h"

config *conf;
plugins *plugs;

bk_edit_ccp ccp = { NULL };
bk_edit_tree tree = { NULL };
bk_edit_undo *undo;
bk_edit_modify_indicator *modify_indicator;

bk_edit_dialog_dnd dialog_dnd = { NULL };
bk_edit_dialog_main dialog_main = { NULL };
bk_edit_dialog_edit dialog_edit = { NULL };
bk_edit_dialog_undo dialog_undo = { NULL };
bk_edit_dialog_find dialog_find = { NULL };
bk_edit_dialog_config dialog_config = { NULL };
bk_edit_dialog_plugin dialog_plugin = { NULL };
bk_edit_dialog_clipboard dialog_clipboard = { NULL };


int main (int argc, char *argv[])
{
	command_line_options *options;

	gtk_rc_parse_string (gtkrc);

	gtk_init (&argc, &argv);

	/* plugins */
	plugs = plugin_new (plugs, BK_EDIT_PLUGIN_PATH);
	if (plugs == NULL)
	{
		fprintf (stderr, "%s[%d]: plugin_new\n", __FILE__, __LINE__);
		return EXIT_FAILURE;
	}

	/* command line interface */
	options = command_line_new (argc, argv);

	/* convert only? */
	if ((options->load != NULL) && (options->load_plugin != NULL) && (options->save != NULL) && (options->save_plugin != NULL))
	{
		if (convert_bookmarks (options) != OK)
		{
			return EXIT_FAILURE;
		}

		plugin_delete (plugs);
		command_line_delete (options);

		return EXIT_SUCCESS;
	}

	/* config */
	conf = config_new (NULL, BK_EDIT_RC);
	if (conf == NULL)
	{
		fprintf (stderr, "%s[%d]: config_new\n", __FILE__, __LINE__);
		return EXIT_FAILURE;
	}

	/* undo */
	undo = bk_edit_undo_new (undo);

	modify_indicator = bk_edit_modify_indicator_new (NULL, NULL);
	bk_edit_dialog_main_show ();
	modify_indicator->window = GTK_WINDOW (dialog_main.dialog);

	if ((options->load != NULL) && (options->load_plugin != NULL))
	{
		bk_edit_file_direct_open (options->load, options->load_plugin);
	}

	/* menu */
	bk_edit_menu_init ();
	bk_edit_sort_menu_update (config_sort_order_get (conf));

	/* */
	gtk_main ();
	gtk_clist_clear (GTK_CLIST (tree.tree));

	/* config */
	if (config_save (conf) == CONFIG_KO)
	{
		fprintf (stderr, "%s[%d]: config_save\n", __FILE__, __LINE__);
	}
	config_delete (conf);

	/* menu */
	bk_edit_menu_serialize ();

	/* plugins */
	plugin_delete (plugs);

	/* undo */
	bk_edit_undo_delete (undo);

	bk_edit_modify_indicator_delete (modify_indicator);

	command_line_delete (options);

	return EXIT_SUCCESS;
}


void bk_edit_quit (void)
{
	if (bk_edit_modify_indicator_is_modified (modify_indicator, CURRENT_UNDO_STACK_ENTRY) == IS_NOT_MODIFIED)
	{
		bk_edit_quit_ok (NULL, NULL);
	}
	else
	{
		bk_edit_dialog_box ("bk edit - warning", "This will discard all unsaved data.", icon_warning, bk_edit_quit_ok, NULL, NULL);
	}
}


void bk_edit_quit_ok (GtkWidget *widget, void *null)
{
	gtk_main_quit ();
}

