/*
 * Copyright (c) 2001 Tommy Bohlin <tommy@gatespace.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* mkobexdate.c
 *
 * 2do:
 *  Repeating events:
 *
 *  RRULE:D3 20000726T000000
 *  RRULE:W3 SU MO TU WE TH FR SA 20000928T000000
 *  RRULE:MD1 11 20000928T000000
 *  RRULE:MP1 2+ TU 20000928T000000
 *  RRULE:MD24 20000928T000000
 */

#include <obexformat.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#define MAXNAME                  24

static int ofs;
static int cr;
static int size;
static char* text;

static void addChar(int c)
{
  if(ofs>size-3) {
    size*=2;
    text=realloc(text,size);
  }
  if(c=='\n') {
    if(!cr) text[ofs++]='\r';
  } else {
    if(cr) text[ofs++]='\n';
  }
  text[ofs++]=c;
  cr= c=='\r';
}

static void addStr(const char* s)
{
  while(*s) addChar(*s++);
}

static void endInput(void)
{
  if(cr) text[ofs++]='\n';
}

int main(int argc, char** argv)
{
  int c,n;
  int usage=0;
  char* date=0;
  char* tim=0;
  char* name=0;
  char t1[7];
  char t2[7];
  char datebuf[9];
  time_t t;
  struct tm* lt;

  while((c=getopt(argc,argv,"d:t:n:h"))!=-1) {
    switch(c) {
    case 'd': date=optarg; break;
    case 't': tim=optarg; break;
    case 'n': name=optarg; break;
    case 'h': usage=1; break;
    case '?': usage=1; break;
    }
  }

  if(usage) {
    fprintf(stderr,"Format Palm Pilot date from stdin or command line\n");
    fprintf(stderr,"Usage: %s [-n name] [-d [[[cc]yy]mm]dd] [-t hh[mm]-hh[mm]] [text ...]\n",argv[0]);
    return 0;
  }

  n=date ? strlen(date) : 0;
  if(n>8 || (n&1)) {
    fprintf(stderr,"Bad date format\n");
    exit(-1);
  }

  time(&t);
  lt=localtime(&t);

  sprintf(datebuf,"%04d%02d%02d",lt->tm_year+1900,lt->tm_mon+1,lt->tm_mday);
  if(n>0) strcpy(datebuf+8-n,date);

  if(tim) {
    char* p=strchr(tim,'-');
    int n1=p-tim;
    int n2=strlen(p)-1;

    if((n1!=2 && n1!=4) || (n2!=2 && n2!=4)) {
      fprintf(stderr,"Bad time format\n");
      exit(-1);
    }

    memcpy(t1,tim,n1);
    if(n1==2) strcpy(t1+2,"0000");
    else strcpy(t1+4,"00");

    memcpy(t2,p+1,n2);
    if(n2==2) strcpy(t2+2,"0000");
    else strcpy(t2+4,"00");
  }

  size=1024;
  text=malloc(size);

  addStr("BEGIN:VCALENDAR\n");
  addStr("VERSION:1.0\nBEGIN:VEVENT\n");

  addStr("DTSTART:");
  addStr(datebuf);
  if(tim) {
    addChar('T');
    addStr(t1);
    addChar('\n');
    addStr("DTEND:");
    addStr(datebuf);
    addChar('T');
    addStr(t2);
  }
  addChar('\n');

  addStr("DESCRIPTION:");

  if(optind<argc) {
    while(optind<argc) {
      addStr(argv[optind++]);
      if(optind<argc) addChar(' ');
    }
  } else {
    while((c=getchar())!=EOF) addChar(c);
  }

  addStr("\nEND:VEVENT\nEND:VCALENDAR\n");

  endInput();

  if(name) {
    int nlen=strlen(name);
    if(nlen>MAXNAME) nlen=MAXNAME;
    putName(name,nlen);
  }

  putClass(0x64617465); /* 'date' */
  putEndOfBody(text,ofs);

  return 0;
}
