/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "vcf.h"


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of chrom member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->chrom[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the chrom array
 *      new_chrom_element The new value for chrom[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char            new_chrom_element;
 *
 *      if ( bl_vcf_set_chrom_ae(&bl_vcf, c, new_chrom_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_CHROM_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_chrom_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char new_chrom_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->chrom[c] = new_chrom_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for chrom member in a bl_vcf_t structure.
 *      Use this function to set chrom in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_chrom to bl_vcf_ptr->chrom.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_chrom       The new value for chrom
 *      array_size      Size of the chrom array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char            new_chrom;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_chrom_cpy(&bl_vcf, new_chrom, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_CHROM(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_chrom_cpy(bl_vcf_t *bl_vcf_ptr, char new_chrom[], size_t array_size)

{
    if ( new_chrom == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_vcf_ptr->chrom, new_chrom, array_size);
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of id member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->id[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the id array
 *      new_id_element  The new value for id[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char            new_id_element;
 *
 *      if ( bl_vcf_set_id_ae(&bl_vcf, c, new_id_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_ID_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_id_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char new_id_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->id[c] = new_id_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for id member in a bl_vcf_t structure.
 *      Use this function to set id in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_id to bl_vcf_ptr->id.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_id          The new value for id
 *      array_size      Size of the id array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char            new_id;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_id_cpy(&bl_vcf, new_id, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_ID(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_id_cpy(bl_vcf_t *bl_vcf_ptr, char new_id[], size_t array_size)

{
    if ( new_id == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_vcf_ptr->id, new_id, array_size);
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of ref member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->ref[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the ref array
 *      new_ref_element The new value for ref[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char            new_ref_element;
 *
 *      if ( bl_vcf_set_ref_ae(&bl_vcf, c, new_ref_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_REF_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_ref_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char new_ref_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->ref[c] = new_ref_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for ref member in a bl_vcf_t structure.
 *      Use this function to set ref in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_ref to bl_vcf_ptr->ref.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_ref         The new value for ref
 *      array_size      Size of the ref array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char            new_ref;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_ref_cpy(&bl_vcf, new_ref, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_REF(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_ref_cpy(bl_vcf_t *bl_vcf_ptr, char new_ref[], size_t array_size)

{
    if ( new_ref == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_vcf_ptr->ref, new_ref, array_size);
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of alt member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->alt[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the alt array
 *      new_alt_element The new value for alt[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char            new_alt_element;
 *
 *      if ( bl_vcf_set_alt_ae(&bl_vcf, c, new_alt_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_ALT_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_alt_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char new_alt_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->alt[c] = new_alt_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for alt member in a bl_vcf_t structure.
 *      Use this function to set alt in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_alt to bl_vcf_ptr->alt.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_alt         The new value for alt
 *      array_size      Size of the alt array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char            new_alt;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_alt_cpy(&bl_vcf, new_alt, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_ALT(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_alt_cpy(bl_vcf_t *bl_vcf_ptr, char new_alt[], size_t array_size)

{
    if ( new_alt == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_vcf_ptr->alt, new_alt, array_size);
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of qual member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->qual[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the qual array
 *      new_qual_element The new value for qual[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char            new_qual_element;
 *
 *      if ( bl_vcf_set_qual_ae(&bl_vcf, c, new_qual_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_QUAL_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_qual_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char new_qual_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->qual[c] = new_qual_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for qual member in a bl_vcf_t structure.
 *      Use this function to set qual in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_qual to bl_vcf_ptr->qual.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_qual        The new value for qual
 *      array_size      Size of the qual array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char            new_qual;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_qual_cpy(&bl_vcf, new_qual, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_QUAL(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_qual_cpy(bl_vcf_t *bl_vcf_ptr, char new_qual[], size_t array_size)

{
    if ( new_qual == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_vcf_ptr->qual, new_qual, array_size);
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of filter member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->filter[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the filter array
 *      new_filter_element The new value for filter[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char            new_filter_element;
 *
 *      if ( bl_vcf_set_filter_ae(&bl_vcf, c, new_filter_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_FILTER_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_filter_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char new_filter_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->filter[c] = new_filter_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for filter member in a bl_vcf_t structure.
 *      Use this function to set filter in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_filter to bl_vcf_ptr->filter.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_filter      The new value for filter
 *      array_size      Size of the filter array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char            new_filter;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_filter_cpy(&bl_vcf, new_filter, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_FILTER(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_filter_cpy(bl_vcf_t *bl_vcf_ptr, char new_filter[], size_t array_size)

{
    if ( new_filter == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_vcf_ptr->filter, new_filter, array_size);
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for info member in a bl_vcf_t structure.
 *      Use this function to set info in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      info is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_info        The new value for info
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char *          new_info;
 *
 *      if ( bl_vcf_set_info(&bl_vcf, new_info)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_info(bl_vcf_t *bl_vcf_ptr, char * new_info)

{
    if ( new_info == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->info = new_info;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of info member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->info[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the info array
 *      new_info_element The new value for info[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char *          new_info_element;
 *
 *      if ( bl_vcf_set_info_ae(&bl_vcf, c, new_info_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_INFO_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_info_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char  new_info_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->info[c] = new_info_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for info member in a bl_vcf_t structure.
 *      Use this function to set info in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_info to bl_vcf_ptr->info.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_info        The new value for info
 *      array_size      Size of the info array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char *          new_info;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_info_cpy(&bl_vcf, new_info, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_INFO(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_info_cpy(bl_vcf_t *bl_vcf_ptr, char * new_info, size_t array_size)

{
    if ( new_info == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_vcf_ptr->info, new_info, array_size);
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for format member in a bl_vcf_t structure.
 *      Use this function to set format in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      format is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_format      The new value for format
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char *          new_format;
 *
 *      if ( bl_vcf_set_format(&bl_vcf, new_format)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_format(bl_vcf_t *bl_vcf_ptr, char * new_format)

{
    if ( new_format == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->format = new_format;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of format member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->format[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the format array
 *      new_format_element The new value for format[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char *          new_format_element;
 *
 *      if ( bl_vcf_set_format_ae(&bl_vcf, c, new_format_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_FORMAT_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_format_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char  new_format_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->format[c] = new_format_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for format member in a bl_vcf_t structure.
 *      Use this function to set format in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_format to bl_vcf_ptr->format.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_format      The new value for format
 *      array_size      Size of the format array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char *          new_format;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_format_cpy(&bl_vcf, new_format, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_FORMAT(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_format_cpy(bl_vcf_t *bl_vcf_ptr, char * new_format, size_t array_size)

{
    if ( new_format == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_vcf_ptr->format, new_format, array_size);
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for single_sample member in a bl_vcf_t structure.
 *      Use this function to set single_sample in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      single_sample is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_single_sample The new value for single_sample
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char *          new_single_sample;
 *
 *      if ( bl_vcf_set_single_sample(&bl_vcf, new_single_sample)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_single_sample(bl_vcf_t *bl_vcf_ptr, char * new_single_sample)

{
    if ( new_single_sample == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->single_sample = new_single_sample;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of single_sample member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->single_sample[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the single_sample array
 *      new_single_sample_element The new value for single_sample[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char *          new_single_sample_element;
 *
 *      if ( bl_vcf_set_single_sample_ae(&bl_vcf, c, new_single_sample_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_SINGLE_SAMPLE_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_single_sample_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char  new_single_sample_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->single_sample[c] = new_single_sample_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for single_sample member in a bl_vcf_t structure.
 *      Use this function to set single_sample in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_single_sample to bl_vcf_ptr->single_sample.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_single_sample The new value for single_sample
 *      array_size      Size of the single_sample array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char *          new_single_sample;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_single_sample_cpy(&bl_vcf, new_single_sample, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_SINGLE_SAMPLE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_single_sample_cpy(bl_vcf_t *bl_vcf_ptr, char * new_single_sample, size_t array_size)

{
    if ( new_single_sample == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_vcf_ptr->single_sample, new_single_sample, array_size);
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for multi_samples member in a bl_vcf_t structure.
 *      Use this function to set multi_samples in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      multi_samples is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_multi_samples The new value for multi_samples
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char **         new_multi_samples;
 *
 *      if ( bl_vcf_set_multi_samples(&bl_vcf, new_multi_samples)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_samples(bl_vcf_t *bl_vcf_ptr, char ** new_multi_samples)

{
    if ( new_multi_samples == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->multi_samples = new_multi_samples;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of multi_samples member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->multi_samples[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the multi_samples array
 *      new_multi_samples_element The new value for multi_samples[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      char **         new_multi_samples_element;
 *
 *      if ( bl_vcf_set_multi_samples_ae(&bl_vcf, c, new_multi_samples_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_MULTI_SAMPLES_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_samples_ae(bl_vcf_t *bl_vcf_ptr, size_t c, char * new_multi_samples_element)

{
    if ( new_multi_samples_element == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->multi_samples[c] = new_multi_samples_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for multi_samples member in a bl_vcf_t structure.
 *      Use this function to set multi_samples in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_multi_samples to bl_vcf_ptr->multi_samples.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_multi_samples The new value for multi_samples
 *      array_size      Size of the multi_samples array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      char **         new_multi_samples;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_multi_samples_cpy(&bl_vcf, new_multi_samples, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_MULTI_SAMPLES(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_samples_cpy(bl_vcf_t *bl_vcf_ptr, char ** new_multi_samples, size_t array_size)

{
    if ( new_multi_samples == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_vcf_ptr->multi_samples[c] = new_multi_samples[c];
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for pos member in a bl_vcf_t structure.
 *      Use this function to set pos in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      pos is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_pos         The new value for pos
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      int64_t         new_pos;
 *
 *      if ( bl_vcf_set_pos(&bl_vcf, new_pos)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_pos(bl_vcf_t *bl_vcf_ptr, int64_t new_pos)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->pos = new_pos;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for info_array_size member in a bl_vcf_t structure.
 *      Use this function to set info_array_size in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      info_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_info_array_size The new value for info_array_size
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_info_array_size;
 *
 *      if ( bl_vcf_set_info_array_size(&bl_vcf, new_info_array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_info_array_size(bl_vcf_t *bl_vcf_ptr, size_t new_info_array_size)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->info_array_size = new_info_array_size;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for info_len member in a bl_vcf_t structure.
 *      Use this function to set info_len in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      info_len is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_info_len    The new value for info_len
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_info_len;
 *
 *      if ( bl_vcf_set_info_len(&bl_vcf, new_info_len)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_info_len(bl_vcf_t *bl_vcf_ptr, size_t new_info_len)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->info_len = new_info_len;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for format_array_size member in a bl_vcf_t structure.
 *      Use this function to set format_array_size in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      format_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_format_array_size The new value for format_array_size
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_format_array_size;
 *
 *      if ( bl_vcf_set_format_array_size(&bl_vcf, new_format_array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_format_array_size(bl_vcf_t *bl_vcf_ptr, size_t new_format_array_size)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->format_array_size = new_format_array_size;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for format_len member in a bl_vcf_t structure.
 *      Use this function to set format_len in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      format_len is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_format_len  The new value for format_len
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_format_len;
 *
 *      if ( bl_vcf_set_format_len(&bl_vcf, new_format_len)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_format_len(bl_vcf_t *bl_vcf_ptr, size_t new_format_len)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->format_len = new_format_len;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for single_sample_array_size member in a bl_vcf_t structure.
 *      Use this function to set single_sample_array_size in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      single_sample_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_single_sample_array_size The new value for single_sample_array_size
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_single_sample_array_size;
 *
 *      if ( bl_vcf_set_single_sample_array_size(&bl_vcf, new_single_sample_array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_single_sample_array_size(bl_vcf_t *bl_vcf_ptr, size_t new_single_sample_array_size)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->single_sample_array_size = new_single_sample_array_size;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for single_sample_len member in a bl_vcf_t structure.
 *      Use this function to set single_sample_len in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      single_sample_len is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_single_sample_len The new value for single_sample_len
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_single_sample_len;
 *
 *      if ( bl_vcf_set_single_sample_len(&bl_vcf, new_single_sample_len)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_single_sample_len(bl_vcf_t *bl_vcf_ptr, size_t new_single_sample_len)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->single_sample_len = new_single_sample_len;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for multi_sample_pointer_array_size member in a bl_vcf_t structure.
 *      Use this function to set multi_sample_pointer_array_size in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      multi_sample_pointer_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_multi_sample_pointer_array_size The new value for multi_sample_pointer_array_size
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_multi_sample_pointer_array_size;
 *
 *      if ( bl_vcf_set_multi_sample_pointer_array_size(&bl_vcf, new_multi_sample_pointer_array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_sample_pointer_array_size(bl_vcf_t *bl_vcf_ptr, size_t new_multi_sample_pointer_array_size)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->multi_sample_pointer_array_size = new_multi_sample_pointer_array_size;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for multi_sample_count member in a bl_vcf_t structure.
 *      Use this function to set multi_sample_count in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      multi_sample_count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_multi_sample_count The new value for multi_sample_count
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_multi_sample_count;
 *
 *      if ( bl_vcf_set_multi_sample_count(&bl_vcf, new_multi_sample_count)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_sample_count(bl_vcf_t *bl_vcf_ptr, size_t new_multi_sample_count)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->multi_sample_count = new_multi_sample_count;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for multi_sample_array_sizes member in a bl_vcf_t structure.
 *      Use this function to set multi_sample_array_sizes in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      multi_sample_array_sizes is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_multi_sample_array_sizes The new value for multi_sample_array_sizes
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t *        new_multi_sample_array_sizes;
 *
 *      if ( bl_vcf_set_multi_sample_array_sizes(&bl_vcf, new_multi_sample_array_sizes)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_sample_array_sizes(bl_vcf_t *bl_vcf_ptr, size_t * new_multi_sample_array_sizes)

{
    if ( new_multi_sample_array_sizes == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->multi_sample_array_sizes = new_multi_sample_array_sizes;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of multi_sample_array_sizes member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->multi_sample_array_sizes[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the multi_sample_array_sizes array
 *      new_multi_sample_array_sizes_element The new value for multi_sample_array_sizes[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      size_t *        new_multi_sample_array_sizes_element;
 *
 *      if ( bl_vcf_set_multi_sample_array_sizes_ae(&bl_vcf, c, new_multi_sample_array_sizes_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_MULTI_SAMPLE_ARRAY_SIZES_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_sample_array_sizes_ae(bl_vcf_t *bl_vcf_ptr, size_t c, size_t  new_multi_sample_array_sizes_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->multi_sample_array_sizes[c] = new_multi_sample_array_sizes_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for multi_sample_array_sizes member in a bl_vcf_t structure.
 *      Use this function to set multi_sample_array_sizes in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_multi_sample_array_sizes to bl_vcf_ptr->multi_sample_array_sizes.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_multi_sample_array_sizes The new value for multi_sample_array_sizes
 *      array_size      Size of the multi_sample_array_sizes array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t *        new_multi_sample_array_sizes;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_multi_sample_array_sizes_cpy(&bl_vcf, new_multi_sample_array_sizes, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_MULTI_SAMPLE_ARRAY_SIZES(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_sample_array_sizes_cpy(bl_vcf_t *bl_vcf_ptr, size_t * new_multi_sample_array_sizes, size_t array_size)

{
    if ( new_multi_sample_array_sizes == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_vcf_ptr->multi_sample_array_sizes[c] = new_multi_sample_array_sizes[c];
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for multi_sample_lens member in a bl_vcf_t structure.
 *      Use this function to set multi_sample_lens in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      multi_sample_lens is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_multi_sample_lens The new value for multi_sample_lens
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t *        new_multi_sample_lens;
 *
 *      if ( bl_vcf_set_multi_sample_lens(&bl_vcf, new_multi_sample_lens)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_sample_lens(bl_vcf_t *bl_vcf_ptr, size_t * new_multi_sample_lens)

{
    if ( new_multi_sample_lens == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->multi_sample_lens = new_multi_sample_lens;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of multi_sample_lens member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->multi_sample_lens[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the multi_sample_lens array
 *      new_multi_sample_lens_element The new value for multi_sample_lens[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      size_t *        new_multi_sample_lens_element;
 *
 *      if ( bl_vcf_set_multi_sample_lens_ae(&bl_vcf, c, new_multi_sample_lens_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_MULTI_SAMPLE_LENS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_sample_lens_ae(bl_vcf_t *bl_vcf_ptr, size_t c, size_t  new_multi_sample_lens_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->multi_sample_lens[c] = new_multi_sample_lens_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for multi_sample_lens member in a bl_vcf_t structure.
 *      Use this function to set multi_sample_lens in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_multi_sample_lens to bl_vcf_ptr->multi_sample_lens.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_multi_sample_lens The new value for multi_sample_lens
 *      array_size      Size of the multi_sample_lens array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t *        new_multi_sample_lens;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_multi_sample_lens_cpy(&bl_vcf, new_multi_sample_lens, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_MULTI_SAMPLE_LENS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_multi_sample_lens_cpy(bl_vcf_t *bl_vcf_ptr, size_t * new_multi_sample_lens, size_t array_size)

{
    if ( new_multi_sample_lens == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_vcf_ptr->multi_sample_lens[c] = new_multi_sample_lens[c];
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for ref_count member in a bl_vcf_t structure.
 *      Use this function to set ref_count in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      ref_count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_ref_count   The new value for ref_count
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      unsigned        new_ref_count;
 *
 *      if ( bl_vcf_set_ref_count(&bl_vcf, new_ref_count)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_ref_count(bl_vcf_t *bl_vcf_ptr, unsigned new_ref_count)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->ref_count = new_ref_count;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for alt_count member in a bl_vcf_t structure.
 *      Use this function to set alt_count in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      alt_count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_alt_count   The new value for alt_count
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      unsigned        new_alt_count;
 *
 *      if ( bl_vcf_set_alt_count(&bl_vcf, new_alt_count)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_alt_count(bl_vcf_t *bl_vcf_ptr, unsigned new_alt_count)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->alt_count = new_alt_count;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for other_count member in a bl_vcf_t structure.
 *      Use this function to set other_count in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      other_count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_other_count The new value for other_count
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      unsigned        new_other_count;
 *
 *      if ( bl_vcf_set_other_count(&bl_vcf, new_other_count)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_other_count(bl_vcf_t *bl_vcf_ptr, unsigned new_other_count)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->other_count = new_other_count;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for phreds member in a bl_vcf_t structure.
 *      Use this function to set phreds in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      phreds is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_phreds      The new value for phreds
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      unsigned char * new_phreds;
 *
 *      if ( bl_vcf_set_phreds(&bl_vcf, new_phreds)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_phreds(bl_vcf_t *bl_vcf_ptr, unsigned char * new_phreds)

{
    if ( new_phreds == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->phreds = new_phreds;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of phreds member in a bl_vcf_t
 *      structure. Use this function to set bl_vcf_ptr->phreds[c]
 *      in a bl_vcf_t object from non-member functions.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      c               Subscript to the phreds array
 *      new_phreds_element The new value for phreds[c]
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          c;
 *      unsigned char * new_phreds_element;
 *
 *      if ( bl_vcf_set_phreds_ae(&bl_vcf, c, new_phreds_element)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_PHREDS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_phreds_ae(bl_vcf_t *bl_vcf_ptr, size_t c, unsigned char  new_phreds_element)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->phreds[c] = new_phreds_element;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for phreds member in a bl_vcf_t structure.
 *      Use this function to set phreds in a bl_vcf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_phreds to bl_vcf_ptr->phreds.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_phreds      The new value for phreds
 *      array_size      Size of the phreds array.
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      unsigned char * new_phreds;
 *      size_t          array_size;
 *
 *      if ( bl_vcf_set_phreds_cpy(&bl_vcf, new_phreds, array_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_VCF_SET_PHREDS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_phreds_cpy(bl_vcf_t *bl_vcf_ptr, unsigned char * new_phreds, size_t array_size)

{
    if ( new_phreds == NULL )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_vcf_ptr->phreds[c] = new_phreds[c];
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for phred_count member in a bl_vcf_t structure.
 *      Use this function to set phred_count in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      phred_count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_phred_count The new value for phred_count
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_phred_count;
 *
 *      if ( bl_vcf_set_phred_count(&bl_vcf, new_phred_count)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_phred_count(bl_vcf_t *bl_vcf_ptr, size_t new_phred_count)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->phred_count = new_phred_count;
	return BL_VCF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/vcf.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for phred_buff_size member in a bl_vcf_t structure.
 *      Use this function to set phred_buff_size in a bl_vcf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      phred_buff_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_vcf_ptr      Pointer to the structure to set
 *      new_phred_buff_size The new value for phred_buff_size
 *
 *  Returns:
 *      BL_VCF_DATA_OK if the new value is acceptable and assigned
 *      BL_VCF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_vcf_t        bl_vcf;
 *      size_t          new_phred_buff_size;
 *
 *      if ( bl_vcf_set_phred_buff_size(&bl_vcf, new_phred_buff_size)
 *              == BL_VCF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-24  gen-get-set Auto-generated from vcf.h
 ***************************************************************************/

int     bl_vcf_set_phred_buff_size(bl_vcf_t *bl_vcf_ptr, size_t new_phred_buff_size)

{
    if ( false )
	return BL_VCF_DATA_OUT_OF_RANGE;
    else
    {
	bl_vcf_ptr->phred_buff_size = new_phred_buff_size;
	return BL_VCF_DATA_OK;
    }
}
