/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "sam-buff.h"


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for buff_size member in a bl_sam_buff_t structure.
 *      Use this function to set buff_size in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      buff_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_buff_size   The new value for buff_size
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      size_t          new_buff_size;
 *
 *      if ( bl_sam_buff_set_buff_size(&bl_sam_buff, new_buff_size)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_buff_size(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    size_t new_buff_size
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->buff_size = new_buff_size;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for max_alignments member in a bl_sam_buff_t structure.
 *      Use this function to set max_alignments in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      max_alignments is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_max_alignments The new value for max_alignments
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      size_t          new_max_alignments;
 *
 *      if ( bl_sam_buff_set_max_alignments(&bl_sam_buff, new_max_alignments)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_max_alignments(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    size_t new_max_alignments
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->max_alignments = new_max_alignments;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for alignments member in a bl_sam_buff_t structure.
 *      Use this function to set alignments in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      alignments is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_alignments  The new value for alignments
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      bl_sam_t **     new_alignments;
 *
 *      if ( bl_sam_buff_set_alignments(&bl_sam_buff, new_alignments)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_alignments(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    bl_sam_t ** new_alignments
	)

{
    if ( new_alignments == NULL )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->alignments = new_alignments;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of alignments member in a bl_sam_buff_t
 *      structure. Use this function to set bl_sam_buff_ptr->alignments[c]
 *      in a bl_sam_buff_t object from non-member functions.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      c               Subscript to the alignments array
 *      new_alignments_element The new value for alignments[c]
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      size_t          c;
 *      bl_sam_t **     new_alignments_element;
 *
 *      if ( bl_sam_buff_set_alignments_ae(&bl_sam_buff, c, new_alignments_element)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_SAM_BUFF_SET_ALIGNMENTS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_alignments_ae(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    size_t c,
	    bl_sam_t * new_alignments_element
	)

{
    if ( new_alignments_element == NULL )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->alignments[c] = new_alignments_element;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for alignments member in a bl_sam_buff_t structure.
 *      Use this function to set alignments in a bl_sam_buff_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_alignments to bl_sam_buff_ptr->alignments.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_alignments  The new value for alignments
 *      array_size      Size of the alignments array.
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      bl_sam_t **     new_alignments;
 *      size_t          array_size;
 *
 *      if ( bl_sam_buff_set_alignments_cpy(&bl_sam_buff, new_alignments, array_size)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_SAM_BUFF_SET_ALIGNMENTS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_alignments_cpy(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    bl_sam_t ** new_alignments,
	    size_t array_size
	)

{
    if ( new_alignments == NULL )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_sam_buff_ptr->alignments[c] = new_alignments[c];
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for buffered_count member in a bl_sam_buff_t structure.
 *      Use this function to set buffered_count in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      buffered_count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_buffered_count The new value for buffered_count
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      size_t          new_buffered_count;
 *
 *      if ( bl_sam_buff_set_buffered_count(&bl_sam_buff, new_buffered_count)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_buffered_count(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    size_t new_buffered_count
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->buffered_count = new_buffered_count;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for max_count member in a bl_sam_buff_t structure.
 *      Use this function to set max_count in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      max_count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_max_count   The new value for max_count
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      size_t          new_max_count;
 *
 *      if ( bl_sam_buff_set_max_count(&bl_sam_buff, new_max_count)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_max_count(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    size_t new_max_count
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->max_count = new_max_count;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for previous_pos member in a bl_sam_buff_t structure.
 *      Use this function to set previous_pos in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      previous_pos is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_previous_pos The new value for previous_pos
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_previous_pos;
 *
 *      if ( bl_sam_buff_set_previous_pos(&bl_sam_buff, new_previous_pos)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_previous_pos(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_previous_pos
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->previous_pos = new_previous_pos;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of previous_rname member in a bl_sam_buff_t
 *      structure. Use this function to set bl_sam_buff_ptr->previous_rname[c]
 *      in a bl_sam_buff_t object from non-member functions.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      c               Subscript to the previous_rname array
 *      new_previous_rname_element The new value for previous_rname[c]
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      size_t          c;
 *      char            new_previous_rname_element;
 *
 *      if ( bl_sam_buff_set_previous_rname_ae(&bl_sam_buff, c, new_previous_rname_element)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_SAM_BUFF_SET_PREVIOUS_RNAME_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_previous_rname_ae(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    size_t c,
	    char new_previous_rname_element
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->previous_rname[c] = new_previous_rname_element;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for previous_rname member in a bl_sam_buff_t structure.
 *      Use this function to set previous_rname in a bl_sam_buff_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_previous_rname to bl_sam_buff_ptr->previous_rname.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_previous_rname The new value for previous_rname
 *      array_size      Size of the previous_rname array.
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      char            new_previous_rname;
 *      size_t          array_size;
 *
 *      if ( bl_sam_buff_set_previous_rname_cpy(&bl_sam_buff, new_previous_rname, array_size)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_SAM_BUFF_SET_PREVIOUS_RNAME(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_previous_rname_cpy(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    char new_previous_rname[],
	    size_t array_size
	)

{
    if ( new_previous_rname == NULL )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_sam_buff_ptr->previous_rname, new_previous_rname, array_size);
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for mapq_min member in a bl_sam_buff_t structure.
 *      Use this function to set mapq_min in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      mapq_min is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_mapq_min    The new value for mapq_min
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_mapq_min;
 *
 *      if ( bl_sam_buff_set_mapq_min(&bl_sam_buff, new_mapq_min)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_mapq_min(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_mapq_min
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->mapq_min = new_mapq_min;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for mapq_low member in a bl_sam_buff_t structure.
 *      Use this function to set mapq_low in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      mapq_low is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_mapq_low    The new value for mapq_low
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_mapq_low;
 *
 *      if ( bl_sam_buff_set_mapq_low(&bl_sam_buff, new_mapq_low)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_mapq_low(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_mapq_low
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->mapq_low = new_mapq_low;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for mapq_high member in a bl_sam_buff_t structure.
 *      Use this function to set mapq_high in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      mapq_high is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_mapq_high   The new value for mapq_high
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_mapq_high;
 *
 *      if ( bl_sam_buff_set_mapq_high(&bl_sam_buff, new_mapq_high)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_mapq_high(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_mapq_high
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->mapq_high = new_mapq_high;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for mapq_sum member in a bl_sam_buff_t structure.
 *      Use this function to set mapq_sum in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      mapq_sum is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_mapq_sum    The new value for mapq_sum
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_mapq_sum;
 *
 *      if ( bl_sam_buff_set_mapq_sum(&bl_sam_buff, new_mapq_sum)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_mapq_sum(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_mapq_sum
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->mapq_sum = new_mapq_sum;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for reads_used member in a bl_sam_buff_t structure.
 *      Use this function to set reads_used in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      reads_used is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_reads_used  The new value for reads_used
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_reads_used;
 *
 *      if ( bl_sam_buff_set_reads_used(&bl_sam_buff, new_reads_used)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_reads_used(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_reads_used
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->reads_used = new_reads_used;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for total_alignments member in a bl_sam_buff_t structure.
 *      Use this function to set total_alignments in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      total_alignments is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_total_alignments The new value for total_alignments
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_total_alignments;
 *
 *      if ( bl_sam_buff_set_total_alignments(&bl_sam_buff, new_total_alignments)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_total_alignments(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_total_alignments
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->total_alignments = new_total_alignments;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for trailing_alignments member in a bl_sam_buff_t structure.
 *      Use this function to set trailing_alignments in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      trailing_alignments is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_trailing_alignments The new value for trailing_alignments
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_trailing_alignments;
 *
 *      if ( bl_sam_buff_set_trailing_alignments(&bl_sam_buff, new_trailing_alignments)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_trailing_alignments(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_trailing_alignments
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->trailing_alignments = new_trailing_alignments;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for discarded_alignments member in a bl_sam_buff_t structure.
 *      Use this function to set discarded_alignments in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      discarded_alignments is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_discarded_alignments The new value for discarded_alignments
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_discarded_alignments;
 *
 *      if ( bl_sam_buff_set_discarded_alignments(&bl_sam_buff, new_discarded_alignments)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_discarded_alignments(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_discarded_alignments
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->discarded_alignments = new_discarded_alignments;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for discarded_score_sum member in a bl_sam_buff_t structure.
 *      Use this function to set discarded_score_sum in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      discarded_score_sum is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_discarded_score_sum The new value for discarded_score_sum
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_discarded_score_sum;
 *
 *      if ( bl_sam_buff_set_discarded_score_sum(&bl_sam_buff, new_discarded_score_sum)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_discarded_score_sum(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_discarded_score_sum
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->discarded_score_sum = new_discarded_score_sum;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for discarded_trailing member in a bl_sam_buff_t structure.
 *      Use this function to set discarded_trailing in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      discarded_trailing is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_discarded_trailing The new value for discarded_trailing
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_discarded_trailing;
 *
 *      if ( bl_sam_buff_set_discarded_trailing(&bl_sam_buff, new_discarded_trailing)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_discarded_trailing(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_discarded_trailing
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->discarded_trailing = new_discarded_trailing;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for min_discarded_score member in a bl_sam_buff_t structure.
 *      Use this function to set min_discarded_score in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      min_discarded_score is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_min_discarded_score The new value for min_discarded_score
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_min_discarded_score;
 *
 *      if ( bl_sam_buff_set_min_discarded_score(&bl_sam_buff, new_min_discarded_score)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_min_discarded_score(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_min_discarded_score
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->min_discarded_score = new_min_discarded_score;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for max_discarded_score member in a bl_sam_buff_t structure.
 *      Use this function to set max_discarded_score in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      max_discarded_score is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_max_discarded_score The new value for max_discarded_score
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_max_discarded_score;
 *
 *      if ( bl_sam_buff_set_max_discarded_score(&bl_sam_buff, new_max_discarded_score)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_max_discarded_score(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_max_discarded_score
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->max_discarded_score = new_max_discarded_score;
	return BL_SAM_BUFF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/sam-buff.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for unmapped_alignments member in a bl_sam_buff_t structure.
 *      Use this function to set unmapped_alignments in a bl_sam_buff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      unmapped_alignments is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_sam_buff_ptr Pointer to the structure to set
 *      new_unmapped_alignments The new value for unmapped_alignments
 *
 *  Returns:
 *      BL_SAM_BUFF_DATA_OK if the new value is acceptable and assigned
 *      BL_SAM_BUFF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_sam_buff_t   bl_sam_buff;
 *      int64_t        new_unmapped_alignments;
 *
 *      if ( bl_sam_buff_set_unmapped_alignments(&bl_sam_buff, new_unmapped_alignments)
 *              == BL_SAM_BUFF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from sam-buff.h
 ***************************************************************************/

int     bl_sam_buff_set_unmapped_alignments(
	    bl_sam_buff_t *bl_sam_buff_ptr,
	    int64_t new_unmapped_alignments
	)

{
    if ( false )
	return BL_SAM_BUFF_DATA_OUT_OF_RANGE;
    else
    {
	bl_sam_buff_ptr->unmapped_alignments = new_unmapped_alignments;
	return BL_SAM_BUFF_DATA_OK;
    }
}
