/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "pos-list.h"


/***************************************************************************
 *  Library:
 *      #include <biolibc/pos-list.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for array_size member in a bl_pos_list_t structure.
 *      Use this function to set array_size in a bl_pos_list_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_pos_list_ptr Pointer to the structure to set
 *      new_array_size  The new value for array_size
 *
 *  Returns:
 *      BL_POS_LIST_DATA_OK if the new value is acceptable and assigned
 *      BL_POS_LIST_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_pos_list_t   bl_pos_list;
 *      size_t          new_array_size;
 *
 *      if ( bl_pos_list_set_array_size(&bl_pos_list, new_array_size)
 *              == BL_POS_LIST_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from pos-list.h
 ***************************************************************************/

int     bl_pos_list_set_array_size(
	    bl_pos_list_t *bl_pos_list_ptr,
	    size_t new_array_size
	)

{
    if ( false )
	return BL_POS_LIST_DATA_OUT_OF_RANGE;
    else
    {
	bl_pos_list_ptr->array_size = new_array_size;
	return BL_POS_LIST_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/pos-list.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for count member in a bl_pos_list_t structure.
 *      Use this function to set count in a bl_pos_list_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_pos_list_ptr Pointer to the structure to set
 *      new_count       The new value for count
 *
 *  Returns:
 *      BL_POS_LIST_DATA_OK if the new value is acceptable and assigned
 *      BL_POS_LIST_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_pos_list_t   bl_pos_list;
 *      size_t          new_count;
 *
 *      if ( bl_pos_list_set_count(&bl_pos_list, new_count)
 *              == BL_POS_LIST_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from pos-list.h
 ***************************************************************************/

int     bl_pos_list_set_count(
	    bl_pos_list_t *bl_pos_list_ptr,
	    size_t new_count
	)

{
    if ( false )
	return BL_POS_LIST_DATA_OUT_OF_RANGE;
    else
    {
	bl_pos_list_ptr->count = new_count;
	return BL_POS_LIST_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/pos-list.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for positions member in a bl_pos_list_t structure.
 *      Use this function to set positions in a bl_pos_list_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      positions is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_pos_list_ptr Pointer to the structure to set
 *      new_positions   The new value for positions
 *
 *  Returns:
 *      BL_POS_LIST_DATA_OK if the new value is acceptable and assigned
 *      BL_POS_LIST_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_pos_list_t   bl_pos_list;
 *      int64_t *      new_positions;
 *
 *      if ( bl_pos_list_set_positions(&bl_pos_list, new_positions)
 *              == BL_POS_LIST_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from pos-list.h
 ***************************************************************************/

int     bl_pos_list_set_positions(
	    bl_pos_list_t *bl_pos_list_ptr,
	    int64_t * new_positions
	)

{
    if ( new_positions == NULL )
	return BL_POS_LIST_DATA_OUT_OF_RANGE;
    else
    {
	bl_pos_list_ptr->positions = new_positions;
	return BL_POS_LIST_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/pos-list.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of positions member in a bl_pos_list_t
 *      structure. Use this function to set bl_pos_list_ptr->positions[c]
 *      in a bl_pos_list_t object from non-member functions.
 *
 *  Arguments:
 *      bl_pos_list_ptr Pointer to the structure to set
 *      c               Subscript to the positions array
 *      new_positions_element The new value for positions[c]
 *
 *  Returns:
 *      BL_POS_LIST_DATA_OK if the new value is acceptable and assigned
 *      BL_POS_LIST_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_pos_list_t   bl_pos_list;
 *      size_t          c;
 *      int64_t *      new_positions_element;
 *
 *      if ( bl_pos_list_set_positions_ae(&bl_pos_list, c, new_positions_element)
 *              == BL_POS_LIST_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_POS_LIST_SET_POSITIONS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from pos-list.h
 ***************************************************************************/

int     bl_pos_list_set_positions_ae(
	    bl_pos_list_t *bl_pos_list_ptr,
	    size_t c,
	    int64_t  new_positions_element
	)

{
    if ( false )
	return BL_POS_LIST_DATA_OUT_OF_RANGE;
    else
    {
	bl_pos_list_ptr->positions[c] = new_positions_element;
	return BL_POS_LIST_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/pos-list.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for positions member in a bl_pos_list_t structure.
 *      Use this function to set positions in a bl_pos_list_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_positions to bl_pos_list_ptr->positions.
 *
 *  Arguments:
 *      bl_pos_list_ptr Pointer to the structure to set
 *      new_positions   The new value for positions
 *      array_size      Size of the positions array.
 *
 *  Returns:
 *      BL_POS_LIST_DATA_OK if the new value is acceptable and assigned
 *      BL_POS_LIST_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_pos_list_t   bl_pos_list;
 *      int64_t *      new_positions;
 *      size_t          array_size;
 *
 *      if ( bl_pos_list_set_positions_cpy(&bl_pos_list, new_positions, array_size)
 *              == BL_POS_LIST_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_POS_LIST_SET_POSITIONS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from pos-list.h
 ***************************************************************************/

int     bl_pos_list_set_positions_cpy(
	    bl_pos_list_t *bl_pos_list_ptr,
	    int64_t * new_positions,
	    size_t array_size
	)

{
    if ( new_positions == NULL )
	return BL_POS_LIST_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_pos_list_ptr->positions[c] = new_positions[c];
	return BL_POS_LIST_DATA_OK;
    }
}
