/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "gff3-index.h"


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for array_size member in a bl_gff3_index_t structure.
 *      Use this function to set array_size in a bl_gff3_index_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_array_size  The new value for array_size
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      size_t          new_array_size;
 *
 *      if ( bl_gff3_index_set_array_size(&bl_gff3_index, new_array_size)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_array_size(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    size_t new_array_size
	)

{
    if ( false )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->array_size = new_array_size;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for count member in a bl_gff3_index_t structure.
 *      Use this function to set count in a bl_gff3_index_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_count       The new value for count
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      size_t          new_count;
 *
 *      if ( bl_gff3_index_set_count(&bl_gff3_index, new_count)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_count(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    size_t new_count
	)

{
    if ( false )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->count = new_count;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for file_pos member in a bl_gff3_index_t structure.
 *      Use this function to set file_pos in a bl_gff3_index_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      file_pos is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_file_pos    The new value for file_pos
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      long *          new_file_pos;
 *
 *      if ( bl_gff3_index_set_file_pos(&bl_gff3_index, new_file_pos)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_file_pos(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    long * new_file_pos
	)

{
    if ( new_file_pos == NULL )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->file_pos = new_file_pos;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of file_pos member in a bl_gff3_index_t
 *      structure. Use this function to set bl_gff3_index_ptr->file_pos[c]
 *      in a bl_gff3_index_t object from non-member functions.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      c               Subscript to the file_pos array
 *      new_file_pos_element The new value for file_pos[c]
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      size_t          c;
 *      long *          new_file_pos_element;
 *
 *      if ( bl_gff3_index_set_file_pos_ae(&bl_gff3_index, c, new_file_pos_element)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_GFF3_INDEX_SET_FILE_POS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_file_pos_ae(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    size_t c,
	    long  new_file_pos_element
	)

{
    if ( false )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->file_pos[c] = new_file_pos_element;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for file_pos member in a bl_gff3_index_t structure.
 *      Use this function to set file_pos in a bl_gff3_index_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_file_pos to bl_gff3_index_ptr->file_pos.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_file_pos    The new value for file_pos
 *      array_size      Size of the file_pos array.
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      long *          new_file_pos;
 *      size_t          array_size;
 *
 *      if ( bl_gff3_index_set_file_pos_cpy(&bl_gff3_index, new_file_pos, array_size)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_GFF3_INDEX_SET_FILE_POS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_file_pos_cpy(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    long * new_file_pos,
	    size_t array_size
	)

{
    if ( new_file_pos == NULL )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_gff3_index_ptr->file_pos[c] = new_file_pos[c];
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seqid member in a bl_gff3_index_t structure.
 *      Use this function to set seqid in a bl_gff3_index_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      seqid is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_seqid       The new value for seqid
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      char **         new_seqid;
 *
 *      if ( bl_gff3_index_set_seqid(&bl_gff3_index, new_seqid)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_seqid(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    char ** new_seqid
	)

{
    if ( new_seqid == NULL )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->seqid = new_seqid;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of seqid member in a bl_gff3_index_t
 *      structure. Use this function to set bl_gff3_index_ptr->seqid[c]
 *      in a bl_gff3_index_t object from non-member functions.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      c               Subscript to the seqid array
 *      new_seqid_element The new value for seqid[c]
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      size_t          c;
 *      char **         new_seqid_element;
 *
 *      if ( bl_gff3_index_set_seqid_ae(&bl_gff3_index, c, new_seqid_element)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_GFF3_INDEX_SET_SEQID_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_seqid_ae(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    size_t c,
	    char * new_seqid_element
	)

{
    if ( new_seqid_element == NULL )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->seqid[c] = new_seqid_element;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seqid member in a bl_gff3_index_t structure.
 *      Use this function to set seqid in a bl_gff3_index_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_seqid to bl_gff3_index_ptr->seqid.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_seqid       The new value for seqid
 *      array_size      Size of the seqid array.
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      char **         new_seqid;
 *      size_t          array_size;
 *
 *      if ( bl_gff3_index_set_seqid_cpy(&bl_gff3_index, new_seqid, array_size)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_GFF3_INDEX_SET_SEQID(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_seqid_cpy(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    char ** new_seqid,
	    size_t array_size
	)

{
    if ( new_seqid == NULL )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_gff3_index_ptr->seqid[c] = new_seqid[c];
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for start member in a bl_gff3_index_t structure.
 *      Use this function to set start in a bl_gff3_index_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      start is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_start       The new value for start
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      int64_t *      new_start;
 *
 *      if ( bl_gff3_index_set_start(&bl_gff3_index, new_start)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_start(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    int64_t * new_start
	)

{
    if ( new_start == NULL )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->start = new_start;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of start member in a bl_gff3_index_t
 *      structure. Use this function to set bl_gff3_index_ptr->start[c]
 *      in a bl_gff3_index_t object from non-member functions.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      c               Subscript to the start array
 *      new_start_element The new value for start[c]
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      size_t          c;
 *      int64_t *      new_start_element;
 *
 *      if ( bl_gff3_index_set_start_ae(&bl_gff3_index, c, new_start_element)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_GFF3_INDEX_SET_START_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_start_ae(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    size_t c,
	    int64_t  new_start_element
	)

{
    if ( false )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->start[c] = new_start_element;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for start member in a bl_gff3_index_t structure.
 *      Use this function to set start in a bl_gff3_index_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_start to bl_gff3_index_ptr->start.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_start       The new value for start
 *      array_size      Size of the start array.
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      int64_t *      new_start;
 *      size_t          array_size;
 *
 *      if ( bl_gff3_index_set_start_cpy(&bl_gff3_index, new_start, array_size)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_GFF3_INDEX_SET_START(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_start_cpy(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    int64_t * new_start,
	    size_t array_size
	)

{
    if ( new_start == NULL )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_gff3_index_ptr->start[c] = new_start[c];
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for end member in a bl_gff3_index_t structure.
 *      Use this function to set end in a bl_gff3_index_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      end is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_end         The new value for end
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      int64_t *      new_end;
 *
 *      if ( bl_gff3_index_set_end(&bl_gff3_index, new_end)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_end(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    int64_t * new_end
	)

{
    if ( new_end == NULL )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->end = new_end;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of end member in a bl_gff3_index_t
 *      structure. Use this function to set bl_gff3_index_ptr->end[c]
 *      in a bl_gff3_index_t object from non-member functions.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      c               Subscript to the end array
 *      new_end_element The new value for end[c]
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      size_t          c;
 *      int64_t *      new_end_element;
 *
 *      if ( bl_gff3_index_set_end_ae(&bl_gff3_index, c, new_end_element)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_GFF3_INDEX_SET_END_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_end_ae(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    size_t c,
	    int64_t  new_end_element
	)

{
    if ( false )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	bl_gff3_index_ptr->end[c] = new_end_element;
	return BL_GFF3_INDEX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/gff3-index.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for end member in a bl_gff3_index_t structure.
 *      Use this function to set end in a bl_gff3_index_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_end to bl_gff3_index_ptr->end.
 *
 *  Arguments:
 *      bl_gff3_index_ptr Pointer to the structure to set
 *      new_end         The new value for end
 *      array_size      Size of the end array.
 *
 *  Returns:
 *      BL_GFF3_INDEX_DATA_OK if the new value is acceptable and assigned
 *      BL_GFF3_INDEX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_gff3_index_t  bl_gff3_index;
 *      int64_t *      new_end;
 *      size_t          array_size;
 *
 *      if ( bl_gff3_index_set_end_cpy(&bl_gff3_index, new_end, array_size)
 *              == BL_GFF3_INDEX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_GFF3_INDEX_SET_END(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from gff3-index.h
 ***************************************************************************/

int     bl_gff3_index_set_end_cpy(
	    bl_gff3_index_t *bl_gff3_index_ptr,
	    int64_t * new_end,
	    size_t array_size
	)

{
    if ( new_end == NULL )
	return BL_GFF3_INDEX_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_gff3_index_ptr->end[c] = new_end[c];
	return BL_GFF3_INDEX_DATA_OK;
    }
}
