/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "fastx.h"


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastx.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for format member in a bl_fastx_t structure.
 *      Use this function to set format in a bl_fastx_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      format is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastx_ptr    Pointer to the structure to set
 *      new_format      The new value for format
 *
 *  Returns:
 *      BL_FASTX_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastx_t      bl_fastx;
 *      int             new_format;
 *
 *      if ( bl_fastx_set_format(&bl_fastx, new_format)
 *              == BL_FASTX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastx.h
 ***************************************************************************/

int     bl_fastx_set_format(
	    bl_fastx_t *bl_fastx_ptr,
	    int new_format
	)

{
    if ( false )
	return BL_FASTX_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastx_ptr->format = new_format;
	return BL_FASTX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastx.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for fasta member in a bl_fastx_t structure.
 *      Use this function to set fasta in a bl_fastx_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      fasta is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastx_ptr    Pointer to the structure to set
 *      new_fasta       The new value for fasta
 *
 *  Returns:
 *      BL_FASTX_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastx_t      bl_fastx;
 *      bl_fasta_t      new_fasta;
 *
 *      if ( bl_fastx_set_fasta(&bl_fastx, new_fasta)
 *              == BL_FASTX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastx.h
 ***************************************************************************/

int     bl_fastx_set_fasta(
	    bl_fastx_t *bl_fastx_ptr,
	    bl_fasta_t new_fasta
	)

{
    if ( false )
	return BL_FASTX_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastx_ptr->fasta = new_fasta;
	return BL_FASTX_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastx.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for fastq member in a bl_fastx_t structure.
 *      Use this function to set fastq in a bl_fastx_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      fastq is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastx_ptr    Pointer to the structure to set
 *      new_fastq       The new value for fastq
 *
 *  Returns:
 *      BL_FASTX_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTX_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastx_t      bl_fastx;
 *      bl_fastq_t      new_fastq;
 *
 *      if ( bl_fastx_set_fastq(&bl_fastx, new_fastq)
 *              == BL_FASTX_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastx.h
 ***************************************************************************/

int     bl_fastx_set_fastq(
	    bl_fastx_t *bl_fastx_ptr,
	    bl_fastq_t new_fastq
	)

{
    if ( false )
	return BL_FASTX_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastx_ptr->fastq = new_fastq;
	return BL_FASTX_DATA_OK;
    }
}
