/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "fastq.h"


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for desc member in a bl_fastq_t structure.
 *      Use this function to set desc in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      desc is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_desc        The new value for desc
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      char *          new_desc;
 *
 *      if ( bl_fastq_set_desc(&bl_fastq, new_desc)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_desc(
	    bl_fastq_t *bl_fastq_ptr,
	    char * new_desc
	)

{
    if ( new_desc == NULL )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->desc = new_desc;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of desc member in a bl_fastq_t
 *      structure. Use this function to set bl_fastq_ptr->desc[c]
 *      in a bl_fastq_t object from non-member functions.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      c               Subscript to the desc array
 *      new_desc_element The new value for desc[c]
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          c;
 *      char *          new_desc_element;
 *
 *      if ( bl_fastq_set_desc_ae(&bl_fastq, c, new_desc_element)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTQ_SET_DESC_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_desc_ae(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t c,
	    char  new_desc_element
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->desc[c] = new_desc_element;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for desc member in a bl_fastq_t structure.
 *      Use this function to set desc in a bl_fastq_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_desc to bl_fastq_ptr->desc.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_desc        The new value for desc
 *      array_size      Size of the desc array.
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      char *          new_desc;
 *      size_t          array_size;
 *
 *      if ( bl_fastq_set_desc_cpy(&bl_fastq, new_desc, array_size)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTQ_SET_DESC(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_desc_cpy(
	    bl_fastq_t *bl_fastq_ptr,
	    char * new_desc,
	    size_t array_size
	)

{
    if ( new_desc == NULL )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_fastq_ptr->desc, new_desc, array_size);
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seq member in a bl_fastq_t structure.
 *      Use this function to set seq in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      seq is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_seq         The new value for seq
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      char *          new_seq;
 *
 *      if ( bl_fastq_set_seq(&bl_fastq, new_seq)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_seq(
	    bl_fastq_t *bl_fastq_ptr,
	    char * new_seq
	)

{
    if ( new_seq == NULL )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->seq = new_seq;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of seq member in a bl_fastq_t
 *      structure. Use this function to set bl_fastq_ptr->seq[c]
 *      in a bl_fastq_t object from non-member functions.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      c               Subscript to the seq array
 *      new_seq_element The new value for seq[c]
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          c;
 *      char *          new_seq_element;
 *
 *      if ( bl_fastq_set_seq_ae(&bl_fastq, c, new_seq_element)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTQ_SET_SEQ_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_seq_ae(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t c,
	    char  new_seq_element
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->seq[c] = new_seq_element;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seq member in a bl_fastq_t structure.
 *      Use this function to set seq in a bl_fastq_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_seq to bl_fastq_ptr->seq.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_seq         The new value for seq
 *      array_size      Size of the seq array.
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      char *          new_seq;
 *      size_t          array_size;
 *
 *      if ( bl_fastq_set_seq_cpy(&bl_fastq, new_seq, array_size)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTQ_SET_SEQ(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_seq_cpy(
	    bl_fastq_t *bl_fastq_ptr,
	    char * new_seq,
	    size_t array_size
	)

{
    if ( new_seq == NULL )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_fastq_ptr->seq, new_seq, array_size);
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for plus member in a bl_fastq_t structure.
 *      Use this function to set plus in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      plus is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_plus        The new value for plus
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      char *          new_plus;
 *
 *      if ( bl_fastq_set_plus(&bl_fastq, new_plus)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_plus(
	    bl_fastq_t *bl_fastq_ptr,
	    char * new_plus
	)

{
    if ( new_plus == NULL )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->plus = new_plus;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of plus member in a bl_fastq_t
 *      structure. Use this function to set bl_fastq_ptr->plus[c]
 *      in a bl_fastq_t object from non-member functions.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      c               Subscript to the plus array
 *      new_plus_element The new value for plus[c]
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          c;
 *      char *          new_plus_element;
 *
 *      if ( bl_fastq_set_plus_ae(&bl_fastq, c, new_plus_element)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTQ_SET_PLUS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_plus_ae(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t c,
	    char  new_plus_element
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->plus[c] = new_plus_element;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for plus member in a bl_fastq_t structure.
 *      Use this function to set plus in a bl_fastq_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_plus to bl_fastq_ptr->plus.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_plus        The new value for plus
 *      array_size      Size of the plus array.
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      char *          new_plus;
 *      size_t          array_size;
 *
 *      if ( bl_fastq_set_plus_cpy(&bl_fastq, new_plus, array_size)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTQ_SET_PLUS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_plus_cpy(
	    bl_fastq_t *bl_fastq_ptr,
	    char * new_plus,
	    size_t array_size
	)

{
    if ( new_plus == NULL )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_fastq_ptr->plus, new_plus, array_size);
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for qual member in a bl_fastq_t structure.
 *      Use this function to set qual in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      qual is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_qual        The new value for qual
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      char *          new_qual;
 *
 *      if ( bl_fastq_set_qual(&bl_fastq, new_qual)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_qual(
	    bl_fastq_t *bl_fastq_ptr,
	    char * new_qual
	)

{
    if ( new_qual == NULL )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->qual = new_qual;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of qual member in a bl_fastq_t
 *      structure. Use this function to set bl_fastq_ptr->qual[c]
 *      in a bl_fastq_t object from non-member functions.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      c               Subscript to the qual array
 *      new_qual_element The new value for qual[c]
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          c;
 *      char *          new_qual_element;
 *
 *      if ( bl_fastq_set_qual_ae(&bl_fastq, c, new_qual_element)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTQ_SET_QUAL_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_qual_ae(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t c,
	    char  new_qual_element
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->qual[c] = new_qual_element;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for qual member in a bl_fastq_t structure.
 *      Use this function to set qual in a bl_fastq_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_qual to bl_fastq_ptr->qual.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_qual        The new value for qual
 *      array_size      Size of the qual array.
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      char *          new_qual;
 *      size_t          array_size;
 *
 *      if ( bl_fastq_set_qual_cpy(&bl_fastq, new_qual, array_size)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTQ_SET_QUAL(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_qual_cpy(
	    bl_fastq_t *bl_fastq_ptr,
	    char * new_qual,
	    size_t array_size
	)

{
    if ( new_qual == NULL )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_fastq_ptr->qual, new_qual, array_size);
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for desc_array_size member in a bl_fastq_t structure.
 *      Use this function to set desc_array_size in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      desc_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_desc_array_size The new value for desc_array_size
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          new_desc_array_size;
 *
 *      if ( bl_fastq_set_desc_array_size(&bl_fastq, new_desc_array_size)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_desc_array_size(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t new_desc_array_size
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->desc_array_size = new_desc_array_size;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seq_array_size member in a bl_fastq_t structure.
 *      Use this function to set seq_array_size in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      seq_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_seq_array_size The new value for seq_array_size
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          new_seq_array_size;
 *
 *      if ( bl_fastq_set_seq_array_size(&bl_fastq, new_seq_array_size)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_seq_array_size(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t new_seq_array_size
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->seq_array_size = new_seq_array_size;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for plus_array_size member in a bl_fastq_t structure.
 *      Use this function to set plus_array_size in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      plus_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_plus_array_size The new value for plus_array_size
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          new_plus_array_size;
 *
 *      if ( bl_fastq_set_plus_array_size(&bl_fastq, new_plus_array_size)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_plus_array_size(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t new_plus_array_size
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->plus_array_size = new_plus_array_size;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for qual_array_size member in a bl_fastq_t structure.
 *      Use this function to set qual_array_size in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      qual_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_qual_array_size The new value for qual_array_size
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          new_qual_array_size;
 *
 *      if ( bl_fastq_set_qual_array_size(&bl_fastq, new_qual_array_size)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_qual_array_size(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t new_qual_array_size
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->qual_array_size = new_qual_array_size;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for desc_len member in a bl_fastq_t structure.
 *      Use this function to set desc_len in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      desc_len is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_desc_len    The new value for desc_len
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          new_desc_len;
 *
 *      if ( bl_fastq_set_desc_len(&bl_fastq, new_desc_len)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_desc_len(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t new_desc_len
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->desc_len = new_desc_len;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seq_len member in a bl_fastq_t structure.
 *      Use this function to set seq_len in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      seq_len is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_seq_len     The new value for seq_len
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          new_seq_len;
 *
 *      if ( bl_fastq_set_seq_len(&bl_fastq, new_seq_len)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_seq_len(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t new_seq_len
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->seq_len = new_seq_len;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for plus_len member in a bl_fastq_t structure.
 *      Use this function to set plus_len in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      plus_len is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_plus_len    The new value for plus_len
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          new_plus_len;
 *
 *      if ( bl_fastq_set_plus_len(&bl_fastq, new_plus_len)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_plus_len(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t new_plus_len
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->plus_len = new_plus_len;
	return BL_FASTQ_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fastq.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for qual_len member in a bl_fastq_t structure.
 *      Use this function to set qual_len in a bl_fastq_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      qual_len is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fastq_ptr    Pointer to the structure to set
 *      new_qual_len    The new value for qual_len
 *
 *  Returns:
 *      BL_FASTQ_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTQ_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fastq_t      bl_fastq;
 *      size_t          new_qual_len;
 *
 *      if ( bl_fastq_set_qual_len(&bl_fastq, new_qual_len)
 *              == BL_FASTQ_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fastq.h
 ***************************************************************************/

int     bl_fastq_set_qual_len(
	    bl_fastq_t *bl_fastq_ptr,
	    size_t new_qual_len
	)

{
    if ( false )
	return BL_FASTQ_DATA_OUT_OF_RANGE;
    else
    {
	bl_fastq_ptr->qual_len = new_qual_len;
	return BL_FASTQ_DATA_OK;
    }
}
