/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "bed.h"


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of chrom member in a bl_bed_t
 *      structure. Use this function to set bl_bed_ptr->chrom[c]
 *      in a bl_bed_t object from non-member functions.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      c               Subscript to the chrom array
 *      new_chrom_element The new value for chrom[c]
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      size_t          c;
 *      char            new_chrom_element;
 *
 *      if ( bl_bed_set_chrom_ae(&bl_bed, c, new_chrom_element)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_CHROM_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_chrom_ae(
	    bl_bed_t *bl_bed_ptr,
	    size_t c,
	    char new_chrom_element
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->chrom[c] = new_chrom_element;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for chrom member in a bl_bed_t structure.
 *      Use this function to set chrom in a bl_bed_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_chrom to bl_bed_ptr->chrom.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_chrom       The new value for chrom
 *      array_size      Size of the chrom array.
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      char            new_chrom;
 *      size_t          array_size;
 *
 *      if ( bl_bed_set_chrom_cpy(&bl_bed, new_chrom, array_size)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_CHROM(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_chrom_cpy(
	    bl_bed_t *bl_bed_ptr,
	    char new_chrom[],
	    size_t array_size
	)

{
    if ( new_chrom == NULL )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_bed_ptr->chrom, new_chrom, array_size);
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for chrom_start member in a bl_bed_t structure.
 *      Use this function to set chrom_start in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      chrom_start is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_chrom_start The new value for chrom_start
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      int64_t        new_chrom_start;
 *
 *      if ( bl_bed_set_chrom_start(&bl_bed, new_chrom_start)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_chrom_start(
	    bl_bed_t *bl_bed_ptr,
	    int64_t new_chrom_start
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->chrom_start = new_chrom_start;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for chrom_end member in a bl_bed_t structure.
 *      Use this function to set chrom_end in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      chrom_end is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_chrom_end   The new value for chrom_end
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      int64_t        new_chrom_end;
 *
 *      if ( bl_bed_set_chrom_end(&bl_bed, new_chrom_end)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_chrom_end(
	    bl_bed_t *bl_bed_ptr,
	    int64_t new_chrom_end
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->chrom_end = new_chrom_end;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of name member in a bl_bed_t
 *      structure. Use this function to set bl_bed_ptr->name[c]
 *      in a bl_bed_t object from non-member functions.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      c               Subscript to the name array
 *      new_name_element The new value for name[c]
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      size_t          c;
 *      char            new_name_element;
 *
 *      if ( bl_bed_set_name_ae(&bl_bed, c, new_name_element)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_NAME_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_name_ae(
	    bl_bed_t *bl_bed_ptr,
	    size_t c,
	    char new_name_element
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->name[c] = new_name_element;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for name member in a bl_bed_t structure.
 *      Use this function to set name in a bl_bed_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_name to bl_bed_ptr->name.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_name        The new value for name
 *      array_size      Size of the name array.
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      char            new_name;
 *      size_t          array_size;
 *
 *      if ( bl_bed_set_name_cpy(&bl_bed, new_name, array_size)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_NAME(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_name_cpy(
	    bl_bed_t *bl_bed_ptr,
	    char new_name[],
	    size_t array_size
	)

{
    if ( new_name == NULL )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_bed_ptr->name, new_name, array_size);
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for score member in a bl_bed_t structure.
 *      Use this function to set score in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      score is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_score       The new value for score
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      unsigned short  new_score;
 *
 *      if ( bl_bed_set_score(&bl_bed, new_score)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_score(
	    bl_bed_t *bl_bed_ptr,
	    unsigned short new_score
	)

{
    if ( new_score > 1000 )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->score = new_score;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for strand member in a bl_bed_t structure.
 *      Use this function to set strand in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      strand is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_strand      The new value for strand
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      char            new_strand;
 *
 *      if ( bl_bed_set_strand(&bl_bed, new_strand)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_strand(
	    bl_bed_t *bl_bed_ptr,
	    char new_strand
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->strand = new_strand;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for thick_start member in a bl_bed_t structure.
 *      Use this function to set thick_start in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      thick_start is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_thick_start The new value for thick_start
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      int64_t        new_thick_start;
 *
 *      if ( bl_bed_set_thick_start(&bl_bed, new_thick_start)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_thick_start(
	    bl_bed_t *bl_bed_ptr,
	    int64_t new_thick_start
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->thick_start = new_thick_start;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for thick_end member in a bl_bed_t structure.
 *      Use this function to set thick_end in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      thick_end is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_thick_end   The new value for thick_end
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      int64_t        new_thick_end;
 *
 *      if ( bl_bed_set_thick_end(&bl_bed, new_thick_end)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_thick_end(
	    bl_bed_t *bl_bed_ptr,
	    int64_t new_thick_end
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->thick_end = new_thick_end;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of item_rgb member in a bl_bed_t
 *      structure. Use this function to set bl_bed_ptr->item_rgb[c]
 *      in a bl_bed_t object from non-member functions.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      c               Subscript to the item_rgb array
 *      new_item_rgb_element The new value for item_rgb[c]
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      size_t          c;
 *      char            new_item_rgb_element;
 *
 *      if ( bl_bed_set_item_rgb_ae(&bl_bed, c, new_item_rgb_element)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_ITEM_RGB_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_item_rgb_ae(
	    bl_bed_t *bl_bed_ptr,
	    size_t c,
	    char new_item_rgb_element
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->item_rgb[c] = new_item_rgb_element;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for item_rgb member in a bl_bed_t structure.
 *      Use this function to set item_rgb in a bl_bed_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_item_rgb to bl_bed_ptr->item_rgb.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_item_rgb    The new value for item_rgb
 *      array_size      Size of the item_rgb array.
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      char            new_item_rgb;
 *      size_t          array_size;
 *
 *      if ( bl_bed_set_item_rgb_cpy(&bl_bed, new_item_rgb, array_size)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_ITEM_RGB(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_item_rgb_cpy(
	    bl_bed_t *bl_bed_ptr,
	    char new_item_rgb[],
	    size_t array_size
	)

{
    if ( new_item_rgb == NULL )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_bed_ptr->item_rgb, new_item_rgb, array_size);
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for block_count member in a bl_bed_t structure.
 *      Use this function to set block_count in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      block_count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_block_count The new value for block_count
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      unsigned short  new_block_count;
 *
 *      if ( bl_bed_set_block_count(&bl_bed, new_block_count)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_block_count(
	    bl_bed_t *bl_bed_ptr,
	    unsigned short new_block_count
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->block_count = new_block_count;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for block_sizes member in a bl_bed_t structure.
 *      Use this function to set block_sizes in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      block_sizes is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_block_sizes The new value for block_sizes
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      int64_t *      new_block_sizes;
 *
 *      if ( bl_bed_set_block_sizes(&bl_bed, new_block_sizes)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_block_sizes(
	    bl_bed_t *bl_bed_ptr,
	    int64_t * new_block_sizes
	)

{
    if ( new_block_sizes == NULL )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->block_sizes = new_block_sizes;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of block_sizes member in a bl_bed_t
 *      structure. Use this function to set bl_bed_ptr->block_sizes[c]
 *      in a bl_bed_t object from non-member functions.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      c               Subscript to the block_sizes array
 *      new_block_sizes_element The new value for block_sizes[c]
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      size_t          c;
 *      int64_t *      new_block_sizes_element;
 *
 *      if ( bl_bed_set_block_sizes_ae(&bl_bed, c, new_block_sizes_element)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_BLOCK_SIZES_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_block_sizes_ae(
	    bl_bed_t *bl_bed_ptr,
	    size_t c,
	    int64_t  new_block_sizes_element
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->block_sizes[c] = new_block_sizes_element;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for block_sizes member in a bl_bed_t structure.
 *      Use this function to set block_sizes in a bl_bed_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_block_sizes to bl_bed_ptr->block_sizes.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_block_sizes The new value for block_sizes
 *      array_size      Size of the block_sizes array.
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      int64_t *      new_block_sizes;
 *      size_t          array_size;
 *
 *      if ( bl_bed_set_block_sizes_cpy(&bl_bed, new_block_sizes, array_size)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_BLOCK_SIZES(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_block_sizes_cpy(
	    bl_bed_t *bl_bed_ptr,
	    int64_t * new_block_sizes,
	    size_t array_size
	)

{
    if ( new_block_sizes == NULL )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_bed_ptr->block_sizes[c] = new_block_sizes[c];
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for block_starts member in a bl_bed_t structure.
 *      Use this function to set block_starts in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      block_starts is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_block_starts The new value for block_starts
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      int64_t *      new_block_starts;
 *
 *      if ( bl_bed_set_block_starts(&bl_bed, new_block_starts)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_block_starts(
	    bl_bed_t *bl_bed_ptr,
	    int64_t * new_block_starts
	)

{
    if ( new_block_starts == NULL )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->block_starts = new_block_starts;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of block_starts member in a bl_bed_t
 *      structure. Use this function to set bl_bed_ptr->block_starts[c]
 *      in a bl_bed_t object from non-member functions.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      c               Subscript to the block_starts array
 *      new_block_starts_element The new value for block_starts[c]
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      size_t          c;
 *      int64_t *      new_block_starts_element;
 *
 *      if ( bl_bed_set_block_starts_ae(&bl_bed, c, new_block_starts_element)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_BLOCK_STARTS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_block_starts_ae(
	    bl_bed_t *bl_bed_ptr,
	    size_t c,
	    int64_t  new_block_starts_element
	)

{
    if ( false )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->block_starts[c] = new_block_starts_element;
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for block_starts member in a bl_bed_t structure.
 *      Use this function to set block_starts in a bl_bed_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_block_starts to bl_bed_ptr->block_starts.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_block_starts The new value for block_starts
 *      array_size      Size of the block_starts array.
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      int64_t *      new_block_starts;
 *      size_t          array_size;
 *
 *      if ( bl_bed_set_block_starts_cpy(&bl_bed, new_block_starts, array_size)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_BED_SET_BLOCK_STARTS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_block_starts_cpy(
	    bl_bed_t *bl_bed_ptr,
	    int64_t * new_block_starts,
	    size_t array_size
	)

{
    if ( new_block_starts == NULL )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    bl_bed_ptr->block_starts[c] = new_block_starts[c];
	return BL_BED_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/bed.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for fields member in a bl_bed_t structure.
 *      Use this function to set fields in a bl_bed_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      fields is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_bed_ptr      Pointer to the structure to set
 *      new_fields      The new value for fields
 *
 *  Returns:
 *      BL_BED_DATA_OK if the new value is acceptable and assigned
 *      BL_BED_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_bed_t        bl_bed;
 *      unsigned short  new_fields;
 *
 *      if ( bl_bed_set_fields(&bl_bed, new_fields)
 *              == BL_BED_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from bed.h
 ***************************************************************************/

int     bl_bed_set_fields(
	    bl_bed_t *bl_bed_ptr,
	    unsigned short new_fields
	)

{
    if ( (new_fields < 3) || (new_fields > 9) )
	return BL_BED_DATA_OUT_OF_RANGE;
    else
    {
	bl_bed_ptr->fields = new_fields;
	return BL_BED_DATA_OK;
    }
}
