/**  --------------------------------------------------------------------
 *  @file  tools.cc
 *  @brief  Implementation of miscellaneous tools.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  ------------------------------------------------------------------ **/
#include <errno.h>
#include <cstring>

#include "tools.h"

using namespace ::std;
using namespace Binc;

//------------------------------------------------------------------------
Tools::Tools(void)
{
}

//------------------------------------------------------------------------
Tools &Tools::getInstance(void)
{
  static Tools tools;
  return tools;
}

//------------------------------------------------------------------------
void Tools::setenv(const string &key, const string &value) const
{
  char *c = strdup((key + "=" + value).c_str());
  putenv(c);
}

//------------------------------------------------------------------------
string Tools::getenv(const string &key) const
{
  static const string NIL = "";

  const char *c = ::getenv((char *)key.c_str());
  if (c == 0)
    return NIL;
  else
    return string(c);
}
