/**  --------------------------------------------------------------------
 *  @file syslogdevice.cc
 *  @brief  Implementation of the SyslogDevice class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002, 2003
 *  -----------------------------------------------------------------  **/
#include "syslogdevice.h"
#include <string>

#include <syslog.h>

using namespace ::std;
using namespace ::Binc;

//------------------------------------------------------------------------
string SyslogDevice::ident;

//------------------------------------------------------------------------
SyslogDevice::SyslogDevice(int f, const char *i, int o, int fa) 
  : IODevice(f), option(o), facility(fa), priority(LOG_INFO)
{
  ident = i;
  openlog(ident.c_str(), option, facility);
}

//------------------------------------------------------------------------
SyslogDevice::~SyslogDevice(void)
{
  closelog();
}

//------------------------------------------------------------------------
string SyslogDevice::service(void) const
{
  return "log";
}

//------------------------------------------------------------------------
bool SyslogDevice::waitForWrite(void) const
{
  return true;
}

//------------------------------------------------------------------------
bool SyslogDevice::waitForRead(void) const
{
  return false;
}

//------------------------------------------------------------------------
IODevice::WriteResult SyslogDevice::write(void)
{
  string out;
  string::const_iterator i = outputBuffer.str().begin();
  string::const_iterator ie = outputBuffer.str().end();

  for (; i != ie; ++i) {
    if (*i == '\n') {
      syslog(priority, out.c_str(), out.size());
      out = "";
    } else if (*i != '\r')
      out += *i;
  }
  
  if (out != "") syslog(priority, out.c_str(), out.size());

  outputBuffer.clear();
  return WriteDone;
}

//------------------------------------------------------------------------
bool SyslogDevice::fillInputBuffer(void)
{
  return false;
}
