/** --------------------------------------------------------------------
 *  @file  regex.cc
 *  @brief Implementation of miscellaneous regexp functions
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include "regmatch.h"
#include <string>

#include <sys/types.h>
#include <regex.h>
#include <stdio.h>

using namespace ::std;

//------------------------------------------------------------------------
int Binc::regexMatch(const string &data_in, const string &p_in)
{
  regex_t r;
  regmatch_t rm[2];

  if (regcomp(&r, p_in.c_str(), REG_EXTENDED | REG_NOSUB) != 0)
    return 2;

  int n = regexec(&r, data_in.c_str(), data_in.length(), rm, 0);
  regfree(&r);
  if (n == 0)
    return 0;
  else
    return 2;
}
