/**  --------------------------------------------------------------------
 *  @file  operator-unsubscribe.cc
 *  @brief Implementation of the UNSUBSCRIBE command.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include <string>
#include <vector>
#include <iostream>
#include "convert.h"
#include <sys/stat.h>

#include "recursivedescent.h"

#include "session.h"
#include "depot.h"
#include "operators.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
UnsubscribeOperator::UnsubscribeOperator(void)
{
}

//----------------------------------------------------------------------
UnsubscribeOperator::~UnsubscribeOperator(void)
{
}

//----------------------------------------------------------------------
const string UnsubscribeOperator::getName(void) const
{
  return "UNSUBSCRIBE";
}

//----------------------------------------------------------------------
int UnsubscribeOperator::getState(void) const
{
  return Session::AUTHENTICATED | Session::SELECTED;
}

//------------------------------------------------------------------------
Operator::ProcessResult UnsubscribeOperator::process(Depot &depot,
                                                     Request &command)
{
  const string &mailbox = command.getMailbox();
  const string &canonmailbox = toCanonMailbox(mailbox);

  depot.loadSubscribes();
  if (!depot.unsubscribeTo(canonmailbox)) {
    Session &session = Session::getInstance();
    session.setLastError("Not subscribed to " + toImapString(mailbox));
    return NO;
  }

  depot.saveSubscribes();

  return OK;
}

//----------------------------------------------------------------------
Operator::ParseResult UnsubscribeOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode())
    return REJECT;

  Operator::ParseResult res;
  if ((res = expectSPACE()) != ACCEPT) {
    session.setLastError("Expected SPACE");
    return res;
  }

  string mailbox;
  if ((res = expectMailbox(mailbox)) != ACCEPT) {
    session.setLastError("Expected mailbox");
    return res;
  }

  if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF");
    return res;
  }

  c_in.setMailbox(mailbox);

  return ACCEPT;
}
