/**  --------------------------------------------------------------------
 *  @file  operator-subscribe.cc
 *  @brief Implementation of the SUBSCRIBE command.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include <string>
#include <iostream>
#include "convert.h"
#include <sys/stat.h>

#include "recursivedescent.h"

#include "session.h"
#include "depot.h"
#include "operators.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
SubscribeOperator::SubscribeOperator(void)
{
}

//----------------------------------------------------------------------
SubscribeOperator::~SubscribeOperator(void)
{
}

//----------------------------------------------------------------------
const string SubscribeOperator::getName(void) const
{
  return "SUBSCRIBE";
}

//----------------------------------------------------------------------
int SubscribeOperator::getState(void) const
{
  return Session::AUTHENTICATED | Session::SELECTED;
}

//------------------------------------------------------------------------
Operator::ProcessResult SubscribeOperator::process(Depot &depot,
                                                   Request &command)
{
  const string &srcmailbox = command.getMailbox();
  const string &canonmailbox = toCanonMailbox(srcmailbox);

  depot.loadSubscribes();
  depot.subscribeTo(canonmailbox);
  depot.saveSubscribes();

  return OK;
}

//----------------------------------------------------------------------
Operator::ParseResult SubscribeOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode())
    return REJECT;

  Operator::ParseResult res;
  if ((res = expectSPACE()) != ACCEPT) {
    session.setLastError("Expected SPACE");
    return res;
  }

  string mailbox;
  if ((res = expectMailbox(mailbox)) != ACCEPT) {
    session.setLastError("Expected mailbox");
    return res;
  }
  c_in.setMailbox(mailbox);

  if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF");
    return res;
  }

  return ACCEPT;
}
