/**  --------------------------------------------------------------------
 *  @file  operator-noop.cc
 *  @brief Operator for the NOOP command.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  ------------------------------------------------------------------ **/
#include <string>
#include <iostream>

#include "recursivedescent.h"
#include "session.h"
#include "depot.h"
#include "operators.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
NoopOperator::NoopOperator(void)
{
}

//----------------------------------------------------------------------
NoopOperator::~NoopOperator(void)
{
}

//----------------------------------------------------------------------
const string NoopOperator::getName(void) const
{
  return "NOOP";
}

//----------------------------------------------------------------------
int NoopOperator::getState(void) const
{
  return Session::NONAUTHENTICATED
       | Session::AUTHENTICATED
       | Session::SELECTED;
}

//----------------------------------------------------------------------
Operator::ProcessResult NoopOperator::process(Depot &depot,
                                              Request &command)
{
  return OK;
}

//----------------------------------------------------------------------
Operator::ParseResult NoopOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode()) return REJECT;

  Operator::ParseResult res;
  if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF after NOOP");
    return res;
  }

  c_in.setName("NOOP");

  return ACCEPT;
}
