/**  --------------------------------------------------------------------
 *  @file  operator-noop-pending.cc
 *  @brief  Operator for the NOOP command, with pending extension
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include <string>
#include <iostream>

#include "mailbox.h"
#include "pendingupdates.h"

#include "recursivedescent.h"
#include "session.h"
#include "depot.h"
#include "operators.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
NoopPendingOperator::NoopPendingOperator(void) : NoopOperator()
{
}

//----------------------------------------------------------------------
NoopPendingOperator::~NoopPendingOperator(void)
{
}

//----------------------------------------------------------------------
Operator::ProcessResult NoopPendingOperator::process(Depot &depot,
                                                     Request &command)
{
  Mailbox *mailbox = depot.getSelected();
  if (mailbox) {
    pendingUpdates(mailbox, PendingUpdates::EXPUNGE
                          | PendingUpdates::EXISTS 
                          | PendingUpdates::RECENT 
                          | PendingUpdates::FLAGS, true);
  }

  return OK;
}
