/**  --------------------------------------------------------------------
 *  @file  operator-namespace.cc
 *  @brief  Operator for the NAMESPACE command.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include <string>
#include <iostream>

#include "depot.h"
#include "iodevice.h"
#include "iofactory.h"
#include "operators.h"
#include "recursivedescent.h"
#include "session.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
NamespaceOperator::NamespaceOperator(void)
{
}

//----------------------------------------------------------------------
NamespaceOperator::~NamespaceOperator(void)
{
}

//----------------------------------------------------------------------
const string NamespaceOperator::getName(void) const
{
  return "NAMESPACE";
}

//----------------------------------------------------------------------
int NamespaceOperator::getState(void) const
{
  return Session::AUTHENTICATED | Session::SELECTED;
}

//----------------------------------------------------------------------
Operator::ProcessResult NamespaceOperator::process(Depot &depot,
                                                   Request &command)
{
  bincClient << "* NAMESPACE ";

  bincClient << "(("; // personal namespace
  bincClient << toImapString(depot.getPersonalNamespace());
  bincClient << " ";
  char c = depot.getDelimiter();
  bincClient << toImapString(string(&c, 1));
  bincClient << "))";

  bincClient << " NIL"; // others' namespaces
  bincClient << " NIL"; // shared namespaces
  bincClient << endl;

  return OK;
}

//----------------------------------------------------------------------
Operator::ParseResult NamespaceOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode())
    return REJECT;

  Operator::ParseResult res;
  if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF after NAMESPACE");
    return res;
  }

  c_in.setName("NAMESPACE");

  return ACCEPT;
}
