/**  --------------------------------------------------------------------
 *  @file operator-logout.cc
 *  @brief  Implementation of the LOGOUT command
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include <string>
#include <iostream>

#include "iodevice.h"
#include "iofactory.h"

#include "mailbox.h"
#include "recursivedescent.h"
#include "session.h"
#include "convert.h"

#include "depot.h"
#include "operators.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
LogoutOperator::LogoutOperator(void)
{
}

//----------------------------------------------------------------------
LogoutOperator::~LogoutOperator(void)
{
}

//----------------------------------------------------------------------
const string LogoutOperator::getName(void) const
{
  return "LOGOUT";
}

//----------------------------------------------------------------------
int LogoutOperator::getState(void) const
{
  return Session::NONAUTHENTICATED
       | Session::AUTHENTICATED
       | Session::SELECTED;
}

//------------------------------------------------------------------------
Operator::ProcessResult LogoutOperator::process(Depot &depot,
                                                Request &command)
{
  bincClient << "* BYE Binc IMAP shutting down" << endl;
  bincClient << command.getTag() << " OK LOGOUT completed" << endl;
  bincClient.flush();
  
#ifdef BINCIMAPD
  Mailbox *mailbox = 0;
  if ((mailbox = depot.getSelected()) != 0) {
    mailbox->closeMailbox();
    delete mailbox;
  }
#endif
  
  Session &session = Session::getInstance();
  session.setState(Session::LOGOUT);

  return NOTHING;
}

//----------------------------------------------------------------------
Operator::ParseResult LogoutOperator::parse(Request & c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode())
    return REJECT;

  Operator::ParseResult res;
  if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF");
    return res;
  }

  c_in.setName("LOGOUT");
  return ACCEPT;
}
